<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Jenssegers\Date\Date;
use App\Models\Booking;

class BookingUpdate extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'booking:update';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Actualiza el estatus de los booking';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $yesterday = Date::now()->sub('1 day');
        $yesterday = $yesterday->format('Y-m-d');
        $bookings = Booking::where('status', 'Activo')->where('created_at', '<=', $yesterday)->get();
        foreach ($bookings as $key => $value) {
            $xmlstr = <<<XML
            <?xml version="1.0" encoding="UTF-8"?>
            <KIU_TravelItineraryReadRQ EchoToken="NATITATEST" TimeStamp="2012-11-13T15:03:11-03:00" Target="Testing" Version="3.0" SequenceNmbr="1" PrimaryLangID="en-us">
                <POS>
                    <Source AgentSine="MYCV0070B" TerminalID="MYCV00700B" ISOCountry="VE" ISOCurrency="USD"/>
                </POS>
                <UniqueID Type="14" ID="$value->number" />
            </KIU_TravelItineraryReadRQ>
            XML;

            $curl = curl_init();
            curl_setopt_array($curl, array(
                CURLOPT_URL => 'https://ssl00.kiusys.com/ws3/index.php',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS => 'user=VIAJES360GLOBE&password=wQknr9@yvVl$6X98&request='.$xmlstr,
                CURLOPT_HTTPHEADER => array(
                    'Content-Type: application/x-www-form-urlencoded'
                ),
            ));

            $response = curl_exec($curl);
            curl_close($curl);
            $xml = simplexml_load_string($response, "SimpleXMLElement", LIBXML_NOCDATA);
            $json = json_encode($xml);
            $array_json = json_decode($json,TRUE);
            if(isset($array_json['TravelItinerary']['ItineraryInfo']['Ticketing']['@attributes'])) {
                $data = $array_json['TravelItinerary']['ItineraryInfo']['Ticketing']['@attributes'];
                if($data['TicketingStatus'] == '5') {
                    $value->status = 'Cancelado';
                    $value->save();
                }
            }
        }
    }
}
