<?php

namespace App\DataTables\Backend;

use App\Models\Country;
use Yajra\DataTables\Services\DataTable;

class CountryDataTable extends DataTable
{
	public function dataTable($query)
	{
		return datatables($query)
        ->rawColumns(['action'])
        ->addColumn('action', function ($dato) {
            $show = route('countries.show',[encrypt($dato->id)]);
            $edit = route('countries.edit',[encrypt($dato->id)]);
            $delete = route('countries.destroy',[encrypt($dato->id)]);
            return '
                <div class="btn-group btn-group-sm" role="group" aria-lebel="Small button group">
                    <a class="btn btn-xs2 btn-info btn-icon btn-icon-sm" title="Detalle" href="'.$show.'"><i class="fa fa-search"></i></a>
                    <a class="btn btn-xs2 btn-warning btn-icon btn-icon-sm" title="Modificar" href="'.$edit.'"><i class="fa fa-edit"></i></a>
                    <botton class="btn btn-xs2 btn-danger btn-icon btn-icon-sm delete" title="Eliminar" data-url="'.$delete.'"><i class="fa fa-trash"></i></botton>
                </div>
            ';
        });
	}

	public function query(Country $model)
    {
        return $model->newQuery()->select('id', 'name')->orderBy('name', 'asc');
    }

    public function html()
    {
        return $this->builder()
        ->columns($this->getColumns())
        ->minifiedAjax(url()->current())
        ->addAction(['width' => '80px','title'=>'Opciones','exportable' => false, 'printable' => false])
        ->parameters([
            'bFilter' => false,
            'buttons' => [],
            'dom'=> "<'row'<'col-sm-6 text-left'f><'col-sm-6 text-right'B>>\n\t\t\t<'row'<'col-sm-12'tr>>\n\t\t\t<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>",
            'language' => ['url' => asset('backend/assets/vendors/custom/datatables/spanish.json')],
            "drawCallback"=> "function (settings) {
                $('.delete').click(function () {
                    var x = $(this).data('n');
                    $('#eliminar').modal('show');
                    var url = $(this).attr('data-url');
                    $('#form_eliminar').attr('action', url);
                });
            }",
        ]);
    }

    protected function getColumns()
    {
        return [
            ['data' => 'name', 'title' => 'Nombre'],
        ];
    }
}