<?php

namespace App\DataTables\Backend;

use Spatie\Permission\Models\Role;
use Yajra\DataTables\Services\DataTable;

class RoleDataTable extends DataTable
{
	public function dataTable($query)
	{
		return datatables($query)
        ->editColumn('name', function($dato) {
            return ucfirst($dato->name);
        })
        ->editColumn('created_at', function($dato) {
            return $dato->created_at->format('d-m-Y');
        })
        ->rawColumns(['action'])
        ->addColumn('action', function ($dato) {
            $show = route('roles.show',[encrypt($dato->id)]);
            $edit = route('roles.edit',[encrypt($dato->id)]);
            return '
                <div class="btn-group btn-group-sm" role="group" aria-lebel="Small button group">
                    <a class="btn btn-xs2 btn-info btn-icon btn-icon-sm" title="Detalle" href="'.$show.'"><i class="fa fa-search"></i></a>
                    <a class="btn btn-xs2 btn-warning btn-icon btn-icon-sm" title="Modificar" href="'.$edit.'"><i class="fa fa-edit"></i></a>
                </div>
            ';
        });
	}

	public function query(Role $model)
    {
        return $model->newQuery()->select('id', 'name', 'created_at')->orderBy('id', 'desc');
    }

    public function html()
    {
        return $this->builder()
        ->columns($this->getColumns())
        ->minifiedAjax()
        ->addAction(['width' => '80px','title'=>'Opciones','exportable' => false, 'printable' => false])
        ->parameters([
            'bFilter' => false,
            'buttons' => [],
            'dom'=> "<'row'<'col-sm-6 text-left'f><'col-sm-6 text-right'B>>\n\t\t\t<'row'<'col-sm-12'tr>>\n\t\t\t<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>",
            'language' => ['url' => asset('backend/assets/vendors/custom/datatables/spanish.json')],
            "drawCallback"=> "function (settings) {
                $('.delete').click(function () {
                    var x = $(this).data('n');
                    $('#eliminar').modal('show');
                    var url = $(this).attr('data-url');
                    $('#form_eliminar').attr('action', url);
                });
            }",
        ]);
    }

    protected function getColumns()
    {
        return [
            ['data' => 'name', 'title' => 'Rol'],
            ['data' => 'created_at', 'title' => 'Creado'],
        ];
    }
}