<?php

namespace App\DataTables\Backend;

use App\Models\User;
use Yajra\DataTables\Services\DataTable;

class UserDataTable extends DataTable
{
	public function dataTable($query)
	{
		return datatables($query)
        ->editColumn('role', function($dato) {
            $rol = implode( ", ", $dato->getRoleNames()->toArray());
            return ucfirst($rol);
        })
        ->editColumn('status', function($dato) {
            if ($dato->status == 'Activo') {
                return '<span class="kt-font-bold kt-font-success">'.$dato->status.'</span>';
            } else {
                return '<span class="kt-font-bold kt-font-danger">'.$dato->status.'</span>';
            }
        })
        ->rawColumns(['status', 'action'])
        ->addColumn('action', function ($dato) {
            $show = route('users.show',[encrypt($dato->id)]);
            $edit = route('users.edit',[encrypt($dato->id)]);
            $delete = route('users.destroy',[encrypt($dato->id)]);
            return '
                <div class="btn-group btn-group-sm" role="group" aria-lebel="Small button group">
                    <a class="btn btn-xs2 btn-info btn-icon btn-icon-sm" title="Detalle" href="'.$show.'"><i class="fa fa-search"></i></a>
                    <a class="btn btn-xs2 btn-warning btn-icon btn-icon-sm" title="Modificar" href="'.$edit.'"><i class="fa fa-edit"></i></a>
                    <botton class="btn btn-xs2 btn-danger btn-icon btn-icon-sm delete" title="Eliminar" data-url="'.$delete.'"><i class="fa fa-trash"></i></botton>
                </div>
            ';
        });
	}

	public function query(User $model)
    {
        return $model->newQuery()->select('id', 'name', 'last_name', 'email', 'status')->orderBy('id', 'desc');
    }

    public function html()
    {
        return $this->builder()
        ->columns($this->getColumns())
        ->minifiedAjax(url()->current())
        ->addAction(['width' => '80px','title'=>'Opciones','exportable' => false, 'printable' => false])
        ->parameters([
            'bFilter' => false,
            'buttons' => [],
            'dom'=> "<'row'<'col-sm-6 text-left'f><'col-sm-6 text-right'B>>\n\t\t\t<'row'<'col-sm-12'tr>>\n\t\t\t<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>",
            'language' => ['url' => asset('backend/assets/vendors/custom/datatables/spanish.json')],
            "drawCallback"=> "function (settings) {
                $('.delete').click(function () {
                    var x = $(this).data('n');
                    $('#eliminar').modal('show');
                    var url = $(this).attr('data-url');
                    $('#form_eliminar').attr('action', url);
                });
            }",
        ]);
    }

    protected function getColumns()
    {
        return [
            ['data' => 'name', 'title' => 'Nombre'],
            ['data' => 'last_name', 'title' => 'Apellido'],
            ['data' => 'email', 'title' => 'Email'],
            ['data' => 'role', 'title' => 'Rol'],
            ['data' => 'status', 'title' => 'Estatus'],
        ];
    }
}