<?php

namespace App\Http\Controllers\Panel;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Crypt;
use App\DataTables\Backend\AirlineDataTable;
use App\Models\Airline;
use App\Models\AirlineHistory;
use Auth;

class AirlineController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(AirlineDataTable $dataTable)
    {
        return $dataTable->render('panel.airlines.index');
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('panel.airlines.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $this->validate($request,[
            'name' => 'required',
            'code' => 'required|unique:airlines'
        ]);

        $airline = new Airline();
        $airline->name = $request->name;
        $airline->code = strtoupper($request->code);
        if ($airline->save()) {
            $history = new AirlineHistory();
            $history->data = json_encode($_POST);
            $history->data_ip = ipGeo();
            $history->status = 'Creado';
            $history->airline_id = $airline->id;
            $history->user_id = Auth::user()->id;
            $history->save();

            return redirect()->route('airlines.show', encrypt($airline->id))->with('success', 'Registro creado exitosamente.');
        } else {
            return redirect()->back()->with('error', 'Error al crear el registro.'); 
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        $id = Crypt::decrypt($id);
        $airline = Airline::findOrFail($id);
        $history = $airline->airlineHistory;

        return view('panel.airlines.show', compact('airline', 'history'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        $id = Crypt::decrypt($id);
        $airline = Airline::findOrFail($id);

        return view('panel.airlines.edit', compact('airline'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        $id = Crypt::decrypt($id);
        $airline = Airline::findOrFail($id);

        $this->validate($request,[
            'name' => 'required',
            'code' => 'required|unique:airlines,code,'.$airline->id,
        ]);

        $airline->name = $request->name;
        $airline->code = strtoupper($request->code);
        if ($airline->save()) {
            $history = new AirlineHistory();
            $history->data = json_encode($_POST);
            $history->data_ip = ipGeo();
            $history->status = 'Modificado';
            $history->airline_id = $airline->id;
            $history->user_id = Auth::user()->id;
            $history->save();

            return redirect()->route('airlines.show', encrypt($airline->id))->with('success', 'Registro actualizado exitosamente.');
        } else {
            return redirect()->back()->with('error', 'Error al crear el registro.'); 
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
