<?php

namespace App\Http\Controllers\Panel;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use DB;

class AjaxController extends Controller
{
    public function roleAssignment(Request $request)
    {
        if ($request->ajax()) {
            $rol = $request->rol;

            $assignment = Permission::select('permissions.id', 'permissions.name')
            ->join('role_has_permissions', 'role_has_permissions.permission_id', '=', 'permissions.id')
            ->where('role_has_permissions.role_id', $rol)
            ->get();

            $array_permission = array();
            foreach ($assignment as $key => $value) {
                $array_permission[] = $value->id;
            }

            $no_assignment = DB::table('permissions')
            ->select('permissions.id', 'permissions.name')
            ->whereNotIn('permissions.id', $array_permission)
            ->get();

            return response()->json([
                'assignment' => $assignment,
                'no_assignment' => $no_assignment
            ]);
        }
    }
}
