<?php

namespace App\Http\Controllers\Panel;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Airport;
use App\Models\FareSelectedFlight;
use App\Models\FlightClass;
use App\Models\SelectedSeat;
use App\Models\Seating;
use App\Models\BookingPassenger;
use Auth;
use DB;

class AjaxFlightController extends Controller
{
    public function destinationAirport(Request $request)
    {
        if ($request->ajax()) {
            $origin_airport = $request->origin_airport;
            $airports = Airport::select('airports.id', 'airports.iso_iata', 'countries.iso', DB::raw('CONCAT(countries.iso, " - ", cities.name, " - ", airports.iso_iata) AS name'))
            ->join('countries', 'countries.id', '=', 'airports.country_id')
            ->join('cities', 'cities.id', '=', 'airports.city_id')
            ->where('airports.iso_iata', '<>', $origin_airport)
            ->orderBy('countries.iso', 'desc')
            ->get();

            return response()->json([
                'destinations' => $airports
            ]); 
        }
    }

    public function selectFeeDeparture(Request $request)
    {
        if ($request->ajax()) {
            $flight_class = $request->flight_class;
            $class = FlightClass::findOrFail($flight_class);

            $selected = FareSelectedFlight::where('user_id', Auth::user()->id)->get();
            if (count($selected) > 0) {
                foreach ($selected as $key => $value) {
                    if ($class->flight->type == $value->flightClass->flight->type) {
                        $coincidence = true;
                        $flight_class_id = $value->flight_class_id;
                        break;
                    } else {
                        $coincidence = null;
                    }
                }

                if ($coincidence == true) {
                    $query = FareSelectedFlight::where('flight_class_id', $flight_class_id)->where('user_id', Auth::user()->id)->first();
                    $query->flight_class_id = $flight_class;
                    if ($query->save()){
                        $flag = true;
                    } else {
                        $flag = false;
                    } 
                } else {
                    $insert = new FareSelectedFlight();
                    $insert->flight_class_id = $flight_class;
                    $insert->user_id = Auth::user()->id;
                    if ($insert->save()){
                        $flag = true;
                    } else {
                        $flag = false;
                    }
                }
            } else {
                $insert = new FareSelectedFlight();
                $insert->flight_class_id = $flight_class;
                $insert->user_id = Auth::user()->id;
                if ($insert->save()){
                    $flag = true;
                } else {
                    $flag = false;
                }
            }

            return response()->json([
                'flag' => $flag
            ]);
        }
    }

    public function selectFeeReturn(Request $request)
    {
        if ($request->ajax()) {
            $return_class = $request->return_class;

            $selected = FareSelectedFlight::where('user_id', Auth::user()->id)->first();
            if (!$selected) {
                $insert = new FareSelectedFlight();
                $insert->return_flight_class_id = $return_class;
                $insert->user_id = Auth::user()->id;
                if ($insert->save()){
                    $flag = true;
                } else {
                    $flag = false;
                }
            } else {
                $selected->return_flight_class_id = $return_class;
                if ($selected->save()){
                    $flag = true;
                } else {
                    $flag = false;
                }
            }

            return response()->json([
                'flag' => $flag
            ]);
        }
    }

    public function selectSeating(Request $request)
    {
        if ($request->ajax()) {
            //$seating = Seating::findOrFail($request->seating);
            //$passenger = BookingPassenger::findOrFail($request->passenger);
            if($request->type == 'going') {
                SelectedSeat::where('booking_passenger_id', $request->passenger)->where('type', 'going')->delete();
            } else {
                SelectedSeat::where('booking_passenger_id', $request->passenger)->where('type', 'return')->delete();
            }
            
            $selected = new SelectedSeat();
            $selected->type = $request->type;
            $selected->seating_id = $request->seating;
            $selected->booking_passenger_id = $request->passenger;
            $selected->user_id = Auth::user()->id;
            if($selected->save()) {
                $flag = true;
            } else {
                $flag = false;
            }

            return response()->json([
                'flag' => $flag
            ]);
        }
    }
}
