<?php

namespace App\Http\Controllers\Panel;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\State;
use App\Models\City;

class AjaxLocationController extends Controller
{
    public function state(Request $request)
    {
        if ($request->ajax()) {
            $country = $request->country;
            $state = State::where('country_id', $country)->orderBy('name', 'asc')->get();

            return response()->json([
                'state' => $state
            ]); 
        }
    }

    public function city(Request $request)
    {
        if ($request->ajax()) {
            $state = $request->state;
            $city = City::where('state_id', $state)->orderBy('name', 'asc')->get();

            return response()->json([
                'city' => $city
            ]); 
        }
    }
}
