<?php

namespace App\Http\Controllers\Panel;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Country;
use App\Models\State;
use App\Models\City;
use App\Models\Hotel;

class AjaxTourismController extends Controller
{
    public function addItem(Request $request)
    {
        if ($request->ajax()) {
            session_start();

            $type = $request->type;
            $number_type = $request->number_type;
            $product = intval($request->product);
            $amount = $request->amount;
            $quantity = $request->quantity;
            $total = $request->total;
            $observation = $request->observation;
            $hotel = Hotel::findOrFail($product);
            $hotel_name = $hotel->name;

            if (!isset($_SESSION["items"]) || count($_SESSION["items"]) < 1) {
                $items = array();
                $items[] = array('type' => $type, 'number_type' => $number_type, 'product' => $hotel_name, 'amount' => $amount, 'quantity' => $quantity, 'total' => $total, 'observation' => $observation);
                $_SESSION["items"] = $items;
            } else {
                $items = $_SESSION["items"];
                $items[] = array('type' => $type, 'number_type' => $number_type, 'product' => $hotel_name, 'amount' => $amount, 'quantity' => $quantity, 'total' => $total, 'observation' => $observation);
                $_SESSION["items"] = $items;
            }

            $html = '';
            $html.='<div class="list-item">';
                $html.='<table class="table">';
                    $html.='<thead class="thead-light">';
                        $html.='<tr>';
                            $html.='<th>Tipo</th>';
                            $html.='<th>Hotel / Hospedaje / Seguros / Transporte</th>';
                            $html.='<th>Tarifa</th>';
                            $html.='<th>Cantidad</th>';
                            $html.='<th>Total</th>';
                            $html.='<th></th>';
                        $html.='</tr>';
                    $html.='</thead>';
                    $html.='<tbody>';
                        $total_amount = 0;
                        foreach ($items as $key => $value) {
                            $total_amount = $total_amount + ($value['amount'] * $value['quantity']);
                            $html.='<tr>';
                                if ($value['type'] == 'ADT') {
                                    $html.='<td>'.$value['number_type'].' Adulto</td>';
                                } else {
                                    $html.='<td>'.$value['number_type'].' Niños</td>';
                                }
                                $html.='<td>'.$value['product'].'</td>';
                                $html.='<td>$ '.number_format($value['amount'], 2).'</td>';
                                $html.='<td>'.number_format($value['quantity'], 2).'</td>';
                                $html.='<td>$ '.number_format($value['total'], 2).'</td>';
                                $html.='<td><div class="btn-group btn-group-sm"><button type="button" attr-delete="'.$key.'" class="btn btn-xs2 btn-danger btn-icon btn-icon-sm delete-item"><i class="fa fa-trash"></i></button></div></td>';
                            $html.='</tr>';
                        }
                        $html.='<tr>';
                            $html.='<td colspan="3"></td>';
                            $html.='<td>Total</td>';
                            $html.='<td>$ '.number_format($total_amount, 2).'</td>';
                        $html.='</tr>';
                    $html.='</tbody>';
                $html.='</table>';
            $html.='</div>';

            return response()->json([
                'html' => $html
            ]);
        }
    }

    public function deleteItem (Request $request)
    {
        if ($request->ajax()) {
            session_start();
            $id = $request->id;
            $items = $_SESSION["items"];
            foreach ($items as $key => $value) {
                if($key == $id){
                    unset($items[$key]);
                    $_SESSION["items"] = $items;
                }
            }

            $html = '';
            $html.='<div class="list-item">';
                $html.='<table class="table">';
                    $html.='<thead class="thead-light">';
                        $html.='<tr>';
                            $html.='<th>Tipo</th>';
                            $html.='<th>Hotel / Hospedaje</th>';
                            $html.='<th>Tarifa</th>';
                            $html.='<th>Cantidad</th>';
                            $html.='<th>Total</th>';
                            $html.='<th></th>';
                        $html.='</tr>';
                    $html.='</thead>';
                    $html.='<tbody>';
                        $total_amount = 0;
                        foreach ($items as $key => $value) {
                            $total_amount = $total_amount + ($value['amount'] * $value['quantity']);
                            $html.='<tr>';
                                if ($value['type'] == 'ADT') {
                                    $html.='<td>'.$value['number_type'].' Adulto</td>';
                                } else {
                                    $html.='<td>'.$value['number_type'].' Niños</td>';
                                }
                                $html.='<td>'.$value['product'].'</td>';
                                $html.='<td>'.number_format($value['amount'], 2).'</td>';
                                $html.='<td>'.number_format($value['quantity'], 2).'</td>';
                                $html.='<td>'.number_format($value['total'], 2).'</td>';
                                $html.='<td><div class="btn-group btn-group-sm"><button type="button" attr-delete="'.$key.'" class="btn btn-xs2 btn-danger btn-icon btn-icon-sm delete-item"><i class="fa fa-trash"></i></button></div></td>';
                            $html.='</tr>';
                        }
                        $html.='<tr>';
                            $html.='<td colspan="3"></td>';
                            $html.='<td>Total</td>';
                            $html.='<td>$ '.number_format($total_amount, 2).'</td>';
                        $html.='</tr>';
                    $html.='</tbody>';
                $html.='</table>';
            $html.='</div>';

            return response()->json([
                'html' => $html
            ]);
        }
    }

    ////////////

    public function addInsurance (Request $request)
    {
        if ($request->ajax()) {
            session_start();

            $type = $request->type;
            $number_type = $request->number_type;
            $insurance = $request->insurance;
            $amount = $request->amount;
            $quantity = 1;
            $total = $request->total;
            $observation = $request->observation;

            if (!isset($_SESSION["items_insurance"]) || count($_SESSION["items_insurance"]) < 1) {
                $items_insurance = array();
                $items_insurance[] = array('type' => $type, 'number_type' => $number_type, 'insurance' => $insurance, 'amount' => $amount, 'quantity' => $quantity, 'total' => $total, 'observation' => $observation);
                $_SESSION["items_insurance"] = $items_insurance;
            } else {
                $items_insurance = $_SESSION["items_insurance"];
                $items_insurance[] = array('type' => $type, 'number_type' => $number_type, 'insurance' => $insurance, 'amount' => $amount, 'quantity' => $quantity, 'total' => $total, 'observation' => $observation);
                $_SESSION["items_insurance"] = $items_insurance;
            }

            $html = '';
            $html.='<div class="list-item">';
                $html.='<table class="table">';
                    $html.='<thead class="thead-light">';
                        $html.='<tr>';
                            $html.='<th>Tipo</th>';
                            $html.='<th>Seguro</th>';
                            $html.='<th>Tarifa</th>';
                            $html.='<th>Cantidad</th>';
                            $html.='<th>Total</th>';
                            $html.='<th></th>';
                        $html.='</tr>';
                    $html.='</thead>';
                    $html.='<tbody>';
                        $total_amount = 0;
                        foreach ($items_insurance as $key => $value) {
                            $total_amount = $total_amount + ($value['amount'] * $value['quantity']);
                            $html.='<tr>';
                                if ($value['type'] == 'ADT') {
                                    $html.='<td>'.$value['number_type'].' Adulto</td>';
                                } else {
                                    $html.='<td>'.$value['number_type'].' Niños</td>';
                                }
                                $html.='<td>'.$value['insurance'].'</td>';
                                $html.='<td>$ '.$value['amount'].'</td>';
                                $html.='<td>'.$value['quantity'].'</td>';
                                $html.='<td>$ '.$value['total'].'</td>';
                                $html.='<td><div class="btn-group btn-group-sm"><button type="button" attr-delete="'.$key.'" class="btn btn-xs2 btn-danger btn-icon btn-icon-sm delete-item"><i class="fa fa-trash"></i></button></div></td>';
                            $html.='</tr>';
                        }
                        $html.='<tr>';
                            $html.='<td colspan="3"></td>';
                            $html.='<td>Total</td>';
                            $html.='<td>$ '.number_format($total_amount, 2).'</td>';
                        $html.='</tr>';
                    $html.='</tbody>';
                $html.='</table>';
            $html.='</div>';

            return response()->json([
                'html' => $html
            ]);
        }
    }

    public function deleteInsurance(Request $request)
    {
        if ($request->ajax()) {
            session_start();

            $id = $request->id;
            $items_insurance = $_SESSION["items_insurance"];
            foreach ($items_insurance as $key => $value) {
                if($key == $id){
                    unset($items_insurance[$key]);
                    $_SESSION["items_insurance"] = $items_insurance;
                }
            }

            $html = '';
            $html.='<div class="list-item">';
                $html.='<table class="table">';
                    $html.='<thead class="thead-light">';
                        $html.='<tr>';
                            $html.='<th>Tipo</th>';
                            $html.='<th>Seguro</th>';
                            $html.='<th>Tarifa</th>';
                            $html.='<th>Cantidad</th>';
                            $html.='<th>Total</th>';
                            $html.='<th></th>';
                        $html.='</tr>';
                    $html.='</thead>';
                    $html.='<tbody>';
                        $total_amount = 0;
                        foreach ($items_insurance as $key => $value) {
                            $total_amount = $total_amount + ($value['amount'] * $value['quantity']);
                            $html.='<tr>';
                                if ($value['type'] == 'ADT') {
                                    $html.='<td>'.$value['number_type'].' Adulto</td>';
                                } else {
                                    $html.='<td>'.$value['number_type'].' Niños</td>';
                                }
                                $html.='<td>'.$value['insurance'].'</td>';
                                $html.='<td>$ '.$value['amount'].'</td>';
                                $html.='<td>'.$value['quantity'].'</td>';
                                $html.='<td>$ '.$value['total'].'</td>';
                                $html.='<td><div class="btn-group btn-group-sm"><button type="button" attr-delete="'.$key.'" class="btn btn-xs2 btn-danger btn-icon btn-icon-sm delete-item"><i class="fa fa-trash"></i></button></div></td>';
                            $html.='</tr>';
                        }
                        $html.='<tr>';
                            $html.='<td colspan="3"></td>';
                            $html.='<td>Total</td>';
                            $html.='<td>$ '.number_format($total_amount, 2).'</td>';
                        $html.='</tr>';
                    $html.='</tbody>';
                $html.='</table>';
            $html.='</div>';

            return response()->json([
                'html' => $html
            ]);
        }
    }

    /*public function searchZone(Request $request)
    {
        if ($request->ajax()) {
            $term = $request->input('term');
            $cities = City::where('name', 'like', '%' . $term . '%')->with('state.country')->get();

            $formattedCities = [];
            foreach ($cities as $city) {
                $formattedCities[] = $city->name . ' - ' . $city->state->country->name;
            }

            return response()->json($formattedCities);
        }
    }*/

    public function searchZone(Request $request)
    {
        if ($request->ajax()) {
            $term = $request->input('term');
            
            $cities = City::where('name', 'like', '%' . $term . '%')->with('state.country')->get();

            $countries = Country::where('name', 'like', '%' . $term . '%')->get();

            $formattedResults = [];

            foreach ($cities as $city) {
                $formattedResults[] = $city->name . ' - ' . $city->state->country->name;
            }

            foreach ($countries as $country) {
                $cityExists = collect($cities)->contains(function ($city) use ($country) {
                    return $city->state->country->name === $country->name;
                });
                if (!$cityExists) {
                    $formattedResults[] = $country->name;
                }
            }

            return response()->json($formattedResults);
        }
    }

    public function selectHotel(Request $request)
    {
        if ($request->ajax()) {
            $city = $request->input('city');
            $country = $request->input('country');
            
            // Buscar hoteles por ciudad y país
            $hotels = Hotel::whereHas('city', function ($query) use ($city) {
                $query->where('name', $city);
            })->whereHas('country', function ($query) use ($country) {
                $query->where('name', $country);
            })->get();

            return response()->json($hotels);
        }
    }
}
