<?php

namespace App\Http\Controllers\Panel;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Crypt;
use Jenssegers\Date\Date;
use App\DataTables\Backend\BookingDataTable;
use App\Models\Booking;
use App\Models\BookingHistory;

class BookingController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(BookingDataTable $dataTable)
    {
        return $dataTable->render('panel.bookings.index');
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        session_start();
        $id = Crypt::decrypt($id);
        $booking = Booking::findOrFail($id);
        $booking_flight = $booking->bookingFlight;
        $passengers = $booking->bookingPassenger;

        if (isset($booking_flight[1])) {
            $flight_departure = $booking_flight[0];
            $flight_return = $booking_flight[1];
            $amount_departure = $flight_departure->bookingFlightClass->amount;
            $amount_return = $flight_return->bookingFlightClass->amount;
            $total_amount = $amount_departure + $amount_return;
        } else {
            $flight_departure = $booking_flight[0];
            $flight_return = null;
            $amount_departure = $flight_departure->bookingFlightClass->amount;
            $amount_return = 0;
            $total_amount = $amount_departure + $amount_return;
        }

        if($booking->status == 'Activo') {
            $xmlstr = <<<XML
            <?xml version="1.0" encoding="UTF-8"?>
            <KIU_TravelItineraryReadRQ EchoToken="NATITATEST" TimeStamp="2012-11-13T15:03:11-03:00" Target="Testing" Version="3.0" SequenceNmbr="1" PrimaryLangID="en-us">
                <POS>
                    <Source AgentSine="MYCV0070B" TerminalID="MYCV00700B" ISOCountry="VE" ISOCurrency="USD"/>
                </POS>
                <UniqueID Type="14" ID="$booking->number" />
            </KIU_TravelItineraryReadRQ>
            XML;

            $curl = curl_init();
            curl_setopt_array($curl, array(
                CURLOPT_URL => 'https://ssl00.kiusys.com/ws3/index.php',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS => 'user=VIAJES360GLOBE&password=wQknr9@yvVl$6X98&request='.$xmlstr,
                CURLOPT_HTTPHEADER => array(
                    'Content-Type: application/x-www-form-urlencoded'
                ),
            ));

            $response = curl_exec($curl);
            curl_close($curl);
            $xml = simplexml_load_string($response, "SimpleXMLElement", LIBXML_NOCDATA);
            $json = json_encode($xml);
            $array_json = json_decode($json,TRUE);
            
            if(isset($array_json['TravelItinerary']['ItineraryInfo']['Ticketing']['@attributes'])) {
                $data = $array_json['TravelItinerary']['ItineraryInfo']['Ticketing']['@attributes'];
                if($data['TicketingStatus'] == '5') {
                    $booking->status = 'Cancelado';
                    $booking->save();
                }
            }
        }

        return view('panel.bookings.show', compact('booking', 'flight_departure', 'flight_return', 'total_amount', 'passengers'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
