<?php

namespace App\Http\Controllers\Panel;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Crypt;
use App\Models\Airline;
use App\Models\Airport;
use App\Models\State;
use App\Models\City;
use App\Models\Country;
use App\Models\Flight;
use App\Models\FlightClass;
use App\Models\FlightClassPassenger;
use App\Models\FareSelectedFlight;
use App\Models\Passenger;
use App\Models\Booking;
use App\Models\BookingHistory;
use App\Models\BookingFlight;
use App\Models\BookingFlightClass;
use App\Models\BookingFlightClassPassenger;
use App\Models\BookingPassenger;
use App\Models\Seating;
use App\Models\SelectedSeat;
use App\Models\BookingPassengerSeat;
use Jenssegers\Date\Date;
use Auth;
use DB;

class FlightController extends Controller
{
    public function flights()
    {
        Flight::where('user_id', Auth::user()->id)->delete();
        FlightClass::where('user_id', Auth::user()->id)->delete();
        FlightClassPassenger::where('user_id', Auth::user()->id)->delete();
        FareSelectedFlight::where('user_id', Auth::user()->id)->delete();
        Passenger::where('user_id', Auth::user()->id)->delete();
        $airlines = Airline::pluck('name', 'code');
        $airports = Airport::select('airports.id', 'airports.iso_iata', 'countries.iso', DB::raw('CONCAT(countries.iso, " - ", cities.name, " - ", airports.iso_iata) AS name'))
        ->join('countries', 'countries.id', '=', 'airports.country_id')
        ->join('cities', 'cities.id', '=', 'airports.city_id')
        ->orderBy('countries.iso', 'desc')
        ->pluck('cities.name', 'airports.iso_iata');

        return view('panel.flights.search', compact('airlines', 'airports'));
    }

    public function query(Request $request)
    {
        //dd($_POST);
        set_time_limit(0);
        ini_set('memory_limit','512M');
        Passenger::where('user_id', Auth::user()->id)->delete();
        $airline = $request->airline;
        $departure_date = $request->departure_date;
        $return_date = $request->return_date;
        $origin_airport = $request->origin_airport;
        $destination_airport = $request->destination_airport;
        $adt = $request->adt;
        $inf = $request->inf;
        $cnn = $request->cnn;

        if(!$inf){
            $inf = 0;
        }

        if(!$cnn){
            $cnn = 0;
        }

        if (!isset($request->return_date)) {
            $xmlstr = <<<XML
            <?xml version="1.0" encoding="UTF-8"?>
            <KIU_AirAvailRQ EchoToken="1" TimeStamp="2013-01-24T19:20:43+00:00" Target="Testing" Version="3.0" SequenceNmbr="1" PrimaryLangID="en-us" DirectFlightsOnly="false" CombinedItineraries="false">
                <POS>
                    <Source AgentSine="MYCV0070B" TerminalID="MYCV00700B" ISOCountry="VE" />
                </POS>
                <SpecificFlightInfo>
                    <Airline Code="$airline" />
                </SpecificFlightInfo>
                <OriginDestinationInformation>
                    <DepartureDateTime>$departure_date</DepartureDateTime>
                    <OriginLocation LocationCode="$origin_airport" />
                    <DestinationLocation LocationCode="$destination_airport" />
                </OriginDestinationInformation>
                <TravelPreferences MaxStopsQuantity="">
                    <CabinPref Cabin="" />
                </TravelPreferences>
                <TravelerInfoSummary>
                    <AirTravelerAvail>
                        <PassengerTypeQuantity Code="ADT" Quantity="$adt" />
                        <PassengerTypeQuantity Code="INF" Quantity="$inf" />
                        <PassengerTypeQuantity Code="CNN" Quantity="$cnn" />
                    </AirTravelerAvail>
                </TravelerInfoSummary>
            </KIU_AirAvailRQ>
            XML;
        } else {
            $xmlstr = <<<XML
            <?xml version="1.0" encoding="UTF-8"?>
            <KIU_AirAvailRQ EchoToken="1" TimeStamp="2013-01-24T19:20:43+00:00" Target="Testing" Version="3.0" SequenceNmbr="1" PrimaryLangID="en-us" DirectFlightsOnly="false" CombinedItineraries="false">
                <POS>
                    <Source AgentSine="MYCV0070B" TerminalID="MYCV00700B" ISOCountry="VE" />
                </POS>
                <SpecificFlightInfo>
                    <Airline Code="$airline" />
                </SpecificFlightInfo>
                <OriginDestinationInformation>
                    <DepartureDateTime>$departure_date</DepartureDateTime>
                    <OriginLocation LocationCode="$origin_airport" />
                    <DestinationLocation LocationCode="$destination_airport" />
                </OriginDestinationInformation>
                <OriginDestinationInformation>
                    <DepartureDateTime>$return_date</DepartureDateTime>
                    <OriginLocation LocationCode="$destination_airport" />
                    <DestinationLocation LocationCode="$origin_airport" />
                </OriginDestinationInformation>
                <TravelPreferences MaxStopsQuantity="">
                    <CabinPref Cabin="" />
                </TravelPreferences>
                <TravelerInfoSummary>
                    <AirTravelerAvail>
                        <PassengerTypeQuantity Code="ADT" Quantity="$adt" />
                        <PassengerTypeQuantity Code="INF" Quantity="$inf" />
                        <PassengerTypeQuantity Code="CNN" Quantity="$cnn" />
                    </AirTravelerAvail>
                </TravelerInfoSummary>
            </KIU_AirAvailRQ>
            XML;
        }

        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://ssl00.kiusys.com/ws3/index.php',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => 'user=VIAJES360GLOBE&password=wQknr9@yvVl$6X98&request='.$xmlstr,
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/x-www-form-urlencoded'
            ),
        ));

        $response = curl_exec($curl);
        curl_close($curl);
        $xml = simplexml_load_string($response, "SimpleXMLElement", LIBXML_NOCDATA);
        $json = json_encode($xml);
        $array_json = json_decode($json,TRUE);
        if (!isset($request->return_date)) {
            $array_departure = $array_json['OriginDestinationInformation'];
        } else {
            $array_departure = $array_json['OriginDestinationInformation'][0];
            $array_return = $array_json['OriginDestinationInformation'][1];
            //dd($array_return);

            if($array_return['OriginDestinationOptions']) {
                $array_return = $array_return['OriginDestinationOptions']['OriginDestinationOption'];
                if (isset($array_return['FlightSegment'])) {
                    //CONSULTA BOLETOS DE VUELTA SELECCIONANDO AEROLINEA
                    $array_return = $array_return['FlightSegment'];
                    $flight_number = $array_return['@attributes']['FlightNumber'];
                    $departure_date_time = $array_return['@attributes']['DepartureDateTime'];
                    $arrival_date_time = $array_return['@attributes']['ArrivalDateTime'];
                    $stop_quantity = $array_return['@attributes']['StopQuantity'];
                    $journey_duration = $array_return['@attributes']['JourneyDuration'];
                    $company_short_name = $array_return['MarketingAirline']['@attributes']['CompanyShortName'];
                    $cabin = $array_return['MarketingCabin'];
                    $booking_class_avail = $array_return['BookingClassAvail'];
                    $array_price = array();
                    foreach ($booking_class_avail as $key => $value) {
                        $class_avail = $value['@attributes']['ResBookDesigCode'];

                        $xmlstr_price = <<<XML
                        <?xml version="1.0" encoding="UTF-8"?>
                        <KIU_AirPriceRQ EchoToken="1" TimeStamp="2023-05-18T12:00:00Z" Target="Testing" Version="3.0" SequenceNmbr="1" PrimaryLangID="en-us">
                            <POS>
                                <Source AgentSine="MYCV0070B" TerminalID="MYCV00700B" ISOCountry="VE" ISOCurrency="USD"/>
                                <RequestorID Type="5" />
                                <BookingChannel Type="1" />
                            </POS>
                            <AirItinerary>
                                <OriginDestinationOptions>
                                    <OriginDestinationOption>
                                        <FlightSegment DepartureDateTime="$departure_date_time" ArrivalDateTime="$arrival_date_time" FlightNumber="$flight_number" ResBookDesigCode="$class_avail" >
                                            <DepartureAirport LocationCode="$destination_airport"/>
                                            <ArrivalAirport LocationCode="$origin_airport"/>
                                            <MarketingAirline Code="$company_short_name"/>
                                        </FlightSegment>
                                    </OriginDestinationOption>
                                </OriginDestinationOptions>
                            </AirItinerary>
                            <TravelerInfoSummary>
                                <AirTravelerAvail>
                                    <PassengerTypeQuantity Code="ADT" Quantity="$adt"/>
                                    <PassengerTypeQuantity Code="INF" Quantity="$inf" />
                                    <PassengerTypeQuantity Code="CNN" Quantity="$cnn" />
                                </AirTravelerAvail>
                            </TravelerInfoSummary>
                        </KIU_AirPriceRQ>
                        XML;

                        $curl_price = curl_init();
                        curl_setopt_array($curl_price, array(
                            CURLOPT_URL => 'https://ssl00.kiusys.com/ws3/index.php',
                            CURLOPT_RETURNTRANSFER => true,
                            CURLOPT_ENCODING => '',
                            CURLOPT_MAXREDIRS => 10,
                            CURLOPT_TIMEOUT => 0,
                            CURLOPT_FOLLOWLOCATION => true,
                            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                            CURLOPT_CUSTOMREQUEST => 'POST',
                            CURLOPT_POSTFIELDS => 'user=VIAJES360GLOBE&password=wQknr9@yvVl$6X98&request='.$xmlstr_price,
                            CURLOPT_HTTPHEADER => array(
                                'Content-Type: application/x-www-form-urlencoded'
                            ),
                        ));

                        $response_price = curl_exec($curl_price);
                        curl_close($curl_price);
                        $xml_price = simplexml_load_string($response_price, "SimpleXMLElement", LIBXML_NOCDATA);
                        $json_price = json_encode($xml_price);
                        $array_json_price = json_decode($json_price,TRUE);
                        if(isset($array_json_price['Success'])){
                            $departure_date_time = $array_json_price['PricedItineraries']['PricedItinerary']['AirItinerary']['OriginDestinationOptions']['OriginDestinationOption']['FlightSegment']['@attributes']['DepartureDateTime'];
                            $arrival_date_time = $array_json_price['PricedItineraries']['PricedItinerary']['AirItinerary']['OriginDestinationOptions']['OriginDestinationOption']['FlightSegment']['@attributes']['ArrivalDateTime'];
                            $flight_number = $array_json_price['PricedItineraries']['PricedItinerary']['AirItinerary']['OriginDestinationOptions']['OriginDestinationOption']['FlightSegment']['@attributes']['FlightNumber'];
                            $res_book_desig_code = $array_json_price['PricedItineraries']['PricedItinerary']['AirItinerary']['OriginDestinationOptions']['OriginDestinationOption']['FlightSegment']['@attributes']['ResBookDesigCode'];
                            $departure_airport = $array_json_price['PricedItineraries']['PricedItinerary']['AirItinerary']['OriginDestinationOptions']['OriginDestinationOption']['FlightSegment']['DepartureAirport']['@attributes']['LocationCode'];
                            $arrival_airport = $array_json_price['PricedItineraries']['PricedItinerary']['AirItinerary']['OriginDestinationOptions']['OriginDestinationOption']['FlightSegment']['ArrivalAirport']['@attributes']['LocationCode'];
                            $company_short_name = $array_json_price['PricedItineraries']['PricedItinerary']['AirItinerary']['OriginDestinationOptions']['OriginDestinationOption']['FlightSegment']['MarketingAirline']['@attributes']['Code'];
                            $amount = $array_json_price['PricedItineraries']['PricedItinerary']['AirItineraryPricingInfo']['ItinTotalFare']['TotalFare']['@attributes']['Amount'];
                            $res_book_desig_code = $value['@attributes']['ResBookDesigCode'];
                            $res_book_desig_quantity = $value['@attributes']['ResBookDesigQuantity'];
                            $rph = $value['@attributes']['RPH'];

                            $query_return_flight = Flight::where('departure_date_time', $departure_date_time)
                            ->where('arrival_date_time', $arrival_date_time)
                            ->where('flight_number', $flight_number)
                            ->where('departure_airport', $departure_airport)
                            ->where('arrival_airport', $arrival_airport)
                            ->where('company_short_name', $company_short_name)
                            ->where('stop_quantity', $stop_quantity)
                            ->where('user_id', Auth::user()->id)
                            ->first();

                            if ($query_return_flight) {
                                $return_flight_class = new FlightClass();
                                $return_flight_class->res_book_desig_code = $res_book_desig_code;
                                $return_flight_class->res_book_desig_quantity = $res_book_desig_quantity;
                                $return_flight_class->rph = $rph;
                                $return_flight_class->amount = $amount;
                                $return_flight_class->flight_id = $query_return_flight->id;
                                $return_flight_class->user_id = Auth::user()->id;
                                $return_flight_class->save();

                                $fareBreakdowns = $array_json_price['PricedItineraries']['PricedItinerary']['AirItineraryPricingInfo']['PTC_FareBreakdowns']['PTC_FareBreakdown'];

                                if(isset($fareBreakdowns['PassengerTypeQuantity'])){
                                    $PassengerTypeQuantity = $fareBreakdowns['PassengerTypeQuantity'];
                                    $return_passenger_classes = new FlightClassPassenger();
                                    $return_passenger_classes->passenger_type = $PassengerTypeQuantity['@attributes']['Code'];
                                    $return_passenger_classes->passenger_quantity = $PassengerTypeQuantity['@attributes']['Quantity'];
                                    $return_passenger_classes->flight_class_id = $return_flight_class->id;
                                    $return_passenger_classes->user_id = Auth::user()->id;
                                    $return_passenger_classes->save();
                                }else{
                                    foreach ($fareBreakdowns as $key_fb => $value_fb) {
                                        if (isset($value_fb['PassengerTypeQuantity'])) {
                                            $return_passenger_classes = new FlightClassPassenger();
                                            $return_passenger_classes->passenger_type = $value_fb['PassengerTypeQuantity']['@attributes']['Code'];
                                            $return_passenger_classes->passenger_quantity = $value_fb['PassengerTypeQuantity']['@attributes']['Quantity'];
                                            $return_passenger_classes->flight_class_id = $return_flight_class->id;
                                            $return_passenger_classes->user_id = Auth::user()->id;
                                            $return_passenger_classes->save();
                                        }
                                    }
                                }
                            } else {
                                $return_flight = new Flight();
                                $return_flight->flight_number = $flight_number;
                                $return_flight->departure_date_time = $departure_date_time;
                                $return_flight->arrival_date_time = $arrival_date_time;
                                $return_flight->departure_airport = $departure_airport;
                                $return_flight->arrival_airport = $arrival_airport;
                                $return_flight->company_short_name = $company_short_name;
                                $return_flight->stop_quantity = $stop_quantity;
                                $return_flight->journey_duration = $journey_duration;
                                $return_flight->type = 'return';
                                $return_flight->user_id = Auth::user()->id;
                                $return_flight->save();

                                $return_flight_class = new FlightClass();
                                $return_flight_class->res_book_desig_code = $res_book_desig_code;
                                $return_flight_class->res_book_desig_quantity = $res_book_desig_quantity;
                                $return_flight_class->rph = $rph;
                                $return_flight_class->amount = $amount;
                                $return_flight_class->flight_id = $return_flight->id;
                                $return_flight_class->user_id = Auth::user()->id;
                                $return_flight_class->save();

                                $fareBreakdowns = $array_json_price['PricedItineraries']['PricedItinerary']['AirItineraryPricingInfo']['PTC_FareBreakdowns']['PTC_FareBreakdown'];

                                if(isset($fareBreakdowns['PassengerTypeQuantity'])){
                                    $PassengerTypeQuantity = $fareBreakdowns['PassengerTypeQuantity'];
                                    $return_passenger_classes = new FlightClassPassenger();
                                    $return_passenger_classes->passenger_type = $PassengerTypeQuantity['@attributes']['Code'];
                                    $return_passenger_classes->passenger_quantity = $PassengerTypeQuantity['@attributes']['Quantity'];
                                    $return_passenger_classes->flight_class_id = $return_flight_class->id;
                                    $return_passenger_classes->user_id = Auth::user()->id;
                                    $return_passenger_classes->save();
                                }else{
                                    foreach ($fareBreakdowns as $key_fb => $value_fb) {
                                        if (isset($value_fb['PassengerTypeQuantity'])) {
                                            $return_passenger_classes = new FlightClassPassenger();
                                            $return_passenger_classes->passenger_type = $value_fb['PassengerTypeQuantity']['@attributes']['Code'];
                                            $return_passenger_classes->passenger_quantity = $value_fb['PassengerTypeQuantity']['@attributes']['Quantity'];
                                            $return_passenger_classes->flight_class_id = $return_flight_class->id;
                                            $return_passenger_classes->user_id = Auth::user()->id;
                                            $return_passenger_classes->save();
                                        }
                                    }
                                }
                            }
                        }
                    }
                } else {
                    //CONSULTA BOLETOS DE VUELTA SIN SELECCIONAR AEROLINEA
                    foreach ($array_return as $key => $value) {
                        if (isset($value['FlightSegment']['@attributes'])) {
                            $flight_number = $value['FlightSegment']['@attributes']['FlightNumber'];
                            $departure_date_time = $value['FlightSegment']['@attributes']['DepartureDateTime'];
                            $arrival_date_time = $value['FlightSegment']['@attributes']['ArrivalDateTime'];
                            $stop_quantity = $value['FlightSegment']['@attributes']['StopQuantity'];
                            $journey_duration = $value['FlightSegment']['@attributes']['JourneyDuration'];
                            $company_short_name = $value['FlightSegment']['MarketingAirline']['@attributes']['CompanyShortName'];
                            $cabin = $value['FlightSegment']['MarketingCabin'];
                            $booking_class_avail = $value['FlightSegment']['BookingClassAvail'];
                            foreach ($booking_class_avail as $key2 => $value2) {
                                if (isset($booking_class_avail['@attributes'])) {
                                    $class_avail = $booking_class_avail['@attributes']['ResBookDesigCode'];
                                } else {
                                    $class_avail = $value2['@attributes']['ResBookDesigCode'];
                                }

                                $xmlstr_price = <<<XML
                                <?xml version="1.0" encoding="UTF-8"?>
                                <KIU_AirPriceRQ EchoToken="1" TimeStamp="2023-05-18T12:00:00Z" Target="Testing" Version="3.0" SequenceNmbr="1" PrimaryLangID="en-us">
                                    <POS>
                                        <Source AgentSine="MYCV0070B" TerminalID="MYCV00700B" ISOCountry="VE" ISOCurrency="USD"/>
                                        <RequestorID Type="5" />
                                        <BookingChannel Type="1" />
                                    </POS>
                                    <AirItinerary>
                                        <OriginDestinationOptions>
                                            <OriginDestinationOption>
                                                <FlightSegment DepartureDateTime="$departure_date_time" ArrivalDateTime="$arrival_date_time" FlightNumber="$flight_number" ResBookDesigCode="$class_avail" >
                                                    <DepartureAirport LocationCode="$destination_airport"/>
                                                    <ArrivalAirport LocationCode="$origin_airport"/>
                                                    <MarketingAirline Code="$company_short_name"/>
                                                </FlightSegment>
                                            </OriginDestinationOption>
                                        </OriginDestinationOptions>
                                    </AirItinerary>
                                    <TravelerInfoSummary>
                                        <AirTravelerAvail>
                                            <PassengerTypeQuantity Code="ADT" Quantity="$adt"/>
                                            <PassengerTypeQuantity Code="INF" Quantity="$inf" />
                                            <PassengerTypeQuantity Code="CNN" Quantity="$cnn" />
                                        </AirTravelerAvail>
                                    </TravelerInfoSummary>
                                </KIU_AirPriceRQ>
                                XML;

                                $curl_price = curl_init();
                                curl_setopt_array($curl_price, array(
                                    CURLOPT_URL => 'https://ssl00.kiusys.com/ws3/index.php',
                                    CURLOPT_RETURNTRANSFER => true,
                                    CURLOPT_ENCODING => '',
                                    CURLOPT_MAXREDIRS => 10,
                                    CURLOPT_TIMEOUT => 0,
                                    CURLOPT_FOLLOWLOCATION => true,
                                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                                    CURLOPT_CUSTOMREQUEST => 'POST',
                                    CURLOPT_POSTFIELDS => 'user=VIAJES360GLOBE&password=wQknr9@yvVl$6X98&request='.$xmlstr_price,
                                    CURLOPT_HTTPHEADER => array(
                                        'Content-Type: application/x-www-form-urlencoded'
                                    ),
                                ));

                                $response_price = curl_exec($curl_price);
                                curl_close($curl_price);
                                $xml_price = simplexml_load_string($response_price, "SimpleXMLElement", LIBXML_NOCDATA);
                                $json_price = json_encode($xml_price);
                                $array_json_price = json_decode($json_price,TRUE);
                                if(isset($array_json_price['Success'])){
                                    $departure_date_time = $array_json_price['PricedItineraries']['PricedItinerary']['AirItinerary']['OriginDestinationOptions']['OriginDestinationOption']['FlightSegment']['@attributes']['DepartureDateTime'];
                                    $arrival_date_time = $array_json_price['PricedItineraries']['PricedItinerary']['AirItinerary']['OriginDestinationOptions']['OriginDestinationOption']['FlightSegment']['@attributes']['ArrivalDateTime'];
                                    $flight_number = $array_json_price['PricedItineraries']['PricedItinerary']['AirItinerary']['OriginDestinationOptions']['OriginDestinationOption']['FlightSegment']['@attributes']['FlightNumber'];
                                    $res_book_desig_code = $array_json_price['PricedItineraries']['PricedItinerary']['AirItinerary']['OriginDestinationOptions']['OriginDestinationOption']['FlightSegment']['@attributes']['ResBookDesigCode'];
                                    $departure_airport = $array_json_price['PricedItineraries']['PricedItinerary']['AirItinerary']['OriginDestinationOptions']['OriginDestinationOption']['FlightSegment']['DepartureAirport']['@attributes']['LocationCode'];
                                    $arrival_airport = $array_json_price['PricedItineraries']['PricedItinerary']['AirItinerary']['OriginDestinationOptions']['OriginDestinationOption']['FlightSegment']['ArrivalAirport']['@attributes']['LocationCode'];
                                    $company_short_name = $array_json_price['PricedItineraries']['PricedItinerary']['AirItinerary']['OriginDestinationOptions']['OriginDestinationOption']['FlightSegment']['MarketingAirline']['@attributes']['Code'];
                                    $amount = $array_json_price['PricedItineraries']['PricedItinerary']['AirItineraryPricingInfo']['ItinTotalFare']['TotalFare']['@attributes']['Amount'];
                                    if (isset($value2['@attributes'])) {
                                        $res_book_desig_code = $value2['@attributes']['ResBookDesigCode'];
                                        $res_book_desig_quantity = $value2['@attributes']['ResBookDesigQuantity'];
                                        $rph = $value2['@attributes']['RPH'];
                                    }

                                    $query_return_flight = Flight::where('departure_date_time', $departure_date_time)
                                    ->where('arrival_date_time', $arrival_date_time)
                                    ->where('flight_number', $flight_number)
                                    ->where('departure_airport', $departure_airport)
                                    ->where('arrival_airport', $arrival_airport)
                                    ->where('company_short_name', $company_short_name)
                                    ->where('stop_quantity', $stop_quantity)
                                    ->where('user_id', Auth::user()->id)
                                    ->first();

                                    if ($query_return_flight) {
                                        $return_flight_class = new FlightClass();
                                        $return_flight_class->res_book_desig_code = $res_book_desig_code;
                                        $return_flight_class->res_book_desig_quantity = $res_book_desig_quantity;
                                        $return_flight_class->rph = $rph;
                                        $return_flight_class->amount = $amount;
                                        $return_flight_class->flight_id = $query_return_flight->id;
                                        $return_flight_class->user_id = Auth::user()->id;
                                        $return_flight_class->save();

                                        $fareBreakdowns = $array_json_price['PricedItineraries']['PricedItinerary']['AirItineraryPricingInfo']['PTC_FareBreakdowns']['PTC_FareBreakdown'];

                                        if(isset($fareBreakdowns['PassengerTypeQuantity'])){
                                            $PassengerTypeQuantity = $fareBreakdowns['PassengerTypeQuantity'];
                                            $return_passenger_classes = new FlightClassPassenger();
                                            $return_passenger_classes->passenger_type = $PassengerTypeQuantity['@attributes']['Code'];
                                            $return_passenger_classes->passenger_quantity = $PassengerTypeQuantity['@attributes']['Quantity'];
                                            $return_passenger_classes->flight_class_id = $return_flight_class->id;
                                            $return_passenger_classes->user_id = Auth::user()->id;
                                            $return_passenger_classes->save();
                                        }else{
                                            foreach ($fareBreakdowns as $key_fb => $value_fb) {
                                                if (isset($value_fb['PassengerTypeQuantity'])) {
                                                    $return_passenger_classes = new FlightClassPassenger();
                                                    $return_passenger_classes->passenger_type = $value_fb['PassengerTypeQuantity']['@attributes']['Code'];
                                                    $return_passenger_classes->passenger_quantity = $value_fb['PassengerTypeQuantity']['@attributes']['Quantity'];
                                                    $return_passenger_classes->flight_class_id = $return_flight_class->id;
                                                    $return_passenger_classes->user_id = Auth::user()->id;
                                                    $return_passenger_classes->save();
                                                }
                                            }
                                        }
                                    } else {
                                        $return_flight = new Flight();
                                        $return_flight->flight_number = $flight_number;
                                        $return_flight->departure_date_time = $departure_date_time;
                                        $return_flight->arrival_date_time = $arrival_date_time;
                                        $return_flight->departure_airport = $departure_airport;
                                        $return_flight->arrival_airport = $arrival_airport;
                                        $return_flight->company_short_name = $company_short_name;
                                        $return_flight->stop_quantity = $stop_quantity;
                                        $return_flight->journey_duration = $journey_duration;
                                        $return_flight->type = 'return';
                                        $return_flight->user_id = Auth::user()->id;
                                        $return_flight->save();
                                        
                                        $return_flight_class = new FlightClass();
                                        $return_flight_class->res_book_desig_code = $res_book_desig_code;
                                        $return_flight_class->res_book_desig_quantity = $res_book_desig_quantity;
                                        $return_flight_class->rph = $rph;
                                        $return_flight_class->amount = $amount;
                                        $return_flight_class->flight_id = $return_flight->id;
                                        $return_flight_class->user_id = Auth::user()->id;
                                        $return_flight_class->save();

                                        $fareBreakdowns = $array_json_price['PricedItineraries']['PricedItinerary']['AirItineraryPricingInfo']['PTC_FareBreakdowns']['PTC_FareBreakdown'];

                                        if(isset($fareBreakdowns['PassengerTypeQuantity'])){
                                            $PassengerTypeQuantity = $fareBreakdowns['PassengerTypeQuantity'];
                                            $return_passenger_classes = new FlightClassPassenger();
                                            $return_passenger_classes->passenger_type = $PassengerTypeQuantity['@attributes']['Code'];
                                            $return_passenger_classes->passenger_quantity = $PassengerTypeQuantity['@attributes']['Quantity'];
                                            $return_passenger_classes->flight_class_id = $return_flight_class->id;
                                            $return_passenger_classes->user_id = Auth::user()->id;
                                            $return_passenger_classes->save();
                                        }else{
                                            foreach ($fareBreakdowns as $key_fb => $value_fb) {
                                                if (isset($value_fb['PassengerTypeQuantity'])) {
                                                    $return_passenger_classes = new FlightClassPassenger();
                                                    $return_passenger_classes->passenger_type = $value_fb['PassengerTypeQuantity']['@attributes']['Code'];
                                                    $return_passenger_classes->passenger_quantity = $value_fb['PassengerTypeQuantity']['@attributes']['Quantity'];
                                                    $return_passenger_classes->flight_class_id = $return_flight_class->id;
                                                    $return_passenger_classes->user_id = Auth::user()->id;
                                                    $return_passenger_classes->save();
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }

        if($array_departure['OriginDestinationOptions']) {
            $array_departure = $array_departure['OriginDestinationOptions']['OriginDestinationOption'];
            if (isset($array_departure['FlightSegment'])) {
                //CONSULTA BOLETOS DE IDA SELECCIONANDO AEROLINEA
                $array_departure = $array_departure['FlightSegment'];
                $flight_number = $array_departure['@attributes']['FlightNumber'];
                $departure_date_time = $array_departure['@attributes']['DepartureDateTime'];
                $arrival_date_time = $array_departure['@attributes']['ArrivalDateTime'];
                $stop_quantity = $array_departure['@attributes']['StopQuantity'];
                $journey_duration = $array_departure['@attributes']['JourneyDuration'];
                $company_short_name = $array_departure['MarketingAirline']['@attributes']['CompanyShortName'];
                $cabin = $array_departure['MarketingCabin'];
                $booking_class_avail = $array_departure['BookingClassAvail'];
                $array_price = array();
                foreach ($booking_class_avail as $key => $value) {
                    $class_avail = $value['@attributes']['ResBookDesigCode'];
                    
                    $xmlstr_price = <<<XML
                    <?xml version="1.0" encoding="UTF-8"?>
                    <KIU_AirPriceRQ EchoToken="1" TimeStamp="2023-05-18T12:00:00Z" Target="Testing" Version="3.0" SequenceNmbr="1" PrimaryLangID="en-us">
                        <POS>
                            <Source AgentSine="MYCV0070B" TerminalID="MYCV00700B" ISOCountry="VE" ISOCurrency="USD"/>
                            <RequestorID Type="5" />
                            <BookingChannel Type="1" />
                        </POS>
                        <AirItinerary>
                            <OriginDestinationOptions>
                                <OriginDestinationOption>
                                    <FlightSegment DepartureDateTime="$departure_date_time" ArrivalDateTime="$arrival_date_time" FlightNumber="$flight_number" ResBookDesigCode="$class_avail" >
                                        <DepartureAirport LocationCode="$origin_airport"/>
                                        <ArrivalAirport LocationCode="$destination_airport"/>
                                        <MarketingAirline Code="$company_short_name"/>
                                    </FlightSegment>
                                </OriginDestinationOption>
                            </OriginDestinationOptions>
                        </AirItinerary>
                        <TravelerInfoSummary>
                            <AirTravelerAvail>
                                <PassengerTypeQuantity Code="ADT" Quantity="$adt"/>
                                <PassengerTypeQuantity Code="INF" Quantity="$inf" />
                                <PassengerTypeQuantity Code="CNN" Quantity="$cnn" />
                            </AirTravelerAvail>
                        </TravelerInfoSummary>
                    </KIU_AirPriceRQ>
                    XML;

                    $curl_price = curl_init();
                    curl_setopt_array($curl_price, array(
                        CURLOPT_URL => 'https://ssl00.kiusys.com/ws3/index.php',
                        CURLOPT_RETURNTRANSFER => true,
                        CURLOPT_ENCODING => '',
                        CURLOPT_MAXREDIRS => 10,
                        CURLOPT_TIMEOUT => 0,
                        CURLOPT_FOLLOWLOCATION => true,
                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                        CURLOPT_CUSTOMREQUEST => 'POST',
                        CURLOPT_POSTFIELDS => 'user=VIAJES360GLOBE&password=wQknr9@yvVl$6X98&request='.$xmlstr_price,
                        CURLOPT_HTTPHEADER => array(
                            'Content-Type: application/x-www-form-urlencoded'
                        ),
                    ));

                    $response_price = curl_exec($curl_price);
                    curl_close($curl_price);
                    $xml_price = simplexml_load_string($response_price, "SimpleXMLElement", LIBXML_NOCDATA);
                    $json_price = json_encode($xml_price);
                    $array_json_price = json_decode($json_price,TRUE);
                    $array_price[] = $array_json_price;
                    if(isset($array_json_price['Success'])){
                        $departure_date_time = $array_json_price['PricedItineraries']['PricedItinerary']['AirItinerary']['OriginDestinationOptions']['OriginDestinationOption']['FlightSegment']['@attributes']['DepartureDateTime'];
                        $arrival_date_time = $array_json_price['PricedItineraries']['PricedItinerary']['AirItinerary']['OriginDestinationOptions']['OriginDestinationOption']['FlightSegment']['@attributes']['ArrivalDateTime'];
                        $flight_number = $array_json_price['PricedItineraries']['PricedItinerary']['AirItinerary']['OriginDestinationOptions']['OriginDestinationOption']['FlightSegment']['@attributes']['FlightNumber'];
                        $res_book_desig_code = $array_json_price['PricedItineraries']['PricedItinerary']['AirItinerary']['OriginDestinationOptions']['OriginDestinationOption']['FlightSegment']['@attributes']['ResBookDesigCode'];
                        $departure_airport = $array_json_price['PricedItineraries']['PricedItinerary']['AirItinerary']['OriginDestinationOptions']['OriginDestinationOption']['FlightSegment']['DepartureAirport']['@attributes']['LocationCode'];
                        $arrival_airport = $array_json_price['PricedItineraries']['PricedItinerary']['AirItinerary']['OriginDestinationOptions']['OriginDestinationOption']['FlightSegment']['ArrivalAirport']['@attributes']['LocationCode'];
                        $company_short_name = $array_json_price['PricedItineraries']['PricedItinerary']['AirItinerary']['OriginDestinationOptions']['OriginDestinationOption']['FlightSegment']['MarketingAirline']['@attributes']['Code'];
                        $amount = $array_json_price['PricedItineraries']['PricedItinerary']['AirItineraryPricingInfo']['ItinTotalFare']['TotalFare']['@attributes']['Amount'];
                        $res_book_desig_code = $value['@attributes']['ResBookDesigCode'];
                        $res_book_desig_quantity = $value['@attributes']['ResBookDesigQuantity'];
                        $rph = $value['@attributes']['RPH'];

                        $query_departure_flight = Flight::where('departure_date_time', $departure_date_time)
                        ->where('arrival_date_time', $arrival_date_time)
                        ->where('flight_number', $flight_number)
                        ->where('departure_airport', $departure_airport)
                        ->where('arrival_airport', $arrival_airport)
                        ->where('company_short_name', $company_short_name)
                        ->where('stop_quantity', $stop_quantity)
                        ->where('user_id', Auth::user()->id)
                        ->first();

                        if($query_departure_flight){
                            $departure_flight_class = new FlightClass();
                            $departure_flight_class->res_book_desig_code = $res_book_desig_code;
                            $departure_flight_class->res_book_desig_quantity = $res_book_desig_quantity;
                            $departure_flight_class->rph = $rph;
                            $departure_flight_class->amount = $amount;
                            $departure_flight_class->flight_id = $query_departure_flight->id;
                            $departure_flight_class->user_id = Auth::user()->id;
                            $departure_flight_class->save();

                            $fareBreakdowns = $array_json_price['PricedItineraries']['PricedItinerary']['AirItineraryPricingInfo']['PTC_FareBreakdowns']['PTC_FareBreakdown'];

                            if(isset($fareBreakdowns['PassengerTypeQuantity'])){
                                $PassengerTypeQuantity = $fareBreakdowns['PassengerTypeQuantity'];
                                $departure_passenger_classes = new FlightClassPassenger();
                                $departure_passenger_classes->passenger_type = $PassengerTypeQuantity['@attributes']['Code'];
                                $departure_passenger_classes->passenger_quantity = $PassengerTypeQuantity['@attributes']['Quantity'];
                                $departure_passenger_classes->flight_class_id = $departure_flight_class->id;
                                $departure_passenger_classes->user_id = Auth::user()->id;
                                $departure_passenger_classes->save();
                            }else{
                                foreach ($fareBreakdowns as $key_fb => $value_fb) {
                                    if (isset($value_fb['PassengerTypeQuantity'])) {
                                        $departure_passenger_classes = new FlightClassPassenger();
                                        $departure_passenger_classes->passenger_type = $value_fb['PassengerTypeQuantity']['@attributes']['Code'];
                                        $departure_passenger_classes->passenger_quantity = $value_fb['PassengerTypeQuantity']['@attributes']['Quantity'];
                                        $departure_passenger_classes->flight_class_id = $departure_flight_class->id;
                                        $departure_passenger_classes->user_id = Auth::user()->id;
                                        $departure_passenger_classes->save();
                                    }
                                }
                            }
                        }else{
                            $departure_flight = new Flight();
                            $departure_flight->flight_number = $flight_number;
                            $departure_flight->departure_date_time = $departure_date_time;
                            $departure_flight->arrival_date_time = $arrival_date_time;
                            $departure_flight->departure_airport = $departure_airport;
                            $departure_flight->arrival_airport = $arrival_airport;
                            $departure_flight->company_short_name = $company_short_name;
                            $departure_flight->stop_quantity = $stop_quantity;
                            $departure_flight->journey_duration = $journey_duration;
                            $departure_flight->type = 'going';
                            $departure_flight->user_id = Auth::user()->id;
                            $departure_flight->save();

                            $departure_flight_class = new FlightClass();
                            $departure_flight_class->res_book_desig_code = $res_book_desig_code;
                            $departure_flight_class->res_book_desig_quantity = $res_book_desig_quantity;
                            $departure_flight_class->rph = $rph;
                            $departure_flight_class->amount = $amount;
                            $departure_flight_class->flight_id = $departure_flight->id;
                            $departure_flight_class->user_id = Auth::user()->id;
                            $departure_flight_class->save();

                            $fareBreakdowns = $array_json_price['PricedItineraries']['PricedItinerary']['AirItineraryPricingInfo']['PTC_FareBreakdowns']['PTC_FareBreakdown'];

                            if(isset($fareBreakdowns['PassengerTypeQuantity'])){
                                $PassengerTypeQuantity = $fareBreakdowns['PassengerTypeQuantity'];
                                $departure_passenger_classes = new FlightClassPassenger();
                                $departure_passenger_classes->passenger_type = $PassengerTypeQuantity['@attributes']['Code'];
                                $departure_passenger_classes->passenger_quantity = $PassengerTypeQuantity['@attributes']['Quantity'];
                                $departure_passenger_classes->flight_class_id = $departure_flight_class->id;
                                $departure_passenger_classes->user_id = Auth::user()->id;
                                $departure_passenger_classes->save();
                            }else{
                                foreach ($fareBreakdowns as $key_fb => $value_fb) {
                                    if (isset($value_fb['PassengerTypeQuantity'])) {
                                        $departure_passenger_classes = new FlightClassPassenger();
                                        $departure_passenger_classes->passenger_type = $value_fb['PassengerTypeQuantity']['@attributes']['Code'];
                                        $departure_passenger_classes->passenger_quantity = $value_fb['PassengerTypeQuantity']['@attributes']['Quantity'];
                                        $departure_passenger_classes->flight_class_id = $departure_flight_class->id;
                                        $departure_passenger_classes->user_id = Auth::user()->id;
                                        $departure_passenger_classes->save();
                                    }
                                }
                            }
                        }
                    }
                }
            } else {
                //CONSULTA BOLETOS DE IDA SIN SELECCIONAR AEROLINEA
                foreach ($array_departure as $key => $value) {
                    if (isset($value['FlightSegment']['@attributes'])) {
                        $flight_number = $value['FlightSegment']['@attributes']['FlightNumber'];
                        $departure_date_time = $value['FlightSegment']['@attributes']['DepartureDateTime'];
                        $arrival_date_time = $value['FlightSegment']['@attributes']['ArrivalDateTime'];
                        $stop_quantity = $value['FlightSegment']['@attributes']['StopQuantity'];
                        $journey_duration = $value['FlightSegment']['@attributes']['JourneyDuration'];
                        $company_short_name = $value['FlightSegment']['MarketingAirline']['@attributes']['CompanyShortName'];
                        $cabin = $value['FlightSegment']['MarketingCabin'];
                        $booking_class_avail = $value['FlightSegment']['BookingClassAvail'];
                        foreach ($booking_class_avail as $key2 => $value2) {
                            if (isset($booking_class_avail['@attributes'])) {
                                $class_avail = $booking_class_avail['@attributes']['ResBookDesigCode'];
                            } else {
                                $class_avail = $value2['@attributes']['ResBookDesigCode'];
                            }

                            $xmlstr_price = <<<XML
                            <?xml version="1.0" encoding="UTF-8"?>
                            <KIU_AirPriceRQ EchoToken="1" TimeStamp="2023-05-18T12:00:00Z" Target="Testing" Version="3.0" SequenceNmbr="1" PrimaryLangID="en-us">
                                <POS>
                                    <Source AgentSine="MYCV0070B" TerminalID="MYCV00700B" ISOCountry="VE" ISOCurrency="USD"/>
                                    <RequestorID Type="5" />
                                    <BookingChannel Type="1" />
                                </POS>
                                <AirItinerary>
                                    <OriginDestinationOptions>
                                        <OriginDestinationOption>
                                            <FlightSegment DepartureDateTime="$departure_date_time" ArrivalDateTime="$arrival_date_time" FlightNumber="$flight_number" ResBookDesigCode="$class_avail" >
                                                <DepartureAirport LocationCode="$origin_airport"/>
                                                <ArrivalAirport LocationCode="$destination_airport"/>
                                                <MarketingAirline Code="$company_short_name"/>
                                            </FlightSegment>
                                        </OriginDestinationOption>
                                    </OriginDestinationOptions>
                                </AirItinerary>
                                <TravelerInfoSummary>
                                    <AirTravelerAvail>
                                        <PassengerTypeQuantity Code="ADT" Quantity="$adt"/>
                                        <PassengerTypeQuantity Code="INF" Quantity="$inf" />
                                        <PassengerTypeQuantity Code="CNN" Quantity="$cnn" />
                                    </AirTravelerAvail>
                                </TravelerInfoSummary>
                            </KIU_AirPriceRQ>
                            XML;

                            $curl_price = curl_init();
                            curl_setopt_array($curl_price, array(
                                CURLOPT_URL => 'https://ssl00.kiusys.com/ws3/index.php',
                                CURLOPT_RETURNTRANSFER => true,
                                CURLOPT_ENCODING => '',
                                CURLOPT_MAXREDIRS => 10,
                                CURLOPT_TIMEOUT => 0,
                                CURLOPT_FOLLOWLOCATION => true,
                                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                                CURLOPT_CUSTOMREQUEST => 'POST',
                                CURLOPT_POSTFIELDS => 'user=VIAJES360GLOBE&password=wQknr9@yvVl$6X98&request='.$xmlstr_price,
                                CURLOPT_HTTPHEADER => array(
                                    'Content-Type: application/x-www-form-urlencoded'
                                ),
                            ));

                            $response_price = curl_exec($curl_price);
                            curl_close($curl_price);
                            $xml_price = simplexml_load_string($response_price, "SimpleXMLElement", LIBXML_NOCDATA);
                            $json_price = json_encode($xml_price);
                            $array_json_price = json_decode($json_price,TRUE);
                            if(isset($array_json_price['Success'])){
                                $departure_date_time = $array_json_price['PricedItineraries']['PricedItinerary']['AirItinerary']['OriginDestinationOptions']['OriginDestinationOption']['FlightSegment']['@attributes']['DepartureDateTime'];
                                $arrival_date_time = $array_json_price['PricedItineraries']['PricedItinerary']['AirItinerary']['OriginDestinationOptions']['OriginDestinationOption']['FlightSegment']['@attributes']['ArrivalDateTime'];
                                $flight_number = $array_json_price['PricedItineraries']['PricedItinerary']['AirItinerary']['OriginDestinationOptions']['OriginDestinationOption']['FlightSegment']['@attributes']['FlightNumber'];
                                $res_book_desig_code = $array_json_price['PricedItineraries']['PricedItinerary']['AirItinerary']['OriginDestinationOptions']['OriginDestinationOption']['FlightSegment']['@attributes']['ResBookDesigCode'];
                                $departure_airport = $array_json_price['PricedItineraries']['PricedItinerary']['AirItinerary']['OriginDestinationOptions']['OriginDestinationOption']['FlightSegment']['DepartureAirport']['@attributes']['LocationCode'];
                                $arrival_airport = $array_json_price['PricedItineraries']['PricedItinerary']['AirItinerary']['OriginDestinationOptions']['OriginDestinationOption']['FlightSegment']['ArrivalAirport']['@attributes']['LocationCode'];
                                $company_short_name = $array_json_price['PricedItineraries']['PricedItinerary']['AirItinerary']['OriginDestinationOptions']['OriginDestinationOption']['FlightSegment']['MarketingAirline']['@attributes']['Code'];
                                $amount = $array_json_price['PricedItineraries']['PricedItinerary']['AirItineraryPricingInfo']['ItinTotalFare']['TotalFare']['@attributes']['Amount'];

                                if (isset($value2['@attributes'])) {
                                    $res_book_desig_code = $value2['@attributes']['ResBookDesigCode'];
                                    $res_book_desig_quantity = $value2['@attributes']['ResBookDesigQuantity'];
                                    $rph = $value2['@attributes']['RPH'];
                                }
                                
                                $fareBreakdowns = $array_json_price['PricedItineraries']['PricedItinerary']['AirItineraryPricingInfo']['PTC_FareBreakdowns']['PTC_FareBreakdown'];

                                $query_departure_flight = Flight::where('departure_date_time', $departure_date_time)
                                ->where('arrival_date_time', $arrival_date_time)
                                ->where('flight_number', $flight_number)
                                ->where('departure_airport', $departure_airport)
                                ->where('arrival_airport', $arrival_airport)
                                ->where('company_short_name', $company_short_name)
                                ->where('stop_quantity', $stop_quantity)
                                ->where('user_id', Auth::user()->id)
                                ->first();

                                if ($query_departure_flight) {
                                    $departure_flight_class = new FlightClass();
                                    $departure_flight_class->res_book_desig_code = $res_book_desig_code;
                                    $departure_flight_class->res_book_desig_quantity = $res_book_desig_quantity;
                                    $departure_flight_class->rph = $rph;
                                    $departure_flight_class->amount = $amount;
                                    $departure_flight_class->flight_id = $query_departure_flight->id;
                                    $departure_flight_class->user_id = Auth::user()->id;
                                    $departure_flight_class->save();

                                    if(isset($fareBreakdowns['PassengerTypeQuantity'])){
                                        $PassengerTypeQuantity = $fareBreakdowns['PassengerTypeQuantity'];
                                        $departure_passenger_classes = new FlightClassPassenger();
                                        $departure_passenger_classes->passenger_type = $PassengerTypeQuantity['@attributes']['Code'];
                                        $departure_passenger_classes->passenger_quantity = $PassengerTypeQuantity['@attributes']['Quantity'];
                                        $departure_passenger_classes->flight_class_id = $departure_flight_class->id;
                                        $departure_passenger_classes->user_id = Auth::user()->id;
                                        $departure_passenger_classes->save();
                                    }else{
                                        foreach ($fareBreakdowns as $key_fb => $value_fb) {
                                            if (isset($value_fb['PassengerTypeQuantity'])) {
                                                $departure_passenger_classes = new FlightClassPassenger();
                                                $departure_passenger_classes->passenger_type = $value_fb['PassengerTypeQuantity']['@attributes']['Code'];
                                                $departure_passenger_classes->passenger_quantity = $value_fb['PassengerTypeQuantity']['@attributes']['Quantity'];
                                                $departure_passenger_classes->flight_class_id = $departure_flight_class->id;
                                                $departure_passenger_classes->user_id = Auth::user()->id;
                                                $departure_passenger_classes->save();
                                            }
                                        }
                                    }
                                } else {
                                    $departure_flight = new Flight();
                                    $departure_flight->flight_number = $flight_number;
                                    $departure_flight->departure_date_time = $departure_date_time;
                                    $departure_flight->arrival_date_time = $arrival_date_time;
                                    $departure_flight->departure_airport = $departure_airport;
                                    $departure_flight->arrival_airport = $arrival_airport;
                                    $departure_flight->company_short_name = $company_short_name;
                                    $departure_flight->stop_quantity = $stop_quantity;
                                    $departure_flight->journey_duration = $journey_duration;
                                    $departure_flight->type = 'going';
                                    $departure_flight->user_id = Auth::user()->id;
                                    $departure_flight->save();

                                    $departure_flight_class = new FlightClass();
                                    $departure_flight_class->res_book_desig_code = $res_book_desig_code;
                                    $departure_flight_class->res_book_desig_quantity = $res_book_desig_quantity;
                                    $departure_flight_class->rph = $rph;
                                    $departure_flight_class->amount = $amount;
                                    $departure_flight_class->flight_id = $departure_flight->id;
                                    $departure_flight_class->user_id = Auth::user()->id;
                                    $departure_flight_class->save();

                                    if(isset($fareBreakdowns['PassengerTypeQuantity'])){
                                        $PassengerTypeQuantity = $fareBreakdowns['PassengerTypeQuantity'];
                                        $departure_passenger_classes = new FlightClassPassenger();
                                        $departure_passenger_classes->passenger_type = $PassengerTypeQuantity['@attributes']['Code'];
                                        $departure_passenger_classes->passenger_quantity = $PassengerTypeQuantity['@attributes']['Quantity'];
                                        $departure_passenger_classes->flight_class_id = $departure_flight_class->id;
                                        $departure_passenger_classes->user_id = Auth::user()->id;
                                        $departure_passenger_classes->save();
                                    }else{
                                        foreach ($fareBreakdowns as $key_fb => $value_fb) {
                                            if (isset($value_fb['PassengerTypeQuantity'])) {
                                                $departure_passenger_classes = new FlightClassPassenger();
                                                $departure_passenger_classes->passenger_type = $value_fb['PassengerTypeQuantity']['@attributes']['Code'];
                                                $departure_passenger_classes->passenger_quantity = $value_fb['PassengerTypeQuantity']['@attributes']['Quantity'];
                                                $departure_passenger_classes->flight_class_id = $departure_flight_class->id;
                                                $departure_passenger_classes->user_id = Auth::user()->id;
                                                $departure_passenger_classes->save();
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }

        return redirect()->route('panel.flights.result');
    }

    public function result()
    {
        $departure_flight = Flight::where('type', 'going')->where('user_id', Auth::user()->id)->get();
        $return_flight = Flight::where('type', 'return')->where('user_id', Auth::user()->id)->get();
        FareSelectedFlight::where('user_id', Auth::user()->id)->delete();
        Passenger::where('user_id', Auth::user()->id)->delete();

        return view('panel.flights.result', compact('departure_flight', 'return_flight'));
    }

    public function customer()
    {
        Passenger::where('user_id', Auth::user()->id)->delete();
        $form_adt = FlightClassPassenger::where('passenger_type', 'ADT')->where('user_id', Auth::user()->id)->first();
        if (!$form_adt) {
            $form_adt = null;
        } else {
            $number_form_adt = $form_adt->passenger_quantity;
        }
        
        $form_cnn = FlightClassPassenger::where('passenger_type', 'CNN')->where('user_id', Auth::user()->id)->first();
        if (!$form_cnn) {
            $form_cnn = null;
        } else {
            $number_form_cnn = $form_cnn->passenger_quantity;
        }

        $form_inf  = FlightClassPassenger::where('passenger_type', 'INF')->where('user_id', Auth::user()->id)->first();
        if (!$form_inf) {
            $form_inf = null;
        } else {
            $number_form_inf = $form_inf->passenger_quantity;
        }

        $countries = Country::pluck('name', 'id');
        $phone_codes = Country::select('phone_code')->distinct()->orderBy('phone_code', 'Asc')->get();

        $array_adt = array();
        for($x = 0; $x < $form_adt->passenger_quantity; $x++) {
            $array_adt[] = 'adt['.$x.'][name]';
        }

        if ($form_adt != null) {
            $jsFragmentAdt='';
            $jsFragmentAdt.='<script>';
                for ($i = 0; $i < $number_form_adt; $i++) {
                    $jsFragmentAdt.='$(".code-phone-adt'.$i.'").click(function(){';
                        $jsFragmentAdt.='var type_document_adt = $(this).attr("attr-value-adt'.$i.'");';
                        $jsFragmentAdt.='$(".change-value-adt'.$i.'").text(type_document_adt);';
                        $jsFragmentAdt.='$("#value-code-adt'.$i.'").val(type_document_adt);';
                    $jsFragmentAdt.='});';
                }
            $jsFragmentAdt.='</script>';
        } else {
            $jsFragmentAdt = null;
        }

        if ($form_cnn != null) {
            $jsFragmentCnn='';
            $jsFragmentCnn.='<script>';
                for ($i = 0; $i < $number_form_cnn; $i++) {
                    $jsFragmentCnn.='$(".code-phone-cnn'.$i.'").click(function(){';
                        $jsFragmentCnn.='var type_code_cnn = $(this).attr("attr-value-cnn'.$i.'");';
                        $jsFragmentCnn.='$(".change-value-cnn'.$i.'").text(type_code_cnn);';
                        $jsFragmentCnn.='$("#value-code-cnn'.$i.'").val(type_code_cnn);';
                    $jsFragmentCnn.='});';
                }
            $jsFragmentCnn.='</script>';
        } else {
            $jsFragmentCnn = null;
        }

        if ($form_inf != null) {
            $jsFragmentInf='';
            $jsFragmentInf.='<script>';
                for ($i = 0; $i < $number_form_inf; $i++) {
                    $jsFragmentInf.='$(".code-phone-inf'.$i.'").click(function(){';
                        $jsFragmentInf.='var type_code_inf = $(this).attr("attr-value-inf'.$i.'");';
                        $jsFragmentInf.='$(".change-value-inf'.$i.'").text(type_code_inf);';
                        $jsFragmentInf.='$("#value-code-inf'.$i.'").val(type_code_inf);';
                    $jsFragmentInf.='});';
                }
            $jsFragmentInf.='</script>';
        } else {
            $jsFragmentInf = null;
        }

        return view('panel.flights.customer', compact('countries', 'form_adt', 'form_cnn', 'form_inf', 'phone_codes', 'jsFragmentAdt', 'jsFragmentCnn', 'jsFragmentInf'));
    }

    public function customerSave(Request $request)
    {
        Passenger::where('user_id', Auth::user()->id)->delete();
        if (isset($_POST['adt'])) {
            $array_adt = $_POST['adt'];
        } else {
            $array_adt = [];
        }

        if (isset($_POST['cnn'])) {
            $array_cnn = $_POST['cnn'];
        } else {
            $array_cnn = [];
        }
        
        if (isset($_POST['inf'])) {
            $array_inf = $_POST['inf'];
        } else {
            $array_inf = [];
        }

        $date_expiry = Date::now()->addDay()->format('Y-m-d');
        $hour_expiry = Date::now()->format('H:i:s');
        $dh_expiry = $date_expiry.'T'.$hour_expiry;
        
        foreach ($array_adt as $key => $value) {
            $passenger = new Passenger();
            $passenger->type = $value['type'];
            $passenger->name = $value['name'];
            $passenger->last_name = $value['last_name'];
            $passenger->document_type = $value['document_type'];
            $passenger->document = $value['document'];
            $passenger->zip_code = $value['zip_code'];
            $passenger->phone = $value['phone'];
            $passenger->country_id = $value['country'];
            $passenger->user_id = Auth::user()->id;
            $passenger->save();
        }

        foreach ($array_cnn as $key => $value) {
            $passenger = new Passenger();
            $passenger->type = $value['type'];
            $passenger->name = $value['name'];
            $passenger->last_name = $value['last_name'];
            $passenger->document_type = $value['document_type'];
            $passenger->document = $value['document'];
            $passenger->zip_code = $value['zip_code'];
            $passenger->phone = $value['phone'];
            $passenger->country_id = $value['country'];
            $passenger->user_id = Auth::user()->id;
            $passenger->save();
        }

        foreach ($array_inf as $key => $value) {
            $passenger = new Passenger();
            $passenger->type = $value['type'];
            $passenger->name = $value['name'];
            $passenger->last_name = $value['last_name'];
            $passenger->document_type = $value['document_type'];
            $passenger->document = $value['document'];
            $passenger->zip_code = $value['zip_code'];
            $passenger->phone = $value['phone'];
            $passenger->country_id = $value['country'];
            $passenger->user_id = Auth::user()->id;
            $passenger->save();
        }

        $selects = FareSelectedFlight::where('user_id', Auth::user()->id)->get();
        
        if ($selects[0]) {
            $select_1 = $selects[0];
        }

        if (isset($selects[1])) {
            $select_2 = $selects[1];

            $flight_class_2 = $select_2->flightClass;
            $flight_2 = $flight_class_2->flight;
            $passenger_class_2 = $flight_class_2->passengerClass;
            $f2_airline = $flight_2->company_short_name;
            $f2_departure_airport = $flight_2->departure_airport;
            $f2_arrival_airport = $flight_2->arrival_airport;
            $f2_flight_number = $flight_2->flight_number;
            $f2_departure_date_time = new Date($flight_2->departure_date_time);
            $f2_departure_date_time = $f2_departure_date_time->format('Y-m-d').'T'.$f2_departure_date_time->format('H:i:s');
            $f2_code_class = $flight_class_2->res_book_desig_code;
            $f2_code_rph = $flight_class_2->rph;
        } else {
            $select_2 = null;
        }

        $passengers = Passenger::where('user_id', Auth::user()->id)->get();
        
        $flight_class_1 = $select_1->flightClass;
        $flight_1 = $flight_class_1->flight;
        $passenger_class_1 = $flight_class_1->passengerClass;
        $f1_airline = $flight_1->company_short_name;
        $f1_departure_airport = $flight_1->departure_airport;
        $f1_arrival_airport = $flight_1->arrival_airport;
        $f1_flight_number = $flight_1->flight_number;
        $f1_departure_date_time = new Date($flight_1->departure_date_time);
        $f1_departure_date_time = $f1_departure_date_time->format('Y-m-d').'T'.$f1_departure_date_time->format('H:i:s');
        $f1_code_class = $flight_class_1->res_book_desig_code;
        $f1_code_rph = $flight_class_1->rph;

        $xmlstr = <<<XML
        <?xml version="1.0" encoding="UTF-8"?>
        <KIU_AirBookV2RQ
            xmlns:ns="http://www.opentravel.org/OTA/2003/05/common"
            xmlns:vc="http://www.w3.org/2007/XMLSchema-versioning"
            xmlns:sch="http://purl.oclc.org/dsdl/schematron"
            xmlns:fn="http://www.w3.org/2005/xpath-functions"
            xmlns="http://www.opentravel.org/OTA/2003/05"
            xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
            xsi:schemaLocation="http://www.opentravel.org/OTA/2003/05" 
            EchoToken="GERTESTWS3DOCS" TimeStamp="2021-08-10T12:00:00.0Z"
            Target="Testing" Version="3.0" SequenceNmbr="1" PriceInd="true" IncludeAncillariesPrice="true">
            <POS>
                <Source AgentSine="MYCV0070B" TerminalID="MYCV00700B" ISOCountry="Ve" ISOCurrency="USD">
                    <RequestorID Type="5" />
                    <BookingChannel Type="1" />
                </Source>
            </POS>
            <AirItinerary>
                <OriginDestinationOptions>
                    <OriginDestinationOption>
                        <FlightSegment DepartureDateTime="$f1_departure_date_time" ResBookDesigCode="$f1_code_class" SegmentRPH="$f1_code_rph" FlightNumber="$f1_flight_number">
                            <DepartureAirport LocationCode="$f1_departure_airport"/>
                            <ArrivalAirport LocationCode="$f1_arrival_airport"/>
                            <MarketingAirline Code="$f1_airline"/>
                        </FlightSegment>
                    </OriginDestinationOption>
        XML;
        if ($select_2 != null) {
        $xmlstr.= <<<XML
            <OriginDestinationOption>
                <FlightSegment DepartureDateTime="$f2_departure_date_time" ResBookDesigCode="$f2_code_class" SegmentRPH="$f2_code_rph" FlightNumber="$f2_flight_number">
                    <DepartureAirport LocationCode="$f2_departure_airport"/>
                    <ArrivalAirport LocationCode="$f2_arrival_airport"/>
                    <MarketingAirline Code="$f2_airline"/>
                </FlightSegment>
            </OriginDestinationOption>
        XML;
        }
        $xmlstr.= <<<XML
                </OriginDestinationOptions>
            </AirItinerary>
            <TravelerInfo>
        XML;
        foreach ($passengers as $key => $value) {
        $name = strtoupper($value->name);
        $last_name = strtoupper($value->last_name);
        if ($value->type == 'CNN') {
            $type = 'CHD';
        } else {
            $type = $value->type;
        }
        $document_type = $value->document_type;
        $document = $value->document;
        $phone = $value->phone;
        $zip_code = $value->zip_code;
        $xmlstr.= <<<XML
                <AirTraveler>
                    <PersonName PTC="$type">
                        <GivenName>$name</GivenName>
                        <Surname>$last_name</Surname>
                    </PersonName>
                    <Document DocType="$document_type" DocID="$document"/>
                    <Telephone CountryAccessCode="54" AreaCityCode="$zip_code" PhoneNumber="$phone"/>
                    <TravelerRefNumber RPH="1"/>
                </AirTraveler>
        XML;
        }
        if ($value->type == 'INF') {
            $birthdate = new Date($value->birthdate);
            $birthdate  = $birthdate->format('j F Y');
            $birthdate = explode(" ", $birthdate);
            $day = $birthdate[0];
            $month = substr($birthdate[1], 0, 3);
            $month = strtoupper($month);
            $year = substr($birthdate[2], 2, 4);
            $birthdate = $day.$month.$year;

        $xmlstr.= <<<XML
            <SpecialReqDetails>
                <SpecialServiceRequests>
                    <SpecialServiceRequest SSRCode="INFT" ServiceQuantity="1" Status="NN" TravelerRefNumberRPH="1" FlightRefNumberRPH="1">
                        <Airline CompanyShortName="LASER"  Code="QL"/>
                        <FlightLeg FlightNumber="$f1_flight_number" ResBookDesigCode="$f1_code_class" Date="$f1_departure_date_time">
                            <DepartureAirport LocationCode="$f1_departure_airport"/>
                            <ArrivalAirport LocationCode="$f1_arrival_airport"/>
                        </FlightLeg>
                        <Text>$name/$last_name$birthdate</Text>
                    </SpecialServiceRequest>
                    </SpecialServiceRequests>
                <Remarks>
                    <Remark RPH="1" Operation="Add-Update">AGREGO REMARK</Remark>
                </Remarks>
            </SpecialReqDetails>
        XML;
        }
        $xmlstr.= <<<XML
            </TravelerInfo>
            <Ticketing CancelOnExpiryInd="true" TicketTimeLimit="$dh_expiry" TimeLimitCity="AEP"/>
        </KIU_AirBookV2RQ>
        XML;
        
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://ssl00.kiusys.com/ws3/index.php',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => 'user=VIAJES360GLOBE&password=wQknr9@yvVl$6X98&request='.$xmlstr,
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/x-www-form-urlencoded'
            ),
        ));

        $response = curl_exec($curl);
        curl_close($curl);
        $xml = simplexml_load_string($response, "SimpleXMLElement", LIBXML_NOCDATA);
        $json = json_encode($xml);
        $array_json = json_decode($json,TRUE);

        if (isset($array_json['BookingReferenceID'])) {
            $id_booking = $array_json['BookingReferenceID']['@attributes']['ID'];
            $last_modification_date = $array_json['BookingReferenceID']['@attributes']['LastModificationDate'];
            $ticket_time_limit = $array_json['BookingReferenceID']['@attributes']['TicketTimeLimit'];
        } else {
            return redirect()->back()->with('error', 'En estos momentos Kiu no puede procesar su solicitud');
        }
        

        $booking = new Booking();
        $booking->number = $id_booking;
        $booking->last_modification_date = $last_modification_date;
        $booking->ticket_time_limit = $ticket_time_limit;
        $booking->status = 'Activo';
        if ($booking->save()) {
            $history = new BookingHistory();
            $history->data = json_encode($_POST);
            $history->data_ip = ipGeo();
            $history->status = 'Creado';
            $history->booking_id = $booking->id;
            $history->user_id = Auth::user()->id;
            $history->save();

            $flight_departure = new BookingFlight();
            $flight_departure->flight_number = $flight_1->flight_number;
            $flight_departure->departure_date_time = $flight_1->departure_date_time;
            $flight_departure->arrival_date_time = $flight_1->arrival_date_time;
            $flight_departure->departure_airport = $flight_1->departure_airport;
            $flight_departure->arrival_airport = $flight_1->arrival_airport;
            $flight_departure->company_short_name = $flight_1->company_short_name;
            $flight_departure->stop_quantity = $flight_1->stop_quantity;
            $flight_departure->journey_duration = $flight_1->journey_duration;
            $flight_departure->type = $flight_1->type;
            $flight_departure->rph = 1;
            $flight_departure->booking_id = $booking->id;
            $flight_departure->save();
            
            $flight_class_departure = new BookingFlightClass();
            $flight_class_departure->res_book_desig_code = $flight_class_1->res_book_desig_code;
            $flight_class_departure->res_book_desig_quantity = $flight_class_1->res_book_desig_quantity;
            $flight_class_departure->rph = $flight_class_1->rph;
            $flight_class_departure->amount = $flight_class_1->amount;
            $flight_class_departure->booking_flight_id = $flight_departure->id;
            $flight_class_departure->save();

            foreach ($passenger_class_1 as $key => $value) {
                $bfc_passenger_departure = new BookingFlightClassPassenger();
                $bfc_passenger_departure->passenger_type = $value->passenger_type;
                $bfc_passenger_departure->passenger_quantity = $value->passenger_quantity;
                $bfc_passenger_departure->booking_flight_class_id = $flight_class_departure->id;
                $bfc_passenger_departure->save();
            }
            
            if ($select_2 != null) {
                $flight_return = new BookingFlight();
                $flight_return->flight_number = $flight_2->flight_number;
                $flight_return->departure_date_time = $flight_2->departure_date_time;
                $flight_return->arrival_date_time = $flight_2->arrival_date_time;
                $flight_return->departure_airport = $flight_2->departure_airport;
                $flight_return->arrival_airport = $flight_2->arrival_airport;
                $flight_return->company_short_name = $flight_2->company_short_name;
                $flight_return->stop_quantity = $flight_2->stop_quantity;
                $flight_return->journey_duration = $flight_2->journey_duration;
                $flight_return->type = $flight_2->type;
                $flight_return->rph = 2;
                $flight_return->booking_id = $booking->id;
                $flight_return->save();
                
                $flight_class_return = new BookingFlightClass();
                $flight_class_return->res_book_desig_code = $flight_class_2->res_book_desig_code;
                $flight_class_return->res_book_desig_quantity = $flight_class_2->res_book_desig_quantity;
                $flight_class_return->rph = $flight_class_2->rph;
                $flight_class_return->amount = $flight_class_2->amount;
                $flight_class_return->booking_flight_id = $flight_return->id;
                $flight_class_return->save();

                foreach ($passenger_class_2 as $key => $value) {
                    $bfc_passenger_return = new BookingFlightClassPassenger();
                    $bfc_passenger_return->passenger_type = $value->passenger_type;
                    $bfc_passenger_return->passenger_quantity = $value->passenger_quantity;
                    $bfc_passenger_return->booking_flight_class_id = $flight_class_return->id;
                    $bfc_passenger_return->save();
                }
            }

            foreach ($passengers as $key => $value) {
                $rph = $key + 1;
                $insert = new BookingPassenger();
                $insert->type = $value->type;
                $insert->name = $value->name;
                $insert->last_name = $value->last_name;
                $insert->document_type = $value->document_type;
                $insert->document = $value->document;
                $insert->phone = $value->phone;
                $insert->zip_code = $value->zip_code;
                $insert->birthdate = $value->birthdate;
                $insert->rph = $rph;
                $insert->country_id = $value->country_id;
                $insert->booking_id = $booking->id;
                $insert->save();
            }

            Flight::where('user_id', Auth::user()->id)->delete();
            FlightClass::where('user_id', Auth::user()->id)->delete();
            FlightClassPassenger::where('user_id', Auth::user()->id)->delete();
            FareSelectedFlight::where('user_id', Auth::user()->id)->delete();
            Passenger::where('user_id', Auth::user()->id)->delete();

            return redirect()->route('panel.flights.booking', encrypt($booking->id))->with('success', 'Booking creado de manera exitoso');
        } else {
            return redirect()->back()->with('error', 'Error al crear booking');
        }


    }

    public function booking($id)
    {
        $id = Crypt::decrypt($id);
        $booking = Booking::findOrFail($id);
        $booking_flight = $booking->bookingFlight;
        $passengers = $booking->bookingPassenger;

        if (isset($booking_flight[1])) {
            $flight_departure = $booking_flight[0];
            $flight_return = $booking_flight[1];
            $amount_departure = $flight_departure->bookingFlightClass->amount;
            $amount_return = $flight_return->bookingFlightClass->amount;
            $total_amount = $amount_departure + $amount_return;
        } else {
            $flight_departure = $booking_flight[0];
            $flight_return = null;
            $amount_departure = $flight_departure->bookingFlightClass->amount;
            $amount_return = 0;
            $total_amount = $amount_departure + $amount_return;
        }
        
        return view('panel.flights.booking', compact('booking', 'flight_departure', 'flight_return', 'total_amount', 'passengers'));
    }

    public function bookingCancel($id)
    {
        session_start();
        $id = Crypt::decrypt($id);
        $booking = Booking::findOrFail($id);

        $xmlstr = <<<XML
        <?xml version="1.0" encoding="UTF-8"?>
        <KIU_AirBookModifyV2RQ EchoToken="GERTESTW3DOC" TimeStamp="2021-08-10T08:04:55Z" Target="Testing" Version="3.0" SequenceNmbr="1" PrimaryLangID="en-US" ModificationType="1">
            <POS>
                <Source AgentSine="MYCV0070B" TerminalID="MYCV00700B" ISOCountry="VE" ISOCurrency="USD">
                    <RequestorID Type="5" />
                    <BookingChannel Type="1" />
                </Source>
            </POS>
            <AirReservation>
                <BookingReferenceID ID="$booking->number" />
            </AirReservation>
        </KIU_AirBookModifyV2RQ>
        XML;

        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://ssl00.kiusys.com/ws3/index.php',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => 'user=VIAJES360GLOBE&password=wQknr9@yvVl$6X98&request='.$xmlstr,
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/x-www-form-urlencoded'
            ),
        ));

        $response = curl_exec($curl);
        curl_close($curl);
        $xml = simplexml_load_string($response, "SimpleXMLElement", LIBXML_NOCDATA);
        $json = json_encode($xml);
        $array_json = json_decode($json,TRUE);
        if (isset($array_json['Success'])) {
            $booking->status = 'Cancelado';
            if ($booking->save()) {
                $history = new BookingHistory();
                $history->data = json_encode($_POST);
                $history->data_ip = ipGeo();
                $history->status = 'Cancelado';
                $history->booking_id = $booking->id;
                $history->user_id = Auth::user()->id;
                $history->save();
            }

            return redirect()->back()->with('success', 'La reserva ha sido cancelada');
        } else {
            return redirect()->back()->with('error', 'Error al cencelar la reserva');
        }
    }

    public function seating($id)
    {
        $id = Crypt::decrypt($id);
        $booking = Booking::findOrFail($id);
        $booking_flight = $booking->bookingFlight;
        Seating::where('user_id', Auth::user()->id)->delete();

        if (isset($booking_flight[1])) {
            $flight_return = $booking_flight[1];
            $flight_departure_date_time = new Date($flight_return->departure_date_time);
            $flight_departure_date = $flight_departure_date_time->format('Y-m-d');
            $flight_departure_time = $flight_departure_date_time->format('H:i');
            $flight_arrival_date_time = new Date($flight_return->arrival_date_time);
            $flight_arrival_date = $flight_arrival_date_time->format('Y-m-d');
            $flight_arrival_time = $flight_arrival_date_time->format('H:i');
            $flight_departure_rph = $flight_return->bookingFlightClass->rph;
            $flight_departure_class = $flight_return->bookingFlightClass->res_book_desig_code;

            $xmlstr = <<<XML
            <?xml version="1.0" encoding="UTF-8"?>
            <KIU_SeatAvailabilityRQ EchoToken="1" TimeStamp="2012-04-25T12:45:57-03:00" Target="Testing" Version="3.0" SequenceNmbr="1" PrimaryLangID="en-us" TransactionStatusCode="Start">
                <POS>
                    <Source AgentSine="MYCV0070B" TerminalID="MYCV00700B" ISOCountry="VE" ISOCurrency="USD" />
                </POS>
                <Query>
                    <BookingReference>
                        <ID>$booking->number</ID>
                        <AirlineID>$flight_return->company_short_name</AirlineID>
                    </BookingReference>
                </Query>
                <DataLists>
                    <FlightSegmentList>
                        <FlightSegment SegmentKey="SEG1" SegmentRPH="$flight_departure_rph">
                            <Departure>
                                <AirportCode>$flight_return->departure_airport</AirportCode>
                                <Date>$flight_departure_date</Date>
                                <Time>$flight_departure_time</Time>
                            </Departure>
                            <Arrival>
                                <AirportCode>$flight_return->arrival_airport</AirportCode>
                                <Date>$flight_arrival_date</Date>
                                <Time>$flight_arrival_time</Time>
                            </Arrival>
                            <MarketingCarrier>
                                <AirlineID>$flight_return->company_short_name</AirlineID>
                                <FlightNumber>$flight_return->flight_number</FlightNumber>
                                <ResBookDesigCode>$flight_departure_class</ResBookDesigCode>
                            </MarketingCarrier>
                        </FlightSegment>
                    </FlightSegmentList>
                </DataLists>
            </KIU_SeatAvailabilityRQ>
            XML;
            
            $curl = curl_init();
            curl_setopt_array($curl, array(
                CURLOPT_URL => 'https://ssl00.kiusys.com/ws3/index.php',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS => 'user=VIAJES360GLOBE&password=wQknr9@yvVl$6X98&request='.$xmlstr,
                CURLOPT_HTTPHEADER => array(
                    'Content-Type: application/x-www-form-urlencoded'
                ),
            ));

            $response = curl_exec($curl);
            curl_close($curl);
            $xml = simplexml_load_string($response, "SimpleXMLElement", LIBXML_NOCDATA);
            $json = json_encode($xml);
            $array_json = json_decode($json,TRUE);
            if(isset($array_json['DataLists']['SeatLists']['Seats']['Location'])) {
                $location = $array_json['DataLists']['SeatLists']['Seats']['Location'];
                $array = array();
                foreach ($location as $key => $value) {
                    $array[] = array('colum' => $value['Column'], 'number' => $value['Row']['Number'], 'seating' => $value['Row']['Number'].$value['Column']);
                    
                    $seating = new Seating();
                    $seating->word = $value['Column'];
                    $seating->number = $value['Row']['Number'];
                    $seating->booking_flight_id = $flight_return->id;
                    $seating->user_id = Auth::user()->id;
                    $seating->save();
                }
            }
        }

        $flight_departure = $booking_flight[0];
        $flight_departure_date_time = new Date($flight_departure->departure_date_time);
        $flight_departure_date = $flight_departure_date_time->format('Y-m-d');
        $flight_departure_time = $flight_departure_date_time->format('H:i');
        $flight_arrival_date_time = new Date($flight_departure->arrival_date_time);
        $flight_arrival_date = $flight_arrival_date_time->format('Y-m-d');
        $flight_arrival_time = $flight_arrival_date_time->format('H:i');
        $flight_departure_rph = $flight_departure->bookingFlightClass->rph;
        $flight_departure_class = $flight_departure->bookingFlightClass->res_book_desig_code;
        
        $xmlstr = <<<XML
        <?xml version="1.0" encoding="UTF-8"?>
        <KIU_SeatAvailabilityRQ EchoToken="1" TimeStamp="2012-04-25T12:45:57-03:00" Target="Testing" Version="3.0" SequenceNmbr="1" PrimaryLangID="en-us" TransactionStatusCode="Start">
            <POS>
                <Source AgentSine="MYCV0070B" TerminalID="MYCV00700B" ISOCountry="VE" ISOCurrency="USD" />
            </POS>
            <Query>
                <BookingReference>
                    <ID>$booking->number</ID>
                    <AirlineID>$flight_departure->company_short_name</AirlineID>
                </BookingReference>
            </Query>
            <DataLists>
                <FlightSegmentList>
                    <FlightSegment SegmentKey="SEG1" SegmentRPH="$flight_departure_rph">
                        <Departure>
                            <AirportCode>$flight_departure->departure_airport</AirportCode>
                            <Date>$flight_departure_date</Date>
                            <Time>$flight_departure_time</Time>
                        </Departure>
                        <Arrival>
                            <AirportCode>$flight_departure->arrival_airport</AirportCode>
                            <Date>$flight_arrival_date</Date>
                            <Time>$flight_arrival_time</Time>
                        </Arrival>
                        <MarketingCarrier>
                            <AirlineID>$flight_departure->company_short_name</AirlineID>
                            <FlightNumber>$flight_departure->flight_number</FlightNumber>
                            <ResBookDesigCode>$flight_departure_class</ResBookDesigCode>
                        </MarketingCarrier>
                    </FlightSegment>
                </FlightSegmentList>
            </DataLists>
        </KIU_SeatAvailabilityRQ>
        XML;
        
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://ssl00.kiusys.com/ws3/index.php',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => 'user=VIAJES360GLOBE&password=wQknr9@yvVl$6X98&request='.$xmlstr,
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/x-www-form-urlencoded'
            ),
        ));

        $response = curl_exec($curl);
        curl_close($curl);
        $xml = simplexml_load_string($response, "SimpleXMLElement", LIBXML_NOCDATA);
        $json = json_encode($xml);
        $array_json = json_decode($json,TRUE);
        if(isset($array_json['DataLists']['SeatLists']['Seats']['Location'])) {
            $location = $array_json['DataLists']['SeatLists']['Seats']['Location'];
            $array = array();
            foreach ($location as $key => $value) {
                $array[] = array('colum' => $value['Column'], 'number' => $value['Row']['Number'], 'seating' => $value['Row']['Number'].$value['Column']);
                
                $seating = new Seating();
                $seating->word = $value['Column'];
                $seating->number = $value['Row']['Number'];
                $seating->booking_flight_id = $flight_departure->id;
                $seating->user_id = Auth::user()->id;
                $seating->save();
            }
        }

        return redirect()->route('panel.flights.seating.select', encrypt($booking->id));
    }

    public function seatingSelect($id)
    {
        $id = Crypt::decrypt($id);
        $booking = Booking::findOrFail($id);
        $booking_flight = $booking->bookingFlight;
        if (isset($booking_flight[1])) {
            $flight_return = $booking_flight[1];
            $seatings_return = DB::table('seatings')
            ->select('id', DB::raw('CONCAT(number, "", word) AS seating'))
            ->where('booking_flight_id', $flight_return->id)
            ->where('user_id', Auth::user()->id)
            ->orderBy('number', 'Asc')
            ->pluck('seating', 'id');
        } else {
            $flight_return = null;
            $seatings_return = null;
        }
        
        $flight_departure = $booking_flight[0];
        $seatings_departure = DB::table('seatings')
        ->select('id', DB::raw('CONCAT(number, "", word) AS seating'))
        ->where('booking_flight_id', $flight_departure->id)
        ->where('user_id', Auth::user()->id)
        ->orderBy('number', 'Asc')
        ->pluck('seating', 'id');
        
        $passengers = $booking->bookingPassenger;
        SelectedSeat::where('user_id', Auth::user()->id)->delete();

        return view('panel.flights.seating', compact('booking', 'seatings_departure', 'seatings_return', 'passengers', 'flight_departure', 'flight_return'));
    }

    public function seatingSave($id)
    {
        $id = Crypt::decrypt($id);
        $booking = Booking::findOrFail($id);
        $booking_passenger = $booking->bookingPassenger;
        $booking_flight = $booking->bookingFlight;
        $passengers = SelectedSeat::where('user_id', Auth::user()->id)->get();

        if (isset($booking_flight[1])) {
            $flight_return = $booking_flight[1];
            $flight_return_departure_rph = $flight_return->bookingFlightClass->rph;
            $flight_return_departure_class = $flight_return->bookingFlightClass->res_book_desig_code;
        }
        $flight_departure = $booking_flight[0];
        $flight_departure_rph = $flight_departure->bookingFlightClass->rph;
        $flight_departure_class = $flight_departure->bookingFlightClass->res_book_desig_code;

        $xmlstr = <<<XML
        <?xml version="1.0" encoding="UTF-8"?>
        <KIU_AirBookModifyV2RQ EchoToken="1" TimeStamp="2017-06-01T15:03:11-03:00" Target="Testing" Version="3.0" SequenceNmbr="1" PrimaryLangID="en-us" ModificationType="5">
            <POS>
                <Source AgentSine="MYCV0070B" TerminalID="MYCV00700B" ISOCountry="VE" ISOCurrency="USD" />
            </POS>
            <AirReservation>
                <BookingReferenceID ID="$booking->number" />
                <AirItinerary>
                    <OriginDestinationOptions>
                        <OriginDestinationOption>
                            <FlightSegment DepartureDateTime="$flight_departure->departure_date_time" ArrivalDateTime="$flight_departure->arrival_date_time" FlightNumber="$flight_departure->flight_number" ResBookDesigCode="$flight_departure_class" RPH="$flight_departure->rph">
                                <DepartureAirport LocationCode="$flight_departure->departure_airport" />
                                <ArrivalAirport LocationCode="$flight_departure->arrival_airport" />
                                <MarketingAirline Code="$flight_departure->company_short_name" />
                            </FlightSegment>
                        </OriginDestinationOption>
        XML;
                    if (isset($booking_flight[1])) {
        $xmlstr.=<<<XML
                        <OriginDestinationOption>
                            <FlightSegment DepartureDateTime="$flight_return->departure_date_time" ArrivalDateTime="$flight_return->arrival_date_time" FlightNumber="$flight_return->flight_number" ResBookDesigCode="$flight_return_departure_class" RPH="$flight_return->rph">
                                <DepartureAirport LocationCode="$flight_return->departure_airport" />
                                <ArrivalAirport LocationCode="$flight_return->arrival_airport" />
                                <MarketingAirline Code="$flight_return->company_short_name" />
                            </FlightSegment>
                        </OriginDestinationOption>
         XML;
                    }
        $xmlstr.=<<<XML
                    </OriginDestinationOptions>
                </AirItinerary>
                <TravelerInfo>
        XML;
                    foreach ($booking_passenger as $key => $value) {
                    $name = strtoupper($value->name);
                    $last_name = strtoupper($value->last_name);
                    $traveler_ref_number = $key + 1;
        $xmlstr.=<<<XML
                    <AirTraveler PassengerTypeCode="$value->type">
                        <PersonName>
                            <GivenName>$name</GivenName>
                            <Surname>$last_name</Surname>
                        </PersonName>
                        <Document DocID="$value->document" DocType="$value->document_type"></Document>
                        <TravelerRefNumber RPH=" $value->id"/>
                    </AirTraveler>
        XML;
                    }
        $xmlstr.=<<<XML
                </TravelerInfo>
            </AirReservation>
            <AirBookModifyRQ>
                <TravelerInfo>
                    <SpecialReqDetails>
                        <SeatRequests >
        XML;
                            foreach ($passengers as $key => $value) {
                                $seating = $value->seating->number.$value->seating->word;
                                $traveler_ref_number = $value->bookingPassenger->rph;
                                $flight_ref_number = $value->seating->bookingFlight->rph;
                                
        $xmlstr.=<<<XML
                            <SeatRequest FlightRefNumberRPHLists="$flight_ref_number" TravelerRefNumberRPHList="$traveler_ref_number" SeatNumber="$seating"/>
        XML;
                            }
        $xmlstr.=<<<XML
                        </SeatRequests>
                    </SpecialReqDetails>
                </TravelerInfo>
            </AirBookModifyRQ>
        </KIU_AirBookModifyV2RQ>
        XML;

        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://ssl00.kiusys.com/ws3/index.php',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => 'user=VIAJES360GLOBE&password=wQknr9@yvVl$6X98&request='.$xmlstr,
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/x-www-form-urlencoded'
            ),
        ));

        $response = curl_exec($curl);
        curl_close($curl);
        $xml = simplexml_load_string($response, "SimpleXMLElement", LIBXML_NOCDATA);
        $json = json_encode($xml);
        $array_json = json_decode($json,TRUE);
        $seat = $array_json['SpecialReqDetails']['SeatRequests']['SeatRequest'];
        if (count($seat) > 1) {
            foreach ($seat as $key => $value) {
                $value_passenger = BookingPassenger::where('booking_id', $booking->id)->where('rph', $value['@attributes']['TravelerRefNumberRPHList'])->first();
                $value_booking_flight = BookingFlight::where('booking_id', $booking->id)->where('rph', $value['@attributes']['FlightRefNumberRPHLists'])->first();

                $create_seat = new BookingPassengerSeat();
                $create_seat->flight_ref_number_rph_list = $value['@attributes']['FlightRefNumberRPHLists'];
                $create_seat->traveler_ref_number_rph_list = $value['@attributes']['TravelerRefNumberRPHList'];
                $create_seat->seat_mumber = $value['@attributes']['SeatNumber'];
                $create_seat->status = $value['@attributes']['Status'];
                $create_seat->booking_passenger_id = $value_passenger->id;
                $create_seat->booking_flight_id = $value_booking_flight->id;
                $create_seat->save();
            }
        } else {
            $value_passenger = BookingPassenger::where('booking_id', $booking->id)->where('rph', $seat['@attributes']['TravelerRefNumberRPHList'])->first();
            $value_booking_flight = BookingFlight::where('booking_id', $booking->id)->where('rph', $seat['@attributes']['FlightRefNumberRPHLists'])->first();

            $create_seat = new BookingPassengerSeat();
            $create_seat->flight_ref_number_rph_list = $seat['@attributes']['FlightRefNumberRPHLists'];
            $create_seat->traveler_ref_number_rph_list = $seat['@attributes']['TravelerRefNumberRPHList'];
            $create_seat->seat_mumber = $seat['@attributes']['SeatNumber'];
            $create_seat->status = $seat['@attributes']['Status'];
            $create_seat->booking_passenger_id = $value_passenger->id;
            $create_seat->booking_flight_id = $value_booking_flight->id;
            $create_seat->save();
        }

        SelectedSeat::where('user_id', Auth::user()->id)->delete();

        return redirect()->route('bookings.show', encrypt($booking->id))->with('success', 'Los asientos han sido asignados');
    }

    public function issueTickets($id) {
        $id = Crypt::decrypt($id);
        $booking = Booking::findOrFail($id);
        
        $xmlstr = <<<XML
        <?xml version="1.0" encoding="UTF-8"?>
        <KIU_AirDemandTicketV2RQ xmlns:vc="http://www.w3.org/2007/XMLSchema-versioning" xmlns:ns="http://www.opentravel.org/OTA/2003/05/common" xmlns="http://www.opentravel.org/OTA/2003/05" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.opentravel.org/OTA/2003/05"
        EchoToken="GERDEVTEST1" TimeStamp="2018-08-02T14:30:00" Target="Testing" Version="1.0" SequenceNmbr="1" PrimaryLangID="en-US">
            <POS>
               <Source AgentSine="MYCV0070B" TerminalID="MYCV00700B" ISOCountry="VE" ISOCurrency="USD" />
                    <RequestorID Type="5"/>
                    <BookingChannel Type="1"/>
                </Source>
            </POS>
            <DemandTicketDetail>
                <BookingReference ID="$booking->number" />
                <PaymentInfo PaymentType="1" PaymentRPH="1">
                </PaymentInfo>
                <Endorsement Info="NONEND/NONREF"/>
                <FlightReference SegmentRPHNumber="1" RangePosition="First"/>
                <FlightReference SegmentRPHNumber="1" RangePosition="Last"/>
            </DemandTicketDetail>
        </KIU_AirDemandTicketV2RQ>
        XML;
        dd($xmlstr);
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://ssl00.kiusys.com/ws3/index.php',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => 'user=VIAJES360GLOBE&password=wQknr9@yvVl$6X98&request='.$xmlstr,
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/x-www-form-urlencoded'
            ),
        ));

        $response = curl_exec($curl);
        curl_close($curl);
        $xml = simplexml_load_string($response, "SimpleXMLElement", LIBXML_NOCDATA);
        $json = json_encode($xml);
        $array_json = json_decode($json,TRUE);
        dd($array_json);
    }
}
