<?php

namespace App\Http\Controllers\Panel;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Crypt;
use App\DataTables\Backend\HotelDataTable;
use App\Models\Country;
use App\Models\State;
use App\Models\City;
use App\Models\Hotel;
use App\Models\HotelHistory;
use App\Models\HotelDetail;
use App\Models\HotelAmenitie;
use App\Models\HotelDayPrice;
use App\Models\HotelRoomDetail;
use App\Models\Room;
use App\Models\HotelRoom;
use App\Models\RoomDayPrice;
use App\Models\RoomPriceObservation;
use Auth;

class HotelController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(HotelDataTable $dataTable)
    {
        return $dataTable->render('panel.hotels.index');
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $countries = Country::pluck('name', 'id');

        return view('panel.hotels.create', compact('countries'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $this->validate($request,[
            'name' => 'required',
            'address' => 'required',
            'country' => 'required',
            'state' => 'required',
            'city' => 'required',
        ]);

        $hotel = new Hotel();
        $hotel->name = $request->name;
        $hotel->address = $request->address;
        $hotel->check_in = $request->check_in;
        $hotel->check_out = $request->check_out;
        $hotel->country_id = $request->country;
        $hotel->state_id = $request->state;
        $hotel->city_id = $request->city;
        if ($hotel->save()) {
            $history = new HotelHistory();
            $history->data = json_encode($_POST);
            $history->data_ip = ipGeo();
            $history->status = 'Creado';
            $history->hotel_id = $hotel->id;
            $history->user_id = Auth::user()->id;
            $history->save();

            return redirect()->route('hotels.show', encrypt($hotel->id))->with('success', 'Registro creado exitosamente.');
        } else {
            return redirect()->back()->with('error', 'Error al crear el registro.'); 
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        $id = Crypt::decrypt($id);
        $hotel = Hotel::findOrFail($id);
        $detail = HotelDetail::where('hotel_id', $hotel->id)->first();
        $amenities = HotelAmenitie::where('hotel_id', $hotel->id)->get();
        $rooms = HotelRoom::where('hotel_id', $hotel->id)->get();
        $days = HotelDayPrice::where('hotel_id', $hotel->id)->get();
        $history = $hotel->hoteltHistory;

        return view('panel.hotels.show', compact('hotel', 'detail', 'amenities', 'days', 'rooms', 'history'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        $id = Crypt::decrypt($id);
        $hotel = Hotel::findOrFail($id);
        $countries = Country::pluck('name', 'id');
        $states = State::where('country_id', $hotel->country_id)->pluck('name', 'id');
        $cities = City::where('state_id', $hotel->state_id)->pluck('name', 'id');

        return view('panel.hotels.edit', compact('hotel', 'countries', 'states', 'cities'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        $this->validate($request,[
            'name' => 'required',
            'address' => 'required',
            'country' => 'required',
            'state' => 'required',
            'city' => 'required',
        ]);

        $id = Crypt::decrypt($id);
        $hotel = Hotel::findOrFail($id);
        $hotel->name = $request->name;
        $hotel->address = $request->address;
        $hotel->check_in = $request->check_in;
        $hotel->check_out = $request->check_out;
        $hotel->country_id = $request->country;
        $hotel->state_id = $request->state;
        $hotel->city_id = $request->city;
        if ($hotel->save()) {
            $history = new HotelHistory();
            $history->data = json_encode($_POST);
            $history->data_ip = ipGeo();
            $history->status = 'Modificado';
            $history->hotel_id = $hotel->id;
            $history->user_id = Auth::user()->id;
            $history->save();

            return redirect()->route('hotels.show', encrypt($hotel->id))->with('success', 'Registro actualizado exitosamente.');
        } else {
            return redirect()->back()->with('error', 'Error al crear el registro.'); 
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        $id = Crypt::decrypt($id);
        $hotel = Hotel::findOrFail($id);
        
        $history = new HotelHistory();
        $history->data = json_encode($_POST);
        $history->data_ip = ipGeo();
        $history->status = 'Eliminado';
        $history->hotel_id = $hotel->id;
        $history->user_id = Auth::user()->id;
        $history->save();

        if ($hotel->delete()) {
            return redirect()->route('airports.index')->with('success', '¡Registro eliminado exitosamente!');
        } else {
            return redirect()->back()->with('error', '¡Error!');
        }
    }

    public function detail(string $id)
    {
        session_start();
        unset($_SESSION["item_amenities"]);
        if(isset($_SESSION["item_amenities"])){
            $item_amenities = $_SESSION["item_amenities"];
        }else{
            $item_amenities = null;
        }

        $id = Crypt::decrypt($id);
        $hotel = Hotel::findOrFail($id);
        $amenities = HotelAmenitie::where('hotel_id', $hotel->id)->get();
        $detail = HotelDetail::where('hotel_id', $hotel->id)->first();
        $detail_js = json_encode($detail);

        if (count($amenities) > 0) {
            $item_amenities = array();
            foreach ($amenities as $key => $value) {
                $item_amenities[] = array('data' => $value->name);
            }
            $_SESSION['item_amenities'] = $item_amenities;
        }
        
        return view('panel.hotels.detail', compact('hotel', 'item_amenities', 'detail', 'detail_js'));
    }

    public function addAmenities(Request $request)
    {
        if($request->ajax()){
            session_start();
            if (isset($_SESSION['item_amenities'])) {
                $item_amenities = $_SESSION['item_amenities'];
            }
            $input_1 = $request->input_1;
            $item_amenities[] = array('data' => $input_1);
            $_SESSION['item_amenities'] = $item_amenities;
            
            $html = '';
            $html = '<div class="container_amenities">';
                $html.='<div class="kt-section__content table-responsive">';
                    $html.='<table class="table">';
                        $html.='<thead class="thead-light">';
                            $html.='<tr>';
                                $html.='<th>Estatus</th>';
                                $html.='<th>Acción</th>';
                            $html.='</tr>';
                        $html.='</thead>';
                        $html.='<tbody>';
                            foreach ($item_amenities as $key => $value) {
                                $html.='<tr>';
                                    $html.='<td>'.$value['data'].'</td>';
                                    $html.='<td><button type="button" class="btn btn-danger btn-sm delete_input_1" attr_delete_input_1="'.$key.'"><i class="fa fa-trash"></i></button></td>';
                                $html.='</tr>';
                            }
                        $html.='</tbody>';
                    $html.='</table>';
                $html.='</div>';
            $html.='</div>';

            return response()->json([
                'html' => $html,
            ]);
        }
    }

    public function deleteAmenities(Request $request)
    {
        if($request->ajax()){
            session_start();
            if (isset($_SESSION['item_amenities'])) {
                $item_amenities = $_SESSION['item_amenities'];
            }
            $input_1 = $request->input_1;
            unset($item_amenities[$input_1]);
            $_SESSION["item_amenities"] = $item_amenities;

            $html = '';
            $html = '<div class="container_amenities">';
                $html.='<div class="kt-section__content table-responsive">';
                    $html.='<table class="table">';
                        $html.='<thead class="thead-light">';
                            $html.='<tr>';
                                $html.='<th>Estatus</th>';
                                $html.='<th>Acción</th>';
                            $html.='</tr>';
                        $html.='</thead>';
                        $html.='<tbody>';
                            foreach ($item_amenities as $key => $value) {
                                $html.='<tr>';
                                    $html.='<td>'.$value['data'].'</td>';
                                    $html.='<td><button type="button" class="btn btn-danger btn-sm delete_input_1" attr_delete_input_1="'.$key.'"><i class="fa fa-trash"></i></button></td>';
                                $html.='</tr>';
                            }
                        $html.='</tbody>';
                    $html.='</table>';
                $html.='</div>';
            $html.='</div>';

            return response()->json([
                'html' => $html,
            ]);
        }
    }

    public function detailSave(Request $request, $id)
    {
        session_start();
        if (isset($_SESSION['item_amenities'])) {
            $item_amenities = $_SESSION['item_amenities'];
        } else {
            $item_amenities = null;
        }

        if(isset($_SESSION["item_rooms"])){
            $item_rooms = $_SESSION["item_rooms"];
        }else{
            $item_rooms = null;
        }

        $id = Crypt::decrypt($id);
        $hotel = Hotel::findOrFail($id);

        $detail = HotelDetail::where('hotel_id', $hotel->id)->first();
        if ($detail) {
            $detail->all_inclusive = $request->all_inclusive;
            $detail->all_inclusive_detail = $request->all_inclusive_detail;
            $detail->located_beach = $request->located_beach;
            $detail->name_beach = $request->name_beach;
            $detail->sustainability_travelife = $request->sustainability_travelife;
            $detail->certification_type = $request->certification_type;
            $detail->exonerated_infant = $request->exonerated_infant;
            $detail->infants_age = $request->infants_age;
            /*if ($request->price == 'Si') {
                if ($request->type_price == 'General') {
                    $detail->price = 'Si';
                    $detail->type_price = $request->type_price;
                    $detail->general_price = str_replace(',', '.', $request->general_price);
                    $detail->price_rest_year = null;
                } else {
                    $detail->price = 'Si';
                    $detail->type_price = $request->type_price;
                    $detail->general_price = null;
                    $detail->price_rest_year = $request->rest_year;
                }
            } else {
                $detail->price = 'No';
                $detail->type_price = null;
                $detail->general_price = null;
                $detail->price_rest_year = null;
            }*/
            $detail->free_wifi = $request->free_wifi;
            $detail->amenities = $request->amenities;
            $detail->hotel_id = $hotel->id;
            $detail->save();
        } else {
            $detail = new HotelDetail();
            $detail->all_inclusive = $request->all_inclusive;
            $detail->all_inclusive_detail = $request->all_inclusive_detail;
            $detail->located_beach = $request->located_beach;
            $detail->name_beach = $request->name_beach;
            $detail->sustainability_travelife = $request->sustainability_travelife;
            $detail->certification_type = $request->certification_type;
            $detail->exonerated_infant = $request->exonerated_infant;
            $detail->infants_age = $request->infants_age;
            /*if ($request->price == 'Si') {
                $detail->price = 'Si';
                $detail->type_price = $request->type_price;
                $detail->general_price = str_replace(',', '.', $request->general_price);
            } else {
                $detail->price = 'No';
                $detail->type_price = null;
                $detail->general_price = null;
            }*/
            $detail->free_wifi = $request->free_wifi;
            $detail->amenities = $request->amenities;
            $detail->hotel_id = $hotel->id;
            $detail->save();
        }
        
        HotelAmenitie::where('hotel_id', $hotel->id)->delete();
        if ($item_amenities != null && count($item_amenities) > 0) {
            foreach ($item_amenities as $key => $value) {
                $amenitie = new HotelAmenitie();
                $amenitie->name = $value['data'];
                $amenitie->hotel_id = $hotel->id;
                $amenitie->save();
            }
        }

        /*HotelDayPrice::where('hotel_id', $hotel->id)->delete();
        if ($item_rooms != null && count($item_rooms) > 0) {
            foreach ($item_rooms as $key => $value) {
                $room = new HotelDayPrice();
                $room->in = $value['initial_date'];
                $room->out = $value['final_date'];
                $room->type_room = $value['room_type'];
                $room->price = $value['price_date'];
                $room->hotel_id = $hotel->id;
                $room->save();
            }
        }*/

        return redirect()->route('hotels.show', encrypt($hotel->id))->with('success', 'Registro actualizado exitosamente.');
    }

    public function room($id)
    {
        $id = Crypt::decrypt($id);
        $hotel = Hotel::findOrFail($id);
        $rooms = Room::pluck('name', 'id');
        $rooms->prepend('Nueva Habitación', 'new');

        return view('panel.hotels.room', compact('hotel', 'rooms'));
    }

    public function roomSave(Request $request, $id)
    {
        $id = Crypt::decrypt($id);
        $hotel = Hotel::findOrFail($id);
        
        $this->validate($request,[
            'type' => 'required',
            'room_detail' => 'required'
        ]);

        if ($request->type == 'new') {
            $this->validate($request,[
                'type' => 'required',
                'new_room' => 'required',
                'room_detail' => 'required'
            ]);

            $room = new Room();
            $room->name = $request->new_room;
            $room->save();
        } else {
            $type = intval($request->type);
            $room = Room::findOrFail($type);
        }
        
        $insert = new HotelRoom();
        $insert->detail = $request->room_detail;
        $insert->room_id = $room->id;
        $insert->hotel_id = $hotel->id;
        $insert->save();

        return redirect()->route('hotels.show', encrypt($hotel->id))->with('success', 'Habitacion agregada al exitosamente.');
    }

    public function roomEdit($id)
    {
        $id = Crypt::decrypt($id);
        $room = HotelRoom::findOrFail($id);
        $hotel = HotelRoom::findOrFail($room->hotel_id);
        $rooms = Room::pluck('name', 'id');
        $rooms->prepend('Nueva Habitación', 'new');

        return view('panel.hotels.room_edit', compact('room', 'rooms', 'hotel'));
    }

    public function roomUpdate(Request $request, $id)
    {
        $id = Crypt::decrypt($id);
        $insert = HotelRoom::findOrFail($id);

        $this->validate($request,[
            'type' => 'required',
            'room_detail' => 'required'
        ]);

        if ($request->type == 'new') {
            $this->validate($request,[
                'type' => 'required',
                'new_room' => 'required',
                'room_detail' => 'required'
            ]);

            $room = new Room();
            $room->name = $request->new_room;
            $room->save();
        } else {
            $type = intval($request->type);
            $room = Room::findOrFail($type);
        }

        $hotel = Hotel::findOrFail($insert->hotel_id);

        $insert->detail = $request->room_detail;
        $insert->room_id = $room->id;
        $insert->hotel_id = $hotel->id;
        $insert->save();

        return redirect()->route('hotels.show', encrypt($hotel->id))->with('success', 'Habitacion agregada al exitosamente.');
    }

    public function roomPrice($room)
    {
        session_start();
        if(isset($_SESSION["item_date"])){
            $item_date = $_SESSION["item_date"];
        }else{
            $item_date = null;
        }
        unset($_SESSION["item_date"]);

        $room = Crypt::decrypt($room);
        $query = HotelRoom::findOrFail($room);
        $hotel = Hotel::findOrFail($query->hotel_id);
        $prices = RoomDayPrice::where('hotel_room_id', $query->id)->get();
        $item_date = array();
        foreach ($prices as $key => $value) {
            $item_date[] = array('initial_date' => $value->in, 'final_date' => $value->out, 'price_date' => $value->price);
            
            $_SESSION['item_date'] = $item_date;
        }

        return view('panel.hotels.price', compact('hotel', 'query', 'item_date'));
    }

    public function search(Request $request)
    {
        $term = $request->input('term');

        $amenities = HotelAmenitie::where('name', 'like', '%' . $term . '%')->get();

        return response()->json($amenities);
    }

    public function addDate(Request $request)
    {
        if($request->ajax()){
            session_start();
            if (isset($_SESSION['item_date'])) {
                $item_date = $_SESSION['item_date'];
            }

            $initial_date = $request->initial_date;
            $final_date = $request->final_date;
            $room_type = $request->room_type;
            $price_date = str_replace(',', '.', $request->price_date);

            $item_date[] = array('initial_date' => $initial_date, 'final_date' => $final_date, 'price_date' => $price_date);
            
            $_SESSION['item_date'] = $item_date;
            $count_rooms = count($item_date);

            $html = '';
            $html.='<div class="container_price_date">';
                if ($item_date != null) {
                    $html.='<div class="kt-section__content table-responsive">';
                        $html.='<table class="table">';
                            $html.='<thead class="thead-light">';
                                $html.='<tr>';
                                    $html.='<th>In</th>';
                                    $html.='<th>Out</th>';
                                    $html.='<th>Precio</th>';
                                    $html.='<th>Acción</th>';
                                $html.='</tr>';
                            $html.='</thead>';
                            $html.='<tbody>';
                                foreach ($item_date as $key => $value) {
                                    $html.='<tr>';
                                        $html.='<td>'.date("d-m-Y", strtotime($value['initial_date'])).'</td>';
                                        $html.='<td>'.date("d-m-Y", strtotime($value['final_date'])).'</td>';
                                        $html.='<td>'.number_format($value['price_date'], 2).'</td>';
                                        $html.='<td><button type="button" class="btn btn-danger btn-sm deleteDate" attr_delete_date="'.$key.'"><i class="fa fa-trash"></i></button></td>';
                                    $html.='</tr>';
                                }
                            $html.='</tbody>';
                        $html.='</table>';
                    $html.='</div>';
                }
            $html.='</div>';

            return response()->json([
                'html' => $html,
                'count_rooms' => $count_rooms
            ]);
        }
    }

    public function deleteDate(Request $request)
    {
        if($request->ajax()){
            session_start();
            if (isset($_SESSION['item_date'])) {
                $item_date = $_SESSION['item_date'];
            }
            $id_date = $request->id_date;
            unset($item_date[$id_date]);
            $_SESSION["item_date"] = $item_date;
            $count_rooms = count($item_date);

            $html = '';
            $html.='<div class="container_price_date">';
                if ($item_date != null) {
                    $html.='<div class="kt-section__content table-responsive">';
                        $html.='<table class="table">';
                            $html.='<thead class="thead-light">';
                                $html.='<tr>';
                                    $html.='<th>In</th>';
                                    $html.='<th>Out</th>';
                                    $html.='<th>Precio</th>';
                                    $html.='<th>Acción</th>';
                                $html.='</tr>';
                            $html.='</thead>';
                            $html.='<tbody>';
                                foreach ($item_date as $key => $value) {
                                    $html.='<tr>';
                                        $html.='<td>'.date("d-m-Y", strtotime($value['initial_date'])).'</td>';
                                        $html.='<td>'.date("d-m-Y", strtotime($value['final_date'])).'</td>';
                                        $html.='<td>'.$value['price_date'].'</td>';
                                        $html.='<td><button type="button" class="btn btn-danger btn-sm deleteDate" attr_delete_date="'.$key.'"><i class="fa fa-trash"></i></button></td>';
                                    $html.='</tr>';
                                }
                            $html.='</tbody>';
                        $html.='</table>';
                    $html.='</div>';
                }
            $html.='</div>';

            return response()->json([
                'html' => $html,
                'count_rooms' => $count_rooms
            ]);
        }
    }

    public function roomPriceSave(Request $request, $id)
    {
        session_start();
        if (isset($_SESSION['item_date'])) {
            $item_date = $_SESSION['item_date'];
        }

        $id = decrypt($id);
        $query = HotelRoom::where('room_id', $id)->first();
        RoomDayPrice::where('hotel_room_id', $query->room_id)->delete();

        if ($request->type_price == 'Por Fecha') {
            foreach ($item_date as $key => $value) {
                $price = new RoomDayPrice();
                $price->in = $value['initial_date'];
                $price->out = $value['final_date'];
                $price->price = $value['price_date'];
                $price->hotel_room_id = $query->room_id;
                $price->save();
            }

            $query->price_rest_of_year = str_replace(',', '.', $request->rest_year);
            $query->save();
        } else {
            $query->price_rest_of_year = null;
            $query->general_price = str_replace(',', '.', $request->general_price);
            $query->save();
        }

        if (isset($request->observation)) {
            $observation = new RoomPriceObservation();
            $observation->observation = $request->observation;
            $observation->hotel_room_id = $query->room_id;
            $observation->save();
        }

        return redirect()->route('hotels.show', encrypt($query->hotel_id))->with('success', 'Precios agregados al exitosamente.');
    }

    public function roomPriceDelete($id)
    {
        $id = decrypt($id);
        $query = HotelRoom::where('room_id', $id)->first();
        RoomDayPrice::where('hotel_room_id', $query->room_id)->delete();
        $query->delete();

        return redirect()->back()->with('success', 'Habitación eliminada exitosamente.');
    }
}
