<?php

namespace App\Http\Controllers\Panel;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Crypt;
use Auth;
use App\DataTables\Backend\PermissionDataTable;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use App\Models\PermissionHistory;

class PermissionController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(PermissionDataTable $dataTable)
    {
        return $dataTable->render('panel.permissions.index');
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('panel.permissions.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $this->validate($request,[
            'name' => 'required',
        ]);

        $permission = Permission::create(['name' => strtolower($request->name)]);

        $history = new PermissionHistory();
        $history->data = json_encode($_POST);
        $history->data_ip = ipGeo();
        $history->status = 'Creado';
        $history->permission_id = $permission->id;
        $history->user_id = Auth::user()->id;
        $history->save();

        return redirect()->route('permissions.show', encrypt($permission->id))->with('success', 'Registro creado exitosamente.');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        $id = Crypt::decrypt($id);
        $permission = Permission::findOrFail($id);
        $history = PermissionHistory::where('permission_id', $permission->id)->get();

        return view('panel.permissions.show', compact('permission', 'history'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        $id = Crypt::decrypt($id);
        $permission = Permission::findOrFail($id);

        return view('panel.permissions.edit', compact('permission'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        $this->validate($request,[
            'name' => 'required',
        ]);

        $id = Crypt::decrypt($id);
        $permission = Permission::findOrFail($id);
        $permission->name = strtolower($request->name);
        $permission->save();

        $history = new PermissionHistory();
        $history->data = json_encode($_POST);
        $history->data_ip = ipGeo();
        $history->status = 'Modificado';
        $history->permission_id = $permission->id;
        $history->user_id = Auth::user()->id;
        $history->save();

        return redirect()->route('permissions.show', encrypt($permission->id))->with('success', 'Registro modificado exitosamente.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }

    public function assignment()
    {
        $roles = Role::all();

        return view('panel.permissions.assignment', compact('roles'));
    }

    public function assignmentSave(Request $request)
    {
        $id = $request->rolAct;
        $permissions = $request->perAsig;
        $no_permissions = $request->perNoAsig;
        $role = Role::findOrFail($id);
        $role->revokePermissionTo($no_permissions);
        $role->syncPermissions($permissions);

        return redirect()->back()->with('success', 'Permisos asignados exitosamente.');
    }
}
