<?php

namespace App\Http\Controllers\Panel;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Crypt;
use Auth;
use App\User;


class ProfileController extends Controller
{
    public function edit()
    {
        $user = Auth::user();
        return view('panel.profile.edit', compact('user'));
    }

    public function update(Request $request)
    {
        $this->validate($request,[
            'name' => 'required',
            'last_name' => 'required',
        ]);

        $user = Auth::user();

        if (!$request->current_password) {
            $user->name = $request->name;
            $user->last_name = $request->last_name;
            $user->save();

            return redirect()->back()->with('success', 'Usuario actualizado correctamente.');
        } else {
            $this->validate($request, [
                'current_password' => 'required',
                'new_password' => 'required',
            ]);

            if (\Hash::check($request->current_password, Auth::user()->password)) {
                $user->name = $request->name;
                $user->last_name = $request->last_name;
                $user->password = bcrypt($request->new_password);
                $user->save();

                return redirect()->back()->with('success', 'Contraseña actualizada correctamente.');
            } else {
                return redirect()->back()->with('error', 'La contraseña actual no coincide con nuestros registros');
            }
        }
    }
}
