<?php

namespace App\Http\Controllers\Panel;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Crypt;
use Auth;
use App\DataTables\Backend\RoleDataTable;
use Spatie\Permission\Models\Role;
use App\Models\RoleHistory;

class RoleController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(RoleDataTable $dataTable)
    {
        return $dataTable->render('panel.roles.index');
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('panel.roles.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $this->validate($request,[
            'name' => 'required',
        ]);

        $role = Role::create(['name' => strtolower($request->name)]);

        $history = new RoleHistory();
        $history->data = json_encode($_POST);
        $history->data_ip = ipGeo();
        $history->status = 'Created';
        $history->role_id = $role->id;
        $history->user_id = Auth::user()->id;
        $history->save();

        return redirect()->route('roles.show', encrypt($role->id))->with('success', 'Registro creado exitosamente.');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        $id = Crypt::decrypt($id);
        $role = Role::findOrFail($id);
        $history = RoleHistory::where('role_id', $role->id)->get();

        return view('panel.roles.show', compact('role', 'history'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        $id = Crypt::decrypt($id);
        $role = Role::findOrFail($id);

        return view('panel.roles.edit', compact('role'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        $this->validate($request,[
            'name' => 'required',
        ]);
        
        $id = Crypt::decrypt($id);
        $role = Role::findOrFail($id);
        $role->name = strtolower($request->name);
        $role->save();

        $history = new RoleHistory();
        $history->data = json_encode($_POST);
        $history->data_ip = ipGeo();
        $history->status = 'Updated';
        $history->role_id = $role->id;
        $history->user_id = Auth::user()->id;
        $history->save();

        return redirect()->route('roles.show', encrypt($role->id))->with('success', 'Registro modificado exitosamente.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
