<?php

namespace App\Http\Controllers\Panel;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Crypt;
use App\DataTables\Backend\TourismDataTable;
use App\Models\Tourism;
use App\Models\Customer;
use App\Models\TourismDetail;
use Auth;
use DB;

class TourismController extends Controller
{
    public function index(TourismDataTable $dataTable)
    {
        return $dataTable->render('panel.tourism.index');
    }

    public function create()
    {
        session_start();
        if(isset($_SESSION["items"])){
            $items = $_SESSION["items"];
        }else{
            $items = null;
        }

        if(isset($_SESSION["items_insurance"])){
            $items_insurance = $_SESSION["items_insurance"];
        }else{
            $items_insurance = null;
        }
        
        return view('panel.tourism.create', compact('items', 'items_insurance'));
    }

    public function store(Request $request)
    {
        session_start();
        if (isset($_SESSION["items"])) {
            $items = $_SESSION["items"];

            if (count($items) < 1) {
                return redirect()->back()->with('error', 'Necesita agregar items a cotizar');
            }
        } else {
            return redirect()->back()->with('error', 'Necesita agrear items a cotizar');
        }

        $customer = new Customer();
        $customer->name = $request->customer;
        $customer->phone = $request->phone;
        $customer->email = $request->email;
        $customer->save();

        $tourism = new Tourism();
        $tourism->in = $request->in;
        $tourism->out = $request->out;
        $tourism->zone = $request->zone;
        $tourism->customer_id = $customer->id;
        $tourism->user_id = Auth::user()->id;
        if ($tourism->save()) {
            foreach ($items as $key => $value) {
                $insert = new TourismDetail();
                $insert->type = $value['type'];
                $insert->number_type = $value['number_type'];
                $insert->product = $value['product'];
                $insert->amount = $value['amount'];
                $insert->quantity = $value['quantity'];
                $insert->total = $value['total'];
                $insert->observation = $value['observation'];
                $insert->tourism_id = $tourism->id;
                $insert->save();
            }
        }

        unset($_SESSION["items"]);

        return redirect()->route('tourism.show', encrypt($tourism->id))->with('success', 'Paquete turistico creado con exito');
    }

    public function show($id)
    {
        $id = Crypt::decrypt($id);
        $tourism = Tourism::findOrFail($id);
        
        return view('panel.tourism.show', compact('tourism'));
    }

    public function edit($id)
    {
        session_start();
        if(isset($_SESSION["items"])){
            unset($_SESSION["items"]);
        }
        $id = Crypt::decrypt($id);
        $tourism = Tourism::findOrFail($id);
        $details = $tourism->tourismDetail;

        foreach ($details as $key => $value) {
            if (!isset($_SESSION["items"]) || count($_SESSION["items"]) < 1) {
                $items = array();
                $items[] = array('type' => $value->type, 'number_type' => $value->number_type, 'product' => $value->product, 'amount' => $value->amount, 'quantity' => $value->quantity, 'total' => $value->total, 'observation' => $value->observation);
                $_SESSION["items"] = $items;
            } else {
                $items = $_SESSION["items"];
                $items[] = array('type' => $value->type, 'number_type' => $value->number_type, 'product' => $value->product, 'amount' => $value->amount, 'quantity' => $value->quantity, 'total' => $value->total, 'observation' => $value->observation);
                $_SESSION["items"] = $items;
            }
        }
        
        return view('panel.tourism.edit', compact('tourism', 'items'));
    }

    public function update(Request $request, $id)
    {
        session_start();
        if(isset($_SESSION["items"])){
            $items = $_SESSION["items"];
        }

        $id = Crypt::decrypt($id);
        $tourism = Tourism::findOrFail($id);
        $customer = Customer::findOrFail($tourism->customer_id);
        TourismDetail::where('tourism_id', $tourism->id)->delete();
        
        $customer->name = $request->customer;
        $customer->phone = $request->phone;
        $customer->email = $request->email;
        $customer->save();

        $tourism->in = $request->in;
        $tourism->out = $request->out;
        $tourism->zone = $request->zone;
        $tourism->customer_id = $customer->id;
        $tourism->user_id = Auth::user()->id;
        if ($tourism->save()) {
            foreach ($items as $key => $value) {
                $insert = new TourismDetail();
                $insert->type = $value['type'];
                $insert->number_type = $value['number_type'];
                $insert->product = $value['product'];
                $insert->amount = $value['amount'];
                $insert->quantity = $value['quantity'];
                $insert->total = $value['total'];
                $insert->observation = $value['observation'];
                $insert->tourism_id = $tourism->id;
                $insert->save();
            }
        }

        unset($_SESSION["items"]);

        return redirect()->route('tourism.show', encrypt($tourism->id))->with('success', 'Paquete turistico creado con exito');
    }

    public function destroy($id)
    {
        $id = Crypt::decrypt($id);
        $tourism = Tourism::findOrFail($id);
        TourismDetail::where('tourism_id', $tourism->id)->delete();
        Customer::where('id', $tourism->customer_id)->delete();
        $tourism->delete();

        return redirect()->route('tourism.index')->with('success', '¡Registro eliminado exitosamente!');
    }

    public function sale($id)
    {
        $id = Crypt::decrypt($id);
        $tourism = Tourism::findOrFail($id);
        $tourism->type = 'Venta';
        $tourism->save();

        return redirect()->route('tourism.show', encrypt($tourism->id))->with('success', 'Paquete turistico creado con exito');
    }

    public function escalaSend()
    {
        return 'Probar Conexión a Escala';
    }

    public function print($id)
    {
        $id = Crypt::decrypt($id);
        $tourism = Tourism::findOrFail($id);

        return view('panel.tourism.print', compact('tourism'));
    }
}
