<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Booking extends Model
{
    use HasFactory;

    protected $fillable = [
        'number',
        'last_modification_date',
        'ticket_time_limit',
        'status'
    ];

    public function bookingFlight()
    {
        return $this->hasMany('App\Models\BookingFlight');
    }

    public function bookingPassenger()
    {
        return $this->hasMany('App\Models\BookingPassenger');
    }
}
