<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BookingFlight extends Model
{
    use HasFactory;

    protected $fillable = [
        'flight_number',
        'departure_date_time',
        'arrival_date_time',
        'departure_airport',
        'arrival_airport',
        'company_short_name',
        'stop_quantity',
        'journey_duration',
        'type',
        'rph'
    ];

    public function bookingFlightClass()
    {
        return $this->hasOne('App\Models\BookingFlightClass');
    }
}
