<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BookingPassenger extends Model
{
    use HasFactory;

    protected $fillable = [
        'type',
        'name',
        'last_name',
        'document_type',
        'document',
        'phone',
        'zip_code',
        'birthdate',
        'rph'
    ];

    public function booking()
    {
        return $this->belongsTo('App\Models\Booking');
    }

    public function country()
    {
        return $this->belongsTo('App\Models\Country');
    }

    public function selectedSeat()
    {
        return $this->hasOne('App\Models\SelectedSeat');
    }

    public function bookingPassengerSeat()
    {
        return $this->hasMany('App\Models\BookingPassengerSeat');
    }

    /*public function bookingPassengerSeat()
    {
        return $this->hasOne('App\Models\BookingPassengerSeat');
    }*/
}
