<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FlightClass extends Model
{
    use HasFactory;

    protected $fillable = [
        'res_book_desig_code',
        'res_book_desig_quantity',
        'rph',
        'amount'
    ];

    public function passengerClass()
    {
        return $this->hasMany('App\Models\FlightClassPassenger');
    }

    public function flight()
    {
        return $this->belongsTo('App\Models\Flight');
    }

    public function fareSelectedFlight()
    {
        return $this->hasOne('App\Models\FareSelectedFlight');
    }
}
