<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class HotelRoom extends Model
{
    use HasFactory, SoftDeletes;

    public function room()
    {
        return $this->belongsTo('App\Models\Room');
    }

    public function roomDayPrice()
    {
        return $this->hasMany('App\Models\RoomDayPrice');
    }

    public function roomPriceObservation()
    {
        return $this->hasOne('App\Models\RoomPriceObservation');
    }
}
