<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Passenger extends Model
{
    use HasFactory;

    protected $fillable = [
        'type',
        'name',
        'last_name',
        'document_type',
        'document',
        'company_short_name',
        'zip_code',
        'phone',
    ];

    public function user()
    {
        return $this->belongsTo('App\Models\User');
    }
}
