<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PermissionHistory extends Model
{
    use HasFactory;

    protected $fillable = [
        'data',
        'data_ip',
        'status',
    ];

    public function permission()
    {
        return $this->hasMany('Spatie\Permission\Models\Permission');
    }

    public function user()
    {
        return $this->belongsTo('App\Models\User');
    }
}
