<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class RoleHistory extends Model
{
    use HasFactory;

    protected $fillable = [
        'data',
        'data_ip',
        'status',
    ];

    public function role()
    {
        return $this->hasMany('Spatie\Permission\Models\Role');
    }

    public function user()
    {
        return $this->belongsTo('App\Models\User');
    }
}
