<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Seating extends Model
{
    use HasFactory;

    protected $fillable = [
        'word', 'number',
    ];

    public function selectedSeat()
    {
        return $this->hasOne('App\Models\SelectedSeat');
    }

    public function bookingFlight()
    {
        return $this->belongsTo('App\Models\BookingFlight');
    }
}
