<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Tourism extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'in',
        'out',
        'zone',
        'type'
    ];

    public function user()
    {
        return $this->belongsTo('App\Models\User');
    }

    public function customer()
    {
        return $this->belongsTo('App\Models\Customer');
    }

    public function tourismDetail()
    {
        return $this->hasMany('App\Models\TourismDetail');
    }
}
