<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('booking_flights', function (Blueprint $table) {
            $table->id();
            $table->string('flight_number')->nullable();
            $table->timestamp('departure_date_time')->nullable();
            $table->timestamp('arrival_date_time')->nullable();
            $table->string('departure_airport')->nullable();
            $table->string('arrival_airport')->nullable();
            $table->string('company_short_name')->nullable();
            $table->string('stop_quantity')->nullable();
            $table->string('journey_duration')->nullable();
            $table->enum('type', ['going', 'return'])->default('going');
            $table->int('rph')->nullable();
            $table->bigInteger('booking_id')->unsigned();
            $table->foreign('booking_id')
                ->references('id')->on('bookings')
                ->onDelete('cascade')
                ->onUpdate('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('booking_flights');
    }
};
