<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('booking_flight_classes', function (Blueprint $table) {
            $table->id();
            $table->string('res_book_desig_code')->nullable();
            $table->string('res_book_desig_quantity')->nullable();
            $table->string('rph')->nullable();
            $table->decimal('amount', 20, 2)->nullable();
            $table->bigInteger('booking_flight_id')->unsigned();
            $table->foreign('booking_flight_id')
                ->references('id')->on('booking_flights')
                ->onDelete('cascade')
                ->onUpdate('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('booking_flight_classes');
    }
};
