<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('booking_flight_class_passengers', function (Blueprint $table) {
            $table->id();
            $table->enum('passenger_type', ['ADT', 'CNN', 'INF'])->nullable();
            $table->integer('passenger_quantity')->nullable();
            $table->bigInteger('booking_flight_class_id')->unsigned();
            $table->foreign('booking_flight_class_id')
                ->references('id')->on('booking_flight_classes')
                ->onDelete('cascade')
                ->onUpdate('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('booking_flight_class_passengers');
    }
};
