<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('booking_passengers', function (Blueprint $table) {
            $table->id();
            $table->enum('type', ['ADT', 'CNN', 'INF']);
            $table->string('name')->nullable();
            $table->string('last_name')->nullable();
            $table->enum('document_type', ['NI', 'PP'])->nullable();
            $table->string('document')->nullable();
            $table->string('phone')->nullable();
            $table->string('zip_code')->nullable();
            $table->date('birthdate')->nullable();
            $table->int('rph')->nullable();
            $table->bigInteger('country_id')->unsigned()->nullable();
            $table->foreign('country_id')
                ->references('id')->on('countries')
                ->onDelete('cascade')
                ->onUpdate('cascade');
            $table->bigInteger('booking_id')->unsigned();
            $table->foreign('booking_id')
                ->references('id')->on('bookings')
                ->onDelete('cascade')
                ->onUpdate('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('booking_passengers');
    }
};
