<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('selected_seats', function (Blueprint $table) {
            $table->id();
            $table->enum('type', ['going', 'return'])->default('going');
            $table->bigInteger('seating_id')->unsigned();
            $table->foreign('seating_id')
                ->references('id')->on('seatings')
                ->onDelete('cascade')
                ->onUpdate('cascade');
            $table->bigInteger('booking_passenger_id')->unsigned();
            $table->foreign('booking_passenger_id')
                ->references('id')->on('booking_passengers')
                ->onDelete('cascade')
                ->onUpdate('cascade');
            $table->bigInteger('user_id')->unsigned();
            $table->foreign('user_id')
                ->references('id')->on('users')
                ->onDelete('cascade')
                ->onUpdate('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('selected_seats');
    }
};
