<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('booking_passenger_seats', function (Blueprint $table) {
            $table->id();
            $table->integer('flight_ref_number_rph_list')->nullable();
            $table->integer('traveler_ref_number_rph_list')->nullable();
            $table->text('seat_mumber')->nullable();
            $table->text('status')->nullable();
            $table->bigInteger('booking_passenger_id')->unsigned();
            $table->foreign('booking_passenger_id')
                ->references('id')->on('booking_passengers')
                ->onDelete('cascade')
                ->onUpdate('cascade');
            $table->bigInteger('booking_flight_id')->unsigned();
            $table->foreign('booking_flight_id')
                ->references('id')->on('booking_flights')
                ->onDelete('cascade')
                ->onUpdate('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('booking_passenger_seats');
    }
};
