<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tourism_details', function (Blueprint $table) {
            $table->id();
            $table->enum('type', ['ADT', 'CNN'])->nullable();
            $table->integer('number_type')->nullable();
            $table->text('product')->nullable();
            $table->decimal('amount', 20, 2)->nullable();
            $table->decimal('quantity', 20, 2)->nullable();
            $table->decimal('total', 20, 2)->nullable();
            $table->longText('observation')->nullable();
            $table->bigInteger('tourism_id')->unsigned();
            $table->foreign('tourism_id')
                ->references('id')->on('tourisms')
                ->onDelete('cascade')
                ->onUpdate('cascade');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tourism_details');
    }
};
