<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('hotel_details', function (Blueprint $table) {
            $table->id();
            $table->enum('all_inclusive', ['Si', 'No'])->default('No');
            $table->longText('all_inclusive_detail')->nullable();
            $table->enum('located_beach', ['Si', 'No'])->default('No');
            $table->longText('name_beach')->nullable();
            $table->enum('sustainability_travelife', ['Si', 'No'])->default('No');
            $table->longText('certification_type')->nullable();
            $table->enum('free_wifi', ['Si', 'No'])->default('No');
            $table->enum('amenities', ['Si', 'No'])->default('No');
            $table->enum('price', ['Si', 'No'])->default('No');
            $table->enum('type_price', ['General', 'Por Fecha'])->nullable();
            $table->decimal('general_price', 10, 2)->nullable();
            $table->bigInteger('hotel_id')->unsigned();
            $table->foreign('hotel_id')
                ->references('id')->on('hotels')
                ->onDelete('cascade')
                ->onUpdate('cascade');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('hotel_details');
    }
};
