<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('room_price_observations', function (Blueprint $table) {
            $table->id();
            $table->longText('observation')->nullable();
            $table->bigInteger('hotel_room_id')->unsigned();
            $table->foreign('hotel_room_id')
                ->references('id')->on('hotel_rooms')
                ->onDelete('cascade')
                ->onUpdate('cascade');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('room_price_observations');
    }
};
