@extends('layouts.panel.base')
@section('airline-active', 'kt-menu__item--active')
@section('title', 'Aerolíneas')
@section('content')
	<div class="kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor">
		<div class="kt-subheader   kt-grid__item" id="kt_subheader">
			<div class="kt-subheader__main">
				<h3 class="kt-subheader__title">Aerolíneas</h3>
				<span class="kt-subheader__separator kt-hidden"></span>
				<div class="kt-subheader__breadcrumbs">
					<a href="{{ route('panel.dashboard') }}" class="kt-subheader__breadcrumbs-home"><i class="flaticon2-shelter"></i></a>
					<span class="kt-subheader__breadcrumbs-separator"></span>
					<a href="{{ route('airlines.index') }}" class="kt-subheader__breadcrumbs-link">
						Listado
					</a>
				</div>
			</div>
		</div>
		<div class="kt-content  kt-grid__item kt-grid__item--fluid" id="kt_content">
			<div class="row">
				<div class="col-lg-12">
					<div class="kt-portlet">
						<div class="kt-portlet__head">
							<div class="kt-portlet__head-label">
								<h3 class="kt-portlet__head-title">
									Aerolíneas
								</h3>
							</div>
						</div>
						<div class="kt-portlet__body">
						    <div class="kt-portlet__head-wrapper mb_dv">
						        @if(Session::has('success'))
						            <div class="alert alert-success" role="alert">
						                <div class="alert-text">{{ Session::get('success') }}</div>
						            </div>
						        @endif
						        <div class="kt-portlet__head-actions kt-align-center">
						            <a href="{{ route('airlines.create') }}" class="btn btn-primary btn-icon-sm btn-margin-bottom" title="Agregar Aerolínea">
					                    <i class="fas fa-plus"></i>
					                    Agregar Aerolínea
					                </a>
						        </div>
						    </div>
						    <div id="kt_table_1_wrapper" class="dataTables_wrapper dt-bootstrap4">
						        <div class="row">
						            <div class="col-sm-12 table-responsive">
						                {!! $dataTable->table(['class' => 'table table-striped- table-hover']) !!}
						            </div>
						        </div>
						    </div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<div class="modal fade" id="eliminar" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true" style="display: none;">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle">
                        Eliminar Aerolínea
                    </h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">
                            &times;
                        </span>
                    </button>
                </div>
                {!! Form::open(['route' => ['airlines.index'],'method' => 'POST','id'=>"form_eliminar"]) !!}           
                    <div class="modal-body">
                        <input name="_method" type="hidden" value="DELETE">
                        <h4 class="text-center">¿Desea eliminar la aerolínea?</h4>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">
                            Cerrar
                        </button>
                        <button type="submit" class="btn btn-primary">
                            Confirmar
                        </button>
                    </div>
                    {{ csrf_field() }}
                {!! Form::close() !!}
            </div>
        </div>
    </div>
@endsection
@section('js')
	<script src="{{ asset('panel/assets/vendors/custom/datatables/datatables.bundle.js') }}" type="text/javascript"></script>
    <script src="{{ asset('panel/assets/vendors/custom/datatables/buttons.server-side.js') }}" type="text/javascript"></script>
	{!! $dataTable->scripts() !!}
@endsection