@extends('layouts.panel.base')
@section('airport-active', 'kt-menu__item--active')
@section('title', 'Agregar Aeropuertos')
@section('content')
	<div class="kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor">
		<div class="kt-subheader   kt-grid__item" id="kt_subheader">
			<div class="kt-subheader__main">
				<h3 class="kt-subheader__title">Aeropuertos</h3>
				<span class="kt-subheader__separator kt-hidden"></span>
				<div class="kt-subheader__breadcrumbs">
					<a href="{{ route('panel.dashboard') }}" class="kt-subheader__breadcrumbs-home"><i class="flaticon2-shelter"></i></a>
					<span class="kt-subheader__breadcrumbs-separator"></span>
					<a href="{{ route('airports.create') }}" class="kt-subheader__breadcrumbs-link">
						Agregar
					</a>
				</div>
			</div>
		</div>
		<div class="kt-content  kt-grid__item kt-grid__item--fluid" id="kt_content">
			<div class="row">
				<div class="col-lg-12">
					<div class="kt-portlet">
						<div class="kt-portlet__head">
							<div class="kt-portlet__head-label">
								<h3 class="kt-portlet__head-title">
									Agregar Aeropuerto
								</h3>
							</div>
						</div>
						{!! Form::open(['route' => ['airports.store'], 'method' => 'POST', 'class'=>"kt-form", 'id' => 'airport_form']) !!}
							{{ csrf_field() }}
							@if(count($errors) > 0)
	                            <div class="alert alert-danger" role="alert" style="margin: 10px;">
	                                <ul style="margin-top: 0; margin-bottom: 0rem;">
	                                   @foreach($errors->all() as $error)
	                                       <li>{!! $error !!}</li>
	                                   @endforeach
	                                </ul>                        
	                            </div>
		                    @endif
		                    @if (Session::has('error'))
	                            <div class="alert alert-danger" role="alert" style="margin: 10px;">
	                                <div class="alert-text">{{ Session::get('error') }}</div>
	                            </div>
		                    @endif
							<div class="kt-portlet__body">
								<div class="row">
									<div class="col-lg-6">
										<div class="form-group">
											<label>Nombre <span class="input-required">*</span></label>
											{{ Form::text('name', null, array('class'=>'form-control', 'id'=>'name')) }}
										</div>
									</div>
									<div class="col-lg-6">
										<div class="form-group">
											<label>Código IATA <span class="input-required">*</span></label>
											{{ Form::text('iso_iata', null, array('class'=>'form-control', 'id'=>'iso_iata')) }}
										</div>
									</div>
								</div>
								<div class="row">
									<div class="col-lg-4">
										<div class="form-group">
											<label>País <span class="input-required">*</span></label>
											{{ Form::select('country', $countries, '', array('class'=>'form-control kt-select2','placeholder'=>'Seleccione País','id'=>'country')) }}
											<label style="display: none" id="country-error" class="error" for="country"></label>
										</div>
									</div>
									<div class="col-lg-4">
										<div class="form-group">
											<label>Estado <span class="input-required">*</span></label>
											{{ Form::select('state', [], '', array('class'=>'form-control kt-select2 state', 'placeholder'=>'Seleccione estado', 'id'=>'state')) }}
                    						<label style="display: none" id="state-error" class="error" for="state"></label>
										</div>
									</div>
									<div class="col-lg-4">
										<div class="form-group">
											<label>Ciudad <span class="input-required">*</span></label>
											{{ Form::select('city', [], '', array('class'=>'form-control kt-select2 city', 'placeholder'=>'Seleccione ciudad', 'id'=>'city')) }}
                    						<label style="display: none" id="city-error" class="error" for="city"></label>
										</div>
									</div>
								</div>
							</div>
							<div class="kt-portlet__foot">
								<div class="kt-form__actions">
									<button type="submit" class="btn btn-primary">Enviar</button>
									<button type="reset" class="btn btn-secondary">Cancelar</button>
								</div>
							</div>
						{!! Form::close(); !!}
					</div>
				</div>
			</div>
		</div>
	</div>
@endsection
@section('js')
	<script src="{{ asset('panel/assets/vendors/general/jquery-validation/dist/jquery.validate.js') }}" type="text/javascript"></script>
	<script>
		$('.kt-select2').select2();
		$('#airport_form').attr('autocomplete', 'off');
		$("input:text:visible:first").focus();
		var token = "{{ csrf_token() }}";

		$('#country').change(function(){
			var url_state = "{{ route('panel.ajax.state') }}";
			$('#state').empty().append('<option selected="selected" value="">Seleccione estado</option>');
			$('#city').empty().append('<option selected="selected" value="">Seleccione ciudad</option>');
			var	country = $('#country').val();
			$.ajax({
                url: url_state,
                type: 'POST',
                data: { _token: token, country: country },
                success: function (result) {
                    $.each(result.state, function () {
                        $('#state').append($('<option>', { 
                            value: this.id,
                            text : this.name 
                        }));
                    });
                }
            });
		});

		$('#state').change(function(){
			var url_city = "{{ route('panel.ajax.city') }}";
			$('#city').empty().append('<option selected="selected" value="">Seleccione ciudad</option>');
			var	state = $('#state').val();
			$.ajax({
                url: url_city,
                type: 'POST',
                data: { _token: token, state: state },
                success: function (result) {
                    $.each(result.city, function () {
                        $('#city').append($('<option>', { 
                            value: this.id,
                            text : this.name 
                        }));
                    });
                }
            });
		});

		$().ready(function() {
            $("#airport_form").validate({
                rules: {
                    name: { required: true },
                    iso_iata: { required: true },
                    country: { required: true },
                    state: { required: true },
                    city: { required: true },
                },
                messages: {
                    name: "El nombre es requerido.",
                    iso_iata: "El iata del aeropuerto es requerido.",
                    country: "El país es requerido.",
                    state: "El estado es requerido.",
                    city: "La ciudad es requerida.",
                }
            });
        });
	</script>
@endsection