@extends('layouts.panel.base')
@section('airport-active', 'kt-menu__item--active')
@section('title', 'Detalles del Aeropuerto')
@section('content')
	<div class="kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor">
		<div class="kt-subheader   kt-grid__item" id="kt_subheader">
			<div class="kt-subheader__main">
				<h3 class="kt-subheader__title">Aeropuertos</h3>
				<span class="kt-subheader__separator kt-hidden"></span>
				<div class="kt-subheader__breadcrumbs">
					<a href="{{ route('panel.dashboard') }}" class="kt-subheader__breadcrumbs-home"><i class="flaticon2-shelter"></i></a>
					<span class="kt-subheader__breadcrumbs-separator"></span>
					<a href="{{ route('airports.show', encrypt($airport->id)) }}" class="kt-subheader__breadcrumbs-link">
						Detalles
					</a>
				</div>
			</div>
		</div>
		<div class="kt-content  kt-grid__item kt-grid__item--fluid" id="kt_content">
			<div class="row">
				<div class="col-lg-12">
					<div class="kt-portlet">
						<div class="kt-portlet__head">
							<div class="kt-portlet__head-label">
								<h3 class="kt-portlet__head-title">
									Detalles del Aeropuerto
								</h3>
							</div>
						</div>
						<div class="kt-portlet__body">
							@if(Session::has('success'))
					            <div class="alert alert-success" role="alert">
					                <div class="alert-text">{{ Session::get('success') }}</div>
					            </div>
					        @endif
					        <div class="kt-section">
	                            <a href="{{ route('airports.index') }}" class="btn btn-secondary btn-sm btn-margin-bottom" title="Listado">
	                                <span>
	                                    <i class="fas fa-list"></i>
	                                    <span>
	                                        Listado
	                                    </span>
	                                </span>
	                            </a>
	                            <a href="{{ route('airports.create') }}" class="btn btn-primary btn-sm btn-margin-bottom" title="Nuevo">
	                                <span>
	                                    <i class="fas fa-plus"></i>
	                                    <span>
	                                        Nuevo
	                                    </span>
	                                </span>
	                            </a>
	                            <a href="{{ route('airports.edit', encrypt($airport->id)) }}" class="btn btn-warning btn-sm btn-margin-bottom" title="Modificar">
	                                <span>
	                                    <i class="fas fa-edit"></i>
	                                    <span>
	                                        Modificar
	                                    </span>
	                                </span>
	                            </a>
	                            <button data-toggle="modal" data-target="#kt_modal" class="btn btn-danger btn-sm btn-margin-bottom" title="Eliminar">
	                                <span>
	                                    <i class="fas fa-trash"></i>
	                                    <span>
	                                        Eliminar
	                                    </span>
	                                </span>
	                            </button>
					        </div>
					        <div class="kt-separator kt-separator--space-sm  kt-separator--border-dashed"></div>
							<div class="kt-section">
								<h3 class="kt-section__title">Información General</h3>
								<div class="form-group row">
									<div class="col-lg-6">
										<p><b>Nombre:</b> {{ ucwords($airport->name) }}</p>
										<p><b>Código IATA:</b> {{ ucwords($airport->iso_iata) }}</p>
										<p><b>País:</b> {{ ucwords($airport->country->name) }}</p>
									</div>
									<div class="col-lg-6">
										<p><b>Estado:</b> {{ ucwords($airport->state->name) }}</p>
										<p><b>Ciudad:</b> {{ ucwords($airport->city->name) }}</p>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="row">
			    <div class="col-xl-12">
			        <div class="kt-portlet">
			            <div class="kt-portlet__head">
			                <div class="kt-portlet__head-label">
			                    <h3 class="kt-portlet__head-title">
			                        Historial
			                    </h3>
			                </div>
			            </div>
			            <div class="kt-portlet__body">
			                <div class="kt-section">
			                    <div class="kt-section__content table-responsive">
			                        @if(count($history)>0)
			                            <table class="table">
			                                <thead class="thead-light">
			                                    <tr>
			                                        <th>Estatus</th>
			                                        <th>Usuario</th>
			                                        <th>Fecha</th>
			                                    </tr>
			                                </thead>
			                                <tbody>
			                                    @foreach($history as $key => $value)
			                                        <tr>
			                                            <?php 
			                                            $datos=json_decode($value->data);
			                                            if (isset($datos->motivo)){
			                                                $mensaje=$datos->motivo;
			                                            }elseif (isset($datos->comentario)) {
			                                                $mensaje=$datos->comentario;
			                                            }else{
			                                                $mensaje="";
			                                            } ?>
			                                            <td>{{ $value->status }} @if(isset($datos->motivo) || isset($datos->comentario)) {!! '<br><strong>'.$mensaje.'</strong>' !!} @endif</td>
			                                            <td>
			                                                {{ ucwords($value->user->name) }} {{ ucwords($value->user->last_name) }}
			                                            </td>
			                                            <td>{{ date_format(date_create($value->created_at),"d/m/Y H:i:s") }}</td>
			                                        </tr>
			                                    @endforeach
			                                </tbody>
			                            </table>
			                        @else
			                            <div class="alert alert-outline-danger fade show" role="alert">
			                                <div class="alert-icon"><i class="flaticon-warning"></i></div>
			                                <div class="alert-text">Sin historial registrados</div>
			                            </div>
			                        @endif 
			                    </div>
			                </div>
			            </div>
			        </div>
			    </div>
			</div>
		</div>
	</div>
	<div class="modal fade" id="kt_modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true" style="display: none;">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">
                            &times;
                        </span>
                    </button>
                </div>
                {!! Form::open(['route' => ['airports.destroy', encrypt($airport->id)], 'method' => 'POST', 'id' => 'form_eliminar']) !!}           
                    <div class="modal-body">
                        <input name="_method" type="hidden" value="DELETE">
                        <h4 class="text-center">¿Desea eliminar el aeropuerto?</h4>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">
                            Cerrar
                        </button>
                        <button type="submit" class="btn btn-primary">
                            Confirmar
                        </button>
                    </div>
                    {{ csrf_field() }}
                {!! Form::close() !!}
            </div>
        </div>
    </div>
@endsection
@section('js')
@endsection