@extends('layouts.panel.base')
@section('bookings-active', 'kt-menu__item--active')
@section('title', 'Detalles de la Reserva')
@section('css')
	<style type="text/css">
		.kt-demo-icon:hover {
			background-color: #f7f8fa00;
		}
		.kt-demo-icon {
			margin-bottom: 0px;
		}
	</style>
@endsection
@section('content')
	<div class="kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor">
		<div class="kt-subheader   kt-grid__item" id="kt_subheader">
			<div class="kt-subheader__main">
				<h3 class="kt-subheader__title">Reservas</h3>
				<span class="kt-subheader__separator kt-hidden"></span>
				<div class="kt-subheader__breadcrumbs">
					<a href="{{ route('panel.dashboard') }}" class="kt-subheader__breadcrumbs-home"><i class="flaticon2-shelter"></i></a>
					<span class="kt-subheader__breadcrumbs-separator"></span>
					<a href="{{ route('panel.flights') }}" class="kt-subheader__breadcrumbs-link">
						Detalle
					</a>
				</div>
			</div>
		</div>
		<div class="kt-content  kt-grid__item kt-grid__item--fluid" id="kt_content">
			<div class="row">
				<div class="col-lg-12">
					<div class="kt-portlet">
						<div class="kt-portlet__head">
							<div class="kt-portlet__head-label">
								<h3 class="kt-portlet__head-title">
									Detalles de la Reserva
								</h3>
							</div>
							<div class="kt-portlet__head-toolbar">
								<a href="#" class="btn btn-label-success btn-sm btn-bold dropdown-toggle" data-toggle="dropdown">
									Acciones
								</a>
								<div class="dropdown-menu dropdown-menu-fit dropdown-menu-right">
									<ul class="kt-nav">
										<li class="kt-nav__item">
											<a href="{{ route('panel.flights.seating', encrypt($booking->id)) }}" class="kt-nav__link">
												<i class="kt-nav__link-icon flaticon-squares"></i>
												<span class="kt-nav__link-text">Seleccionar Asientos</span>
											</a>
										</li>
										<li class="kt-nav__item">
											<a href="{{ route('panel.flights.issue.tickets', encrypt($booking->id)) }}" class="kt-nav__link">
												<i class="kt-nav__link-icon flaticon-file"></i>
												<span class="kt-nav__link-text">Emitir Boletos</span>
											</a>
										</li>
										<li class="kt-nav__item">
											<a href="{{ route('panel.flights.booking.cancel', encrypt($booking->id)) }}" class="kt-nav__link">
												<i class="kt-nav__link-icon flaticon-close"></i>
												<span class="kt-nav__link-text">Cancerlar Reserva</span>
											</a>
										</li>
									</ul>
								</div>
							</div>
						</div>
						<div class="kt-portlet__body">
							@if(Session::has('success'))
					            <div class="alert alert-success" role="alert">
					                <div class="alert-text">{{ Session::get('success') }}</div>
					            </div>
					        @endif
					        @if(Session::has('error'))
					            <div class="alert alert-error" role="alert">
					                <div class="alert-text">{{ Session::get('error') }}</div>
					            </div>
					        @endif
							<div class="kt-section">
								<div class="kt-widget kt-widget--user-profile-4">
									<div class="kt-widget__head">
										<div class="kt-widget__media">
											<div class="kt-demo-icon">
												<div class="kt-demo-icon__preview">
													<center>
														<i class="flaticon-file"></i>
													</center>
												</div>
											</div>
										</div>
										<div class="kt-widget__content">
											<div class="kt-widget__section">
												<sapn class="kt-widget__username" style="color: #5d78ff !important;">
													Número de reserva: {{ $booking->number }}
												</sapn>
												<div class="kt-widget__button">
													@if($booking->status == 'Activo')
														<span class="btn btn-label-success btn-sm">Estatus: {{ $booking->status }}</span>
													@else
														<span class="btn btn-label-danger btn-sm">Estatus: {{ $booking->status }}</span>
													@endif
												</div>
												<h3 class="kt-section__title text-center" style="padding-top: 15px;">
													Costo de voletos: {{ number_format($total_amount, 2) }} USD
												</h3>
											</div>
										</div>
									</div>
								</div>
							</div>
							<div class="kt-separator kt-separator--space-sm  kt-separator--border-dashed"></div>
							<div class="kt-section text-center">
								<div class="form-group row">
									@if($flight_return != null)
										@php
				    						$date_departure = new Date($flight_departure->departure_date_time);
				    					@endphp
										<div class="col-lg-6">
											<h3 class="kt-section__title">Vuelo de ida</h3>
											<p><b>Vuelo:</b> {{ $flight_departure->flight_number }}</p>
											<p><b>Fecha:</b> {{ $date_departure->format('d-m-Y') }}</p>
											<p><b>Hora:</b> {{ $date_departure->format('H:i:s') }}</p>
											<p><b>Aeropuerto de Origen:</b> {{ $flight_departure->departure_airport }}</p>
											<p><b>Aeropuerto de Destino:</b> {{ $flight_departure->arrival_airport }}</p>
											<p><b>Aerolínea:</b> {{ $flight_departure->company_short_name }}</p>
											@php
												$rph_departure = $flight_departure->bookingFlightClass->rph;
												if($rph_departure == 1){
													$class_departure = 'Económica';
												}elseif($rph_departure == 2){
													$class_departure = 'Ejecutiva';
												}else{
													$class_departure = 'Primera Clase';
												}
											@endphp
											<p><b>Tarifa:</b> {{ $class_departure }}</p>
										</div>
										@php
				    						$date_return = new Date($flight_return->departure_date_time);
				    					@endphp
										<div class="col-lg-6">
											<h3 class="kt-section__title">Vuelo de vuelta</h3>
											<p><b>Vuelo:</b> {{ $flight_return->flight_number }}</p>
											<p><b>Fecha:</b> {{ $date_return->format('d-m-Y') }}</p>
											<p><b>Hora:</b> {{ $date_return->format('H:i:s') }}</p>
											<p><b>Aeropuerto de Origen:</b> {{ $flight_return->departure_airport }}</p>
											<p><b>Aeropuerto de Destino:</b> {{ $flight_return->arrival_airport }}</p>
											<p><b>Aerolínea:</b> {{ $flight_return->company_short_name }}</p>
											@php
												$rph_return = $flight_return->bookingFlightClass->rph;
												if($rph_return == 1){
													$class_return = 'Económica';
												}elseif($rph_return == 2){
													$class_return = 'Ejecutiva';
												}else{
													$class_return = 'Primera Clase';
												}
											@endphp
											<p><b>Tarifa:</b> {{ $class_return }}</p>
										</div>
									@else
										@php
				    						$date_departure = new Date($flight_departure->departure_date_time);
				    					@endphp
										<div class="col-lg-12">
											<h3 class="kt-section__title">Detalles del vuelo</h3>
											<p><b>Vuelo:</b> {{ $flight_departure->flight_number }}</p>
											<p><b>Fecha:</b> {{ $flight_departure->departure_date_time }}</p>
											<p><b>Hora:</b> {{ $flight_departure->departure_date_time }}</p>
											<p><b>Aeropuerto de Origen:</b> {{ $flight_departure->departure_airport }}</p>
											<p><b>Aeropuerto de Destino:</b> {{ $flight_departure->arrival_airport }}</p>
											<p><b>Aerolínea:</b> {{ $flight_departure->company_short_name }}</p>
											@php
												$rph_departure = $flight_departure->bookingFlightClass->rph;
												if($rph_departure == 1){
													$class_departure = 'Económica';
												}elseif($rph_departure == 2){
													$class_departure = 'Ejecutiva';
												}else{
													$class_departure = 'Primera Clase';
												}
											@endphp
											<p><b>Tarifa:</b> {{ $class_departure }}</p>
										</div>
									@endif
									<div class="col-lg-12" style="margin-top: 25px;">
										<h3 class="kt-section__title">Pasajeros asociados a la reserva</h3>
										<ul class="nav nav-tabs" role="tablist">
											<li class="nav-item">
												<a class="nav-link active" data-toggle="tab" href="#" data-target="#kt_tabs_1_1">
													Ida | {{ $flight_departure->departure_airport }} - {{ $flight_departure->arrival_airport }}
												</a>
											</li>
											@if($flight_return != null)
												<li class="nav-item">
													<a class="nav-link" data-toggle="tab" href="#kt_tabs_1_3">
														Retorno | {{ $flight_return->departure_airport }} - {{ $flight_return->arrival_airport }}
													</a>
												</li>
											@endif
										</ul>
										<div class="tab-content">
											<div class="tab-pane active" id="kt_tabs_1_1" role="tabpanel">
												<div class="accordion  accordion-toggle-arrow" id="accordionExample4">
													@foreach($passengers as $key => $value)
														@if($key == 0)
															<div class="card">
																<div class="card-header" id="headingOne4">
																	<div class="card-title" data-toggle="collapse" data-target="#collapseOne{{ $key }}" aria-expanded="true" aria-controls="collapseOne{{ $key }}">
																		<i class="fa fa-user"></i> {{ ucfirst($value->name) }} {{ ucfirst($value->last_name) }}
																	</div>
																</div>
																<div id="collapseOne{{ $key }}" class="collapse show" aria-labelledby="headingOne" data-parent="#accordionExample4">
																	<div class="card-body">
																		<div class="form-group row">
																			<div class="col-lg-3">
																				<b>Tipo:</b> {{ $value->type }}
																			</div>
																			<div class="col-lg-3">
																				<b>Nombre:</b> {{ $value->name }}
																			</div>
																			<div class="col-lg-3">
																				<b>Apeellido:</b> {{ $value->last_name }}
																			</div>
																			<div class="col-lg-3">
																				<b>Teléfono:</b> {{ $value->phone }}
																			</div>
																		</div>
																		<div class="form-group row">
																			<div class="col-lg-3">
																				<b>Tipo de Documento:</b> {{ $value->document_type }}
																			</div>
																			<div class="col-lg-3">
																				<b>Documento:</b> {{ $value->document }}
																			</div>
																			<div class="col-lg-3">
																				<b>Codigo Postal:</b> {{ $value->zip_code }}
																			</div>
																			<div class="col-lg-3">
																				<b>País:</b> {{ $value->country->name }}
																			</div>
																		</div>
																		@if($value->bookingPassengerSeat[0])
																			<div class="form-group row">
																				<div class="col-lg-3"></div>
																				<div class="col-lg-3">
																					<b>Asiento:</b> {{ $value->bookingPassengerSeat[0]->seat_mumber }}
																				</div>
																				<div class="col-lg-3">
																					<b>Estatus:</b> {{ $value->bookingPassengerSeat[0]->status }}
																				</div>
																				<div class="col-lg-3"></div>
																			</div>
																		@endif
																	</div>
																</div>
															</div>
														@else
															<div class="card">
																<div class="card-header" id="headingOne4">
																	<div class="card-title collapsed" data-toggle="collapse" data-target="#collapseOne{{ $key }}" aria-expanded="true" aria-controls="collapseOne{{ $key }}">
																		<i class="fa fa-user"></i> {{ ucfirst($value->name) }} {{ ucfirst($value->last_name) }}
																	</div>
																</div>
																<div id="collapseOne{{ $key }}" class="collapse" aria-labelledby="headingOne" data-parent="#accordionExample4">
																	<div class="card-body">
																		<div class="form-group row">
																			<div class="col-lg-3">
																				<b>Tipo:</b> {{ $value->type }}
																			</div>
																			<div class="col-lg-3">
																				<b>Nombre:</b> {{ $value->name }}
																			</div>
																			<div class="col-lg-3">
																				<b>Apeellido:</b> {{ $value->last_name }}
																			</div>
																			<div class="col-lg-3">
																				<b>Teléfono:</b> {{ $value->phone }}
																			</div>
																		</div>
																		<div class="form-group row">
																			<div class="col-lg-3">
																				<b>Tipo de Documento:</b> {{ $value->document_type }}
																			</div>
																			<div class="col-lg-3">
																				<b>Documento:</b> {{ $value->document }}
																			</div>
																			<div class="col-lg-3">
																				<b>Codigo Postal:</b> {{ $value->zip_code }}
																			</div>
																			<div class="col-lg-3">
																				<b>País:</b> {{ $value->country->name }}
																			</div>
																		</div>
																		@if($value->bookingPassengerSeat[0])
																			<div class="form-group row">
																				<div class="col-lg-3"></div>
																				<div class="col-lg-3">
																					<b>Asiento:</b> {{ $value->bookingPassengerSeat[0]->seat_mumber }}
																				</div>
																				<div class="col-lg-3">
																					<b>Estatus:</b> {{ $value->bookingPassengerSeat[0]->status }}
																				</div>
																				<div class="col-lg-3"></div>
																			</div>
																		@endif
																	</div>
																</div>
															</div>
														@endif
													@endforeach
												</div>
											</div>
											@if($flight_return != null)
												<div class="tab-pane" id="kt_tabs_1_3" role="tabpanel">
													<div class="accordion  accordion-toggle-arrow" id="accordionExample2">
														@foreach($passengers as $key => $value)
															@if($key == 0)
																<div class="card">
																	<div class="card-header" id="headingOne4">
																		<div class="card-title" data-toggle="collapse" data-target="#collapseTwo{{ $key }}" aria-expanded="true" aria-controls="collapseTwo{{ $key }}">
																			<i class="fa fa-user"></i> {{ ucfirst($value->name) }} {{ ucfirst($value->last_name) }}
																		</div>
																	</div>
																	<div id="collapseTwo{{ $key }}" class="collapse show" aria-labelledby="headingOne" data-parent="#accordionExample2">
																		<div class="card-body">
																			<div class="form-group row">
																				<div class="col-lg-3">
																					<b>Tipo:</b> {{ $value->type }}
																				</div>
																				<div class="col-lg-3">
																					<b>Nombre:</b> {{ $value->name }}
																				</div>
																				<div class="col-lg-3">
																					<b>Apeellido:</b> {{ $value->last_name }}
																				</div>
																				<div class="col-lg-3">
																					<b>Teléfono:</b> {{ $value->phone }}
																				</div>
																			</div>
																			<div class="form-group row">
																				<div class="col-lg-3">
																					<b>Tipo de Documento:</b> {{ $value->document_type }}
																				</div>
																				<div class="col-lg-3">
																					<b>Documento:</b> {{ $value->document }}
																				</div>
																				<div class="col-lg-3">
																					<b>Codigo Postal:</b> {{ $value->zip_code }}
																				</div>
																				<div class="col-lg-3">
																					<b>País:</b> {{ $value->country->name }}
																				</div>
																			</div>
																			@if($value->bookingPassengerSeat[1])
																				<div class="form-group row">
																					<div class="col-lg-3"></div>
																					<div class="col-lg-3">
																						<b>Asiento:</b> {{ $value->bookingPassengerSeat[1]->seat_mumber }}
																					</div>
																					<div class="col-lg-3">
																						<b>Estatus:</b> {{ $value->bookingPassengerSeat[1]->status }}
																					</div>
																					<div class="col-lg-3"></div>
																				</div>
																			@endif
																		</div>
																	</div>
																</div>
															@else
																<div class="card">
																	<div class="card-header" id="headingOne4">
																		<div class="card-title collapsed" data-toggle="collapse" data-target="#collapseTwo{{ $key }}" aria-expanded="true" aria-controls="collapseTwo{{ $key }}">
																			<i class="fa fa-user"></i> {{ ucfirst($value->name) }} {{ ucfirst($value->last_name) }}
																		</div>
																	</div>
																	<div id="collapseTwo{{ $key }}" class="collapse" aria-labelledby="headingOne" data-parent="#accordionExample2">
																		<div class="card-body">
																			<div class="form-group row">
																				<div class="col-lg-3">
																					<b>Tipo:</b> {{ $value->type }}
																				</div>
																				<div class="col-lg-3">
																					<b>Nombre:</b> {{ $value->name }}
																				</div>
																				<div class="col-lg-3">
																					<b>Apeellido:</b> {{ $value->last_name }}
																				</div>
																				<div class="col-lg-3">
																					<b>Teléfono:</b> {{ $value->phone }}
																				</div>
																			</div>
																			<div class="form-group row">
																				<div class="col-lg-3">
																					<b>Tipo de Documento:</b> {{ $value->document_type }}
																				</div>
																				<div class="col-lg-3">
																					<b>Documento:</b> {{ $value->document }}
																				</div>
																				<div class="col-lg-3">
																					<b>Codigo Postal:</b> {{ $value->zip_code }}
																				</div>
																				<div class="col-lg-3">
																					<b>País:</b> {{ $value->country->name }}
																				</div>
																			</div>
																			@if($value->bookingPassengerSeat[1])
																				<div class="form-group row">
																					<div class="col-lg-3"></div>
																					<div class="col-lg-3">
																						<b>Asiento:</b> {{ $value->bookingPassengerSeat[1]->seat_mumber }}
																					</div>
																					<div class="col-lg-3">
																						<b>Estatus:</b> {{ $value->bookingPassengerSeat[1]->status }}
																					</div>
																					<div class="col-lg-3"></div>
																				</div>
																			@endif
																		</div>
																	</div>
																</div>
															@endif
														@endforeach
													</div>
												</div>
											@endif
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
@endsection
@section('js')
@endsection