@extends('layouts.panel.base')
@section('flights-search-active', 'kt-menu__item--active')
@section('title', 'Información de los pasajeros')
@section('css')
	<style>
    	.dropdown-menu {
      		max-height: 200px; /* Establece la altura máxima del menú desplegable */
      		overflow-y: auto; /* Habilita el scroll vertical si el contenido excede la altura */
    	}
  	</style>
@endsection
@section('content')
	<div class="kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor">
		<div class="kt-subheader   kt-grid__item" id="kt_subheader">
			<div class="kt-subheader__main">
				<h3 class="kt-subheader__title">Vuelos</h3>
				<span class="kt-subheader__separator kt-hidden"></span>
				<div class="kt-subheader__breadcrumbs">
					<a href="{{ route('panel.dashboard') }}" class="kt-subheader__breadcrumbs-home"><i class="flaticon2-shelter"></i></a>
					<span class="kt-subheader__breadcrumbs-separator"></span>
					<a href="{{ route('panel.flights') }}" class="kt-subheader__breadcrumbs-link">
						Pasajeros
					</a>
				</div>
			</div>
		</div>
		<div class="kt-content  kt-grid__item kt-grid__item--fluid" id="kt_content">
			<div class="row">
				<div class="col-lg-12">
					{!! Form::open(['route' => ['panel.flights.customer.save'], 'method' => 'POST', 'class'=>"kt-form", 'id' => 'customer_form']) !!}
						{{ csrf_field() }}
						<div class="kt-portlet kt-portlet--last kt-portlet--head-lg kt-portlet--responsive-mobile" id="kt_page_portlet">
							<div class="kt-portlet__head kt-portlet__head--lg">
								<div class="kt-portlet__head-label">
									<h3 class="kt-portlet__head-title">Información de los pasajeros</h3>
								</div>
								<div class="kt-portlet__head-toolbar">
									<a href="{{ route('panel.flights.result') }}" class="btn btn-clean kt-margin-r-10">
										<span class="kt-hidden-mobile">Regresar</span>
									</a>
									<div class="btn-group">
										<button type="submit" class="btn btn-brand">
											<span class="kt-hidden-mobile">Enviar</span>
										</button>
									</div>
								</div>
							</div>
							<div class="kt-portlet__body">
								<form class="kt-form" id="kt_form">
									<div class="row">
										<div class="col-xl-2"></div>
										<div class="col-xl-8">
											@if($form_adt != null)
												@for($x = 0; $x < $form_adt->passenger_quantity; $x++)
													<div class="kt-section kt-section--first">
														<div class="kt-portlet__body">
															{{ Form::hidden('adt['.$x.'][type]', 'ADT', array('class'=>'form-control', 'id'=>'adt-type'.$x)) }}
															<h3 class="kt-section__title kt-section__title-lg" style="font-size: 16px !important;">
																(Adulto {{ $x + 1 }})
															</h3>
														    <div class="row">
																<div class="col-lg-3">
																	<div class="form-group">
																		<label>Nombre <span class="input-required">*</span></label>
																		{{ Form::text('adt['.$x.'][name]', null, array('class'=>'form-control', 'id'=>'adt-name'.$x)) }}
																	</div>
																</div>
																<div class="col-lg-3">
																	<div class="form-group">
																		<label>Apellido <span class="input-required">*</span></label>
																		{{ Form::text('adt['.$x.'][last_name]', null, array('class'=>'form-control', 'id'=>'adt-last_name'.$x)) }}
																	</div>
																</div>
																<div class="col-lg-3">
																	<div class="form-group">
																		<label>Tipo de documento <span class="input-required">*</span></label>
																		{{ Form::select('adt['.$x.'][document_type]', ['NI' => 'Dni', 'PP' => 'Pasaporte'], '', array('class'=>'form-control kt-select2', 'placeholder'=>'Seleccione Documento', 'id'=>'adt-document_type'.$x)) }}
																		<label style="display: none" id="document_type-error" class="error" for="document_type"></label>
																	</div>
																</div>
																<div class="col-lg-3">
																	<div class="form-group">
																		<label>Documento <span class="input-required">*</span></label>
																		{{ Form::text('adt['.$x.'][document]', null, array('class'=>'form-control', 'id'=>'adt-document'.$x)) }}
																	</div>
																</div>
															</div>
															<div class="row">
																<div class="col-lg-4">
																	<div class="form-group">
																		<label>País <span class="input-required">*</span></label>
																		{{ Form::select('adt['.$x.'][country]', $countries, '', array('class'=>'form-control kt-select2', 'placeholder'=>'Seleccione País', 'id'=>'adt-country'.$x)) }}
																		<label style="display: none" id="country-error" class="error" for="country"></label>
																	</div>
																</div>
																<div class="col-lg-4">
																	<div class="form-group">
																		<label>Código Postal <span class="input-required">*</span></label>
																		{{ Form::text('adt['.$x.'][zip_code]', null, array('class'=>'form-control', 'id'=>'adt-zip_code'.$x)) }}
																	</div>
																</div>
																<div class="col-lg-4">
																	<div class="form-group">
																		<label>Teléfono <span class="input-required">*</span></label>
																		<div class="input-group">
																			<div class="input-group-prepend">
																				<button type="button" class="btn btn-secondary dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
																					<span class="change-value-adt{{$x}}">58</span>
																				</button>
																				<div class="dropdown-menu">
																					@foreach($phone_codes as $key => $value)
																						<label class="dropdown-item code-phone-adt{{$x}}" attr-value-adt{{$x}}="{{ $value->phone_code }}">{{ $value->phone_code }}</label>
																					@endforeach
																				</div>
																			</div>
																			{{ Form::text('adt['.$x.'][phone]', null, array('class'=>'form-control', 'id'=>'adt-phone'.$x)) }}
																			<label style="display: none" id="identifier-error" class="error" for="identifier"></label>
																			{{ Form::hidden('adt['.$x.'][code_phone]', '58', array('class'=>'value-code-adt'.$x, 'id'=>'value-code-adt'.$x)) }}
																		</div>
																	</div>
																</div>
															</div>
														</div>
													</div>
													<div class="kt-separator kt-separator--border-dashed kt-separator--space-lg"></div>
												@endfor
											@endif
											@if($form_cnn != null)
												@for($x = 0; $x < $form_cnn->passenger_quantity; $x++)
													<div class="kt-section kt-section--first">
														<div class="kt-portlet__body">
															{{ Form::hidden('cnn['.$x.'][type]', 'CNN', array('class'=>'form-control', 'id'=>'cnn-type'.$x)) }}
															<h3 class="kt-section__title kt-section__title-lg" style="font-size: 16px !important;">
																(Niño {{ $x + 1 }})
															</h3>
														    <div class="row">
																<div class="col-lg-3">
																	<div class="form-group">
																		<label>Nombre <span class="input-required">*</span></label>
																		{{ Form::text('cnn['.$x.'][name]', null, array('class'=>'form-control', 'id'=>'cnn-name'.$x)) }}
																	</div>
																</div>
																<div class="col-lg-3">
																	<div class="form-group">
																		<label>Apellido <span class="input-required">*</span></label>
																		{{ Form::text('cnn['.$x.'][last_name]', null, array('class'=>'form-control', 'id'=>'cnn-last_name'.$x)) }}
																	</div>
																</div>
																<div class="col-lg-3">
																	<div class="form-group">
																		<label>Tipo de documento <span class="input-required">*</span></label>
																		{{ Form::select('cnn['.$x.'][document_type]', ['NI' => 'Dni', 'PP' => 'Pasaporte'], '', array('class'=>'form-control kt-select2', 'placeholder'=>'Seleccione Documento', 'id'=>'cnn-document_type'.$x)) }}
																		<label style="display: none" id="document_type-error" class="error" for="document_type"></label>
																	</div>
																</div>
																<div class="col-lg-3">
																	<div class="form-group">
																		<label>Documento <span class="input-required">*</span></label>
																		{{ Form::text('cnn['.$x.'][document]', null, array('class'=>'form-control', 'id'=>'cnn-document'.$x)) }}
																	</div>
																</div>
															</div>
															<div class="row">
																<div class="col-lg-4">
																	<div class="form-group">
																		<label>País <span class="input-required">*</span></label>
																		{{ Form::select('cnn['.$x.'][country]', $countries, '', array('class'=>'form-control kt-select2', 'placeholder'=>'Seleccione País', 'id'=>'cnn-country'.$x)) }}
																		<label style="display: none" id="country-error" class="error" for="country"></label>
																	</div>
																</div>
																<div class="col-lg-4">
																	<div class="form-group">
																		<label>Código Postal <span class="input-required">*</span></label>
																		{{ Form::text('cnn['.$x.'][zip_code]', null, array('class'=>'form-control', 'id'=>'cnn-zip_code'.$x)) }}
																	</div>
																</div>
																<div class="col-lg-4">
																	<div class="form-group">
																		<label>Teléfono <span class="input-required">*</span></label>
																		<div class="input-group">
																			<div class="input-group-prepend">
																				<button type="button" class="btn btn-secondary dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
																					<span class="change-value-cnn{{$x}}">58</span>
																				</button>
																				<div class="dropdown-menu">
																					@foreach($phone_codes as $key => $value)
																						<label class="dropdown-item code-phone-cnn{{$x}}" attr-value-cnn{{$x}}="{{ $value->phone_code }}">{{ $value->phone_code }}</label>
																					@endforeach
																				</div>
																			</div>
																			{{ Form::text('cnn['.$x.'][phone]', null, array('class'=>'form-control', 'id'=>'cnn-phone'.$x)) }}
																			<label style="display: none" id="identifier-error" class="error" for="identifier"></label>
																			{{ Form::hidden('cnn['.$x.'][code_phone]', '58', array('class'=>'value-code-cnn'.$x, 'id'=>'value-code-cnn'.$x)) }}
																		</div>
																	</div>
																</div>
															</div>
														</div>
													</div>
													<div class="kt-separator kt-separator--border-dashed kt-separator--space-lg"></div>
												@endfor
											@endif
											@if($form_inf != null)
												@for($x = 0; $x < $form_inf->passenger_quantity; $x++)
													<div class="kt-section kt-section--first">
														<div class="kt-portlet__body">
															{{ Form::hidden('inf['.$x.'][type]', 'INF', array('class'=>'form-control', 'id'=>'inf-type'.$x)) }}
															<h3 class="kt-section__title kt-section__title-lg" style="font-size: 16px !important;">
																(Infante {{ $x + 1 }})
															</h3>
														    <div class="row">
																<div class="col-lg-3">
																	<div class="form-group">
																		<label>Nombre <span class="input-required">*</span></label>
																		{{ Form::text('inf['.$x.'][name]', null, array('class'=>'form-control', 'id'=>'inf-name'.$x)) }}
																	</div>
																</div>
																<div class="col-lg-3">
																	<div class="form-group">
																		<label>Apellido <span class="input-required">*</span></label>
																		{{ Form::text('inf['.$x.'][last_name]', null, array('class'=>'form-control', 'id'=>'inf-last_name'.$x)) }}
																	</div>
																</div>
																<div class="col-lg-3">
																	<div class="form-group">
																		<label>Tipo de documento <span class="input-required">*</span></label>
																		{{ Form::select('inf['.$x.'][document_type]', ['NI' => 'Dni', 'PP' => 'Pasaporte'], '', array('class'=>'form-control kt-select2', 'placeholder'=>'Seleccione Documento', 'id'=>'inf-document_type'.$x)) }}
																		<label style="display: none" id="document_type-error" class="error" for="document_type"></label>
																	</div>
																</div>
																<div class="col-lg-3">
																	<div class="form-group">
																		<label>Documento <span class="input-required">*</span></label>
																		{{ Form::text('inf['.$x.'][document]', null, array('class'=>'form-control', 'id'=>'inf-document'.$x)) }}
																	</div>
																</div>
															</div>
															<div class="row">
																<div class="col-lg-3">
																	<div class="form-group">
																		<label>País <span class="input-required">*</span></label>
																		{{ Form::select('inf['.$x.'][country]', $countries, '', array('class'=>'form-control kt-select2', 'placeholder'=>'Seleccione País', 'id'=>'inf-country'.$x)) }}
																		<label style="display: none" id="country-error" class="error" for="country"></label>
																	</div>
																</div>
																<div class="col-lg-3">
																	<div class="form-group">
																		<label>Código Postal <span class="input-required">*</span></label>
																		{{ Form::text('inf['.$x.'][zip_code]', null, array('class'=>'form-control', 'id'=>'inf-zip_code'.$x)) }}
																	</div>
																</div>
																{{-- <div class="col-lg-3">
																	<div class="form-group">
																		<label>Teléfono <span class="input-required">*</span></label>
																		{{ Form::text('inf['.$x.'][phone]', null, array('class'=>'form-control', 'id'=>'inf-phone'.$x)) }}
																	</div>
																</div> --}}
																<div class="col-lg-3">
																	<div class="form-group">
																		<label>Teléfono <span class="input-required">*</span></label>
																		<div class="input-group">
																			<div class="input-group-prepend">
																				<button type="button" class="btn btn-secondary dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
																					<span class="change-value-inf{{$x}}">58</span>
																				</button>
																				<div class="dropdown-menu">
																					@foreach($phone_codes as $key => $value)
																						<label class="dropdown-item code-phone-inf{{$x}}" attr-value-inf{{$x}}="{{ $value->phone_code }}">{{ $value->phone_code }}</label>
																					@endforeach
																				</div>
																			</div>
																			{{ Form::text('inf['.$x.'][phone]', null, array('class'=>'form-control', 'id'=>'inf-phone'.$x)) }}
																			<label style="display: none" id="identifier-error" class="error" for="identifier"></label>
																			{{ Form::hidden('inf['.$x.'][code_phone]', '58', array('class'=>'value-code-inf'.$x, 'id'=>'value-code-inf'.$x)) }}
																		</div>
																	</div>
																</div>
																<div class="col-lg-3">
																	<div class="form-group">
																		<label>Fecha de Nacimiento <span class="input-required">*</span></label>
																		{{ Form::date('inf['.$x.'][birthdate]', null, array('class'=>'form-control', 'id'=>'inf-birthdate'.$x)) }}
																	</div>
																</div>
															</div>
														</div>
													</div>
													<div class="kt-separator kt-separator--border-dashed kt-separator--space-lg"></div>
												@endfor
											@endif
										</div>
										<div class="col-xl-2"></div>
									</div>
								</form>
							</div>
						</div>
					{!! Form::close(); !!}
				</div>
			</div>
		</div>
	</div>
@endsection
@section('js')
	<script src="{{ asset('panel/assets/vendors/general/jquery-validation/dist/jquery.validate.js') }}" type="text/javascript"></script>
	{!! $jsFragmentAdt !!}
	{!! $jsFragmentCnn !!}
	{!! $jsFragmentInf !!}

	<script>
		$('.kt-select2').select2();
		$('#customer_form').attr('autocomplete', 'off');
		/*var na = "{{ $form_adt->passenger_quantity }}";
		for (var i = 0; i < na; i++) {
			//alert(i);
		  	$('.code-phone' + i).click(function(){
		  		
		        var type_document = $(this).attr('attr-value-'+i);
		        alert(type_document);
		        $('.change-value' + i).text(type_document);
		        $('#value-code' + i).val(type_document);
		    });
		}*/
	</script>
@endsection