@extends('layouts.panel.base')
@section('flights-search-active', 'kt-menu__item--active')
@section('title', 'Buscar Vuelos')
@section('css')
	<link href="{{ asset('panel/assets/vendors/general/sweetalert2/dist/sweetalert2.css') }}" rel="stylesheet" type="text/css" />
	<style type="text/css">
		.nav-tabs .nav-item .nav-link .active {
			color: #ffffff !important;
			background-color: #5d78ff !important;
		}
		.color-font {
			color: #4a4a4a !important;
			font-weight: 500;
		}
		.swal2-title {
			font-size: 14px !important;
		}
	</style>
@endsection
@section('content')
	<div class="kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor">
		<div class="kt-subheader   kt-grid__item" id="kt_subheader">
			<div class="kt-subheader__main">
				<h3 class="kt-subheader__title">Vuelos</h3>
				<span class="kt-subheader__separator kt-hidden"></span>
				<div class="kt-subheader__breadcrumbs">
					<a href="{{ route('panel.dashboard') }}" class="kt-subheader__breadcrumbs-home"><i class="flaticon2-shelter"></i></a>
					<span class="kt-subheader__breadcrumbs-separator"></span>
					<a href="{{ route('panel.flights') }}" class="kt-subheader__breadcrumbs-link">
						Consultar
					</a>
				</div>
			</div>
		</div>
		<div class="kt-content  kt-grid__item kt-grid__item--fluid" id="kt_content">
			<div class="row">
				<div class="col-lg-12">
					<div class="kt-portlet">
						<div class="kt-portlet__head">
							<div class="kt-portlet__head-label">
								<h3 class="kt-portlet__head-title">
									Vuelos Encontrados
								</h3>
							</div>
						</div>
						<div class="kt-portlet__body">
							@if(count($departure_flight) > 0)
							    <table class="table">
							    	<thead>
							    		<tr>
							    			<td colspan="4" style="font-size: 20px">
							    				Vuelos de Ida
							    			</td>
							    		</tr>
							    		<tr>
							    			<th>Aerolinea</th>
							    			<th>Salida</th>
							    			<th>Duración</th>
							    			<th>LLegada</th>
							    		</tr>
							    	</thead>
							    	<tbody>
							    		@foreach($departure_flight as $key => $value)
							    			<tr>
							    				<td class="color-font">{{ getAirline($value->company_short_name) }}</td>
							    				<td class="color-font">
							    					@php
							    						$date_departure = new Date($value->departure_date_time);
							    					@endphp
							    					Fecha: {{ $date_departure->format('d-m-Y') }}<br>
							    					Hora: {{ $date_departure->format('H:i:s') }}<br>
							    					Aeropuerto: {{ $value->departure_airport }}
							    				</td>
							    				<td class="color-font">
							    					Paradas: {{ $value->stop_quantity }}<br>
							    					Duración: {{ $value->journey_duration }}
							    				</td>
							    				<td class="color-font">
							    					@php
							    						$date_arrival = new Date($value->arrival_date_time);
							    					@endphp
							    					Fecha: {{ $date_arrival->format('d-m-Y') }}<br>
							    					Hora: {{ $date_arrival->format('H:i:s') }}<br>
							    					Aeropuerto: {{ $value->arrival_airport }}
							    				</td>
							    			</tr>
							    			<tr>
							    				<td colspan="4" style="border-top: 0px solid !important;">
							    					<div class="col text-center">
							    						<button type="button" class="btn btn-success btn-wide card-title collapsed" data-toggle="collapse" data-target="#collapseDeparture{{ $key }}" aria-expanded="false" aria-controls="collapseDeparture{{ $key }}"	>Ver Detalles</button>
							    						<div class="accordion" id="accordionDeparture{{ $key }}">
							    							<div class="card">
							    								<div id="collapseDeparture{{ $key }}" class="collapse" aria-labelledby="headingDeparture{{ $key }}" data-parent="#accordionDeparture{{ $key }}">
							    									<div class="card-body">
							    										<div class="kt-portlet__body">
							    											<ul class="nav nav-tabs" role="tablist">
							    												@foreach($value->flightClass as $key2 => $value2)
								    												<li class="nav-item">
								    													@if($key2 == 0)
								    														<a class="nav-link active" data-toggle="tab" href="#" data-target="#kt_departure_1_{{ $key2 }}">
								    															@if($value2->rph == 1)
								    																Económica
								    															@elseif($value2->rph == 2)
								    																Ejecutiva
								    															@elseif($value2->rph == 3)
								    																Primera Clase
								    															@endif
								    														</a>
								    													@else
								    														<a class="nav-link" data-toggle="tab" href="#" data-target="#kt_departure_1_{{ $key2 }}">
								    															@if($value2->rph == 1)
								    																Económica
								    															@elseif($value2->rph == 2)
								    																Ejecutiva
								    															@elseif($value2->rph == 3)
								    																Primera Clase
								    															@endif
								    														</a>
								    													@endif
								    												</li>
							    												@endforeach
							    											</ul>
							    											<div class="tab-content">
							    												@foreach($value->flightClass as $key2 => $value2)
							    													@if($key2 == 0)
									    												<div class="tab-pane active" id="kt_departure_1_{{ $key2 }}" role="tabpanel">
									    													<div class="row">
									    														<div class="col-lg-3">
									    															<h5 class="kt-font-primary">
						    																			Aerolínea:
						    																		</h5>
									    															<h6 class="kt-widget24__title">
									    																{{ getAirline($value->company_short_name) }}
									    															</h6>
									    														</div>
									    														<div class="col-lg-3">
									    															<h5 class="kt-font-primary">
						    																			Vuelo:
						    																		</h5>
									    															<h6 class="kt-widget24__title">
									    																{{ $value->flight_number }}
									    															</h6>
									    														</div>
									    														<div class="col-lg-3">
									    															<h5 class="kt-font-primary">
						    																			Total:
						    																		</h5>
									    															<h6 class="kt-widget24__title">
									    																$ {{ number_format($value2->amount, 2) }}
									    															</h6>
									    														</div>
									    														
									    														<div class="col-lg-3">
									    															<h5 class="kt-font-primary">
						    																			Pasaje: 
						    																		</h5>
									    															<h6 class="kt-widget24__title">
									    																@foreach($value2->passengerClass as $key3 => $value3)
									    																	{{ $value3->passenger_quantity }} {{ $value3->passenger_type }}<br>
									    																@endforeach
									    															</h6>
									    														</div>
									    													</div>
									    													<div class="row">
									    														<div class="col-lg-12">
									    															<div class="kt-widget24">
									    																<div class="kt-widget24__details">
									    																	<div class="kt-widget24__info">
									    																		<h4 class="kt-widget24__title">
									    																			Salida
									    																		</h4>
									    																		<h5 class="kt-font-primary">
									    																			{{ $value->departure_airport }}
									    																		</h5>
									    																	</div>
									    																	<div class="kt-widget24__info">
									    																		<i style="font-size: 20px;" class="fa fa-plane" aria-hidden="true"></i>
									    																	</div>
									    																	<div class="kt-widget24__info">
									    																		<h4 class="kt-widget24__title">
									    																			LLegada
									    																		</h4>
									    																		<h5 class="kt-font-primary">
									    																			{{ $value->arrival_airport }}
									    																		</h5>
									    																	</div>
									    																</div>
									    																<div class="progress progress--sm">
									    																	<div class="progress-bar kt-bg-success" role="progressbar" style="width: 100%;" aria-valuenow="50" aria-valuemin="0" aria-valuemax="100"></div>
									    																</div>
									    																<div class="kt-widget24__action">
									    																	<span style="color: #4a4a4a !important;" class="kt-widget24__change">
									    																		Fecha: {{ $date_departure->format('d-m-Y') }}<br>
									    																		Hora: {{ $date_departure->format('H:i:s') }}<br>
									    																	</span>
									    																	<span style="color: #4a4a4a !important;" class="kt-widget24__number">
									    																		Duración: {{ $value->journey_duration }}<br>
									    																		Paradas: {{ $value->stop_quantity }}<br>
									    																	</span>
									    																	<span style="color: #4a4a4a !important;" class="kt-widget24__number">
									    																		Fecha: {{ $date_arrival->format('d-m-Y') }}<br>
									    																		Hora: {{ $date_arrival->format('H:i:s') }}<br>
									    																	</span>
									    																</div>
									    															</div>
									    															<center>
										    															<label class="kt-option" style="width:40%">
										    																<span class="kt-option__control">
										    																	<span class="kt-radio kt-radio--bold kt-radio--brand">
										    																		<input type="radio" name="departure_flight_class" class="flight_class" attr-flight-class="{{ $value2->id }}">
										    																		<span></span>
										    																	</span>
										    																</span>
										    																<span class="kt-option__label">
										    																	<span class="kt-option__head">
										    																		<span class="kt-option__title">
										    																			Seleccionar Tarifa
										    																		</span>
										    																		<span class="kt-option__focus">
										    																			$&nbsp;{{ number_format($value2->amount, 2) }}
										    																		</span>
										    																	</span>
										    																</span>
										    															</label>
										    														</center>
									    														</div>
									    													</div>
									    												</div>
									    											@else
									    												<div class="tab-pane" id="kt_departure_1_{{ $key2 }}" role="tabpanel">
									    													<div class="row">
									    														<div class="col-lg-3">
									    															<h5 class="kt-font-primary">
						    																			Aerolínea:
						    																		</h5>
									    															<h6 class="kt-widget24__title">
									    																{{ getAirline($value->company_short_name) }}
									    															</h6>
									    														</div>
									    														<div class="col-lg-3">
									    															<h5 class="kt-font-primary">
						    																			Vuelo:
						    																		</h5>
									    															<h6 class="kt-widget24__title">
									    																{{ $value->flight_number }}
									    															</h6>
									    														</div>
									    														<div class="col-lg-3">
									    															<h5 class="kt-font-primary">
						    																			Total:
						    																		</h5>
									    															<h6 class="kt-widget24__title">
									    																$ {{ number_format($value2->amount, 2) }}
									    															</h6>
									    														</div>
									    														
									    														<div class="col-lg-3">
									    															<h5 class="kt-font-primary">
						    																			Pasaje:
						    																		</h5>
									    															<h6 class="kt-widget24__title">
									    																@foreach($value2->passengerClass as $key3 => $value3)
									    																	{{ $value3->passenger_quantity }} {{ $value3->passenger_type }}<br>
									    																@endforeach
									    															</h6>
									    														</div>
									    													</div>
									    													<div class="row">
									    														<div class="col-lg-12">
									    															<div class="kt-widget24">
									    																<div class="kt-widget24__details">
									    																	<div class="kt-widget24__info">
									    																		<h4 class="kt-widget24__title">
									    																			Salida
									    																		</h4>
									    																		<h5 class="kt-font-primary">
									    																			{{ $value->departure_airport }}
									    																		</h5>
									    																	</div>
									    																	<div class="kt-widget24__info">
									    																		<i style="font-size: 20px;" class="fa fa-plane" aria-hidden="true"></i>
									    																	</div>
									    																	<div class="kt-widget24__info">
									    																		<h4 class="kt-widget24__title">
									    																			LLegada
									    																		</h4>
									    																		<h5 class="kt-font-primary">
									    																			{{ $value->arrival_airport }}
									    																		</h5>
									    																	</div>
									    																</div>
									    																<div class="progress progress--sm">
									    																	<div class="progress-bar kt-bg-success" role="progressbar" style="width: 100%;" aria-valuenow="50" aria-valuemin="0" aria-valuemax="100"></div>
									    																</div>
									    																<div class="kt-widget24__action">
									    																	<span style="color: #4a4a4a !important;" class="kt-widget24__change">
									    																		Fecha: {{ $date_departure->format('d-m-Y') }}<br>
									    																		Hora: {{ $date_departure->format('H:i:s') }}<br>
									    																	</span>
									    																	<span style="color: #4a4a4a !important;" class="kt-widget24__number">
									    																		Duración: {{ $value->journey_duration }}<br>
									    																		Paradas: {{ $value->stop_quantity }}<br>
									    																	</span>
									    																	<span style="color: #4a4a4a !important;" class="kt-widget24__number">
									    																		Fecha: {{ $date_arrival->format('d-m-Y') }}<br>
									    																		Hora: {{ $date_arrival->format('H:i:s') }}<br>
									    																	</span>
									    																</div>
									    															</div>
									    															<center>
										    															<label class="kt-option" style="width:40%">
										    																<span class="kt-option__control">
										    																	<span class="kt-radio kt-radio--bold kt-radio--brand">
										    																		<input type="radio" name="departure_flight_class" class="flight_class" attr-flight-class="{{ $value2->id }}">
										    																		<span></span>
										    																	</span>
										    																</span>
										    																<span class="kt-option__label">
										    																	<span class="kt-option__head">
										    																		<span class="kt-option__title">
										    																			Seleccionar Tarifa
										    																		</span>
										    																		<span class="kt-option__focus">
										    																			$&nbsp;{{ number_format($value2->amount, 2) }}
										    																		</span>
										    																	</span>
										    																</span>
										    															</label>
										    														</center>
									    														</div>
									    													</div>
									    												</div>
									    											@endif
								    											@endforeach
							    											</div>
							    										</div>
							    									</div>
							    								</div>
							    							</div>
							    						</div>
							    					</div>
							    				</td>
							    			</tr>
							    		@endforeach
							    	</tbody>
							    </table>
							@endif
							@if(count($return_flight) > 0)
							    <table class="table">
							    	<thead>
							    		<tr>
							    			<td colspan="4" style="font-size: 20px">
							    				Vuelos de Vuelta
							    			</td>
							    		</tr>
							    		<tr>
							    			<th>Aerolinea</th>
							    			<th>Salida</th>
							    			<th>Duración</th>
							    			<th>LLegada</th>
							    		</tr>
							    	</thead>
							    	<tbody>
							    		@foreach($return_flight as $key => $value)
							    			<tr>
							    				<td class="color-font">{{ getAirline($value->company_short_name) }}</td>
							    				<td class="color-font">
							    					@php
							    						$date_departure = new Date($value->departure_date_time);
							    					@endphp
							    					Fecha: {{ $date_departure->format('d-m-Y') }}<br>
							    					Hora: {{ $date_departure->format('H:i:s') }}<br>
							    					Aeropuerto: {{ $value->departure_airport }}
							    				</td>
							    				<td class="color-font">
							    					Paradas: {{ $value->stop_quantity }}<br>
							    					Duración: {{ $value->journey_duration }}
							    				</td>
							    				<td class="color-font">
							    					@php
							    						$date_arrival = new Date($value->arrival_date_time);
							    					@endphp
							    					Fecha: {{ $date_arrival->format('d-m-Y') }}<br>
							    					Hora: {{ $date_arrival->format('H:i:s') }}<br>
							    					Aeropuerto: {{ $value->arrival_airport }}
							    				</td>
							    			</tr>
							    			<tr>
							    				<td colspan="4" style="border-top: 0px solid !important;">
							    					<div class="col text-center">
							    						<button type="button" class="btn btn-success btn-wide card-title collapsed" data-toggle="collapse" data-target="#collapseReturn{{ $key }}" aria-expanded="false" aria-controls="collapseReturn{{ $key }}"	>Ver Detalles</button>
							    						<div class="accordion" id="accordionReturn{{ $key }}">
							    							<div class="card">
							    								<div id="collapseReturn{{ $key }}" class="collapse" aria-labelledby="headingReturn{{ $key }}" data-parent="#accordionReturn{{ $key }}">
							    									<div class="card-body">
							    										<div class="kt-portlet__body">
							    											<ul class="nav nav-tabs" role="tablist">
							    												@foreach($value->flightClass as $key2 => $value2)
							        												<li class="nav-item">
							        													@if($key2 == 0)
							        														<a class="nav-link active" data-toggle="tab" href="#" data-target="#kt_return_1_{{ $key2 }}">
							        															@if($value2->rph == 1)
							        																Económica
							        															@elseif($value2->rph == 2)
							        																Ejecutiva
							        															@elseif($value2->rph == 3)
							        																Primera Clase
							        															@endif
							        														</a>
							        													@else
							        														<a class="nav-link" data-toggle="tab" href="#" data-target="#kt_return_1_{{ $key2 }}">
							        															@if($value2->rph == 1)
							        																Económica
							        															@elseif($value2->rph == 2)
							        																Ejecutiva
							        															@elseif($value2->rph == 3)
							        																Primera Clase
							        															@endif
							        														</a>
							        													@endif
							        												</li>
							    												@endforeach
							    											</ul>
							    											<div class="tab-content">
							    												@foreach($value->flightClass as $key2 => $value2)
							    													@if($key2 == 0)
							    	    												<div class="tab-pane active" id="kt_return_1_{{ $key2 }}" role="tabpanel">
							    	    													<div class="row">
							    	    														<div class="col-lg-3">
							    	    															<h5 class="kt-font-primary">
							    																		Aerolínea:
							    																	</h5>
							    	    															<h6 class="kt-widget24__title">
							    	    																{{ getAirline($value->company_short_name) }}
							    	    															</h6>
							    	    														</div>
							    	    														<div class="col-lg-3">
							    	    															<h5 class="kt-font-primary">
							    																		Vuelo:
							    																	</h5>
							    	    															<h6 class="kt-widget24__title">
							    	    																{{ $value->flight_number }}
							    	    															</h6>
							    	    														</div>
							    	    														<div class="col-lg-3">
							    	    															<h5 class="kt-font-primary">
							    																		Total:
							    																	</h5>
							    	    															<h6 class="kt-widget24__title">
							    	    																$ {{ number_format($value2->amount, 2) }}
							    	    															</h6>
							    	    														</div>
							    	    														
							    	    														<div class="col-lg-3">
							    	    															<h5 class="kt-font-primary">
							    																		Pasaje:
							    																	</h5>
							    	    															<h6 class="kt-widget24__title">
							    	    																@foreach($value2->passengerClass as $key3 => $value3)
									    																	{{ $value3->passenger_quantity }} {{ $value3->passenger_type }}<br>
									    																@endforeach
							    	    															</h6>
							    	    														</div>
							    	    													</div>
							    	    													<div class="row">
							    	    														<div class="col-lg-12">
							    	    															<div class="kt-widget24">
							    	    																<div class="kt-widget24__details">
							    	    																	<div class="kt-widget24__info">
							    	    																		<h4 class="kt-widget24__title">
							    	    																			Salida
							    	    																		</h4>
							    	    																		<h5 class="kt-font-primary">
							    	    																			{{ $value->departure_airport }}
							    	    																		</h5>
							    	    																	</div>
							    	    																	<div class="kt-widget24__info">
							    	    																		<i style="font-size: 20px;" class="fa fa-plane" aria-hidden="true"></i>
							    	    																	</div>
							    	    																	<div class="kt-widget24__info">
							    	    																		<h4 class="kt-widget24__title">
							    	    																			LLegada
							    	    																		</h4>
							    	    																		<h5 class="kt-font-primary">
							    	    																			{{ $value->arrival_airport }}
							    	    																		</h5>
							    	    																	</div>
							    	    																</div>
							    	    																<div class="progress progress--sm">
							    	    																	<div class="progress-bar kt-bg-success" role="progressbar" style="width: 100%;" aria-valuenow="50" aria-valuemin="0" aria-valuemax="100"></div>
							    	    																</div>
							    	    																<div class="kt-widget24__action">
							    	    																	<span style="color: #4a4a4a !important;" class="kt-widget24__change">
							    	    																		Fecha: {{ $date_departure->format('d-m-Y') }}<br>
							    	    																		Hora: {{ $date_departure->format('H:i:s') }}<br>
							    	    																	</span>
							    	    																	<span style="color: #4a4a4a !important;" class="kt-widget24__number">
							    	    																		Duración: {{ $value->journey_duration }}<br>
							    	    																		Paradas: {{ $value->stop_quantity }}<br>
							    	    																	</span>
							    	    																	<span style="color: #4a4a4a !important;" class="kt-widget24__number">
							    	    																		Fecha: {{ $date_arrival->format('d-m-Y') }}<br>
							    	    																		Hora: {{ $date_arrival->format('H:i:s') }}<br>
							    	    																	</span>
							    	    																</div>
							    	    															</div>
							    	    															<center>
										    															<label class="kt-option" style="width:40%">
										    																<span class="kt-option__control">
										    																	<span class="kt-radio kt-radio--bold kt-radio--brand">
										    																		<input type="radio" name="return_flight_class" class="flight_class" attr-flight-class="{{ $value2->id }}">
										    																		<span></span>
										    																	</span>
										    																</span>
										    																<span class="kt-option__label">
										    																	<span class="kt-option__head">
										    																		<span class="kt-option__title">
										    																			Seleccionar Tarifa
										    																		</span>
										    																		<span class="kt-option__focus">
										    																			$&nbsp;{{ number_format($value2->amount, 2) }}
										    																		</span>
										    																	</span>
										    																</span>
										    															</label>
										    														</center>
							    	    														</div>
							    	    													</div>
							    	    												</div>
							    	    											@else
							    	    												<div class="tab-pane" id="kt_return_1_{{ $key2 }}" role="tabpanel">
							    	    													<div class="row">
							    	    														<div class="col-lg-3">
							    	    															<h5 class="kt-font-primary">
							    																		Aerolínea:
							    																	</h5>
							    	    															<h6 class="kt-widget24__title">
							    	    																{{ getAirline($value->company_short_name) }}
							    	    															</h6>
							    	    														</div>
							    	    														<div class="col-lg-3">
							    	    															<h5 class="kt-font-primary">
							    																		Vuelo:
							    																	</h5>
							    	    															<h6 class="kt-widget24__title">
							    	    																{{ $value->flight_number }}
							    	    															</h6>
							    	    														</div>
							    	    														<div class="col-lg-3">
							    	    															<h5 class="kt-font-primary">
							    																		Total:
							    																	</h5>
							    	    															<h6 class="kt-widget24__title">
							    	    																$ {{ number_format($value2->amount, 2) }}
							    	    															</h6>
							    	    														</div>
							    	    														
							    	    														<div class="col-lg-3">
							    	    															<h5 class="kt-font-primary">
							    																		Pasaje:
							    																	</h5>
							    	    															<h6 class="kt-widget24__title">
							    	    																@foreach($value2->passengerClass as $key3 => $value3)
									    																	{{ $value3->passenger_quantity }} {{ $value3->passenger_type }}<br>
									    																@endforeach
							    	    															</h6>
							    	    														</div>
							    	    													</div>
							    	    													<div class="row">
							    	    														<div class="col-lg-12">
							    	    															<div class="kt-widget24">
							    	    																<div class="kt-widget24__details">
							    	    																	<div class="kt-widget24__info">
							    	    																		<h4 class="kt-widget24__title">
							    	    																			Salida
							    	    																		</h4>
							    	    																		<h5 class="kt-font-primary">
							    	    																			{{ $value->departure_airport }}
							    	    																		</h5>
							    	    																	</div>
							    	    																	<div class="kt-widget24__info">
							    	    																		<i style="font-size: 20px;" class="fa fa-plane" aria-hidden="true"></i>
							    	    																	</div>
							    	    																	<div class="kt-widget24__info">
							    	    																		<h4 class="kt-widget24__title">
							    	    																			LLegada
							    	    																		</h4>
							    	    																		<h5 class="kt-font-primary">
							    	    																			{{ $value->arrival_airport }}
							    	    																		</h5>
							    	    																	</div>
							    	    																</div>
							    	    																<div class="progress progress--sm">
							    	    																	<div class="progress-bar kt-bg-success" role="progressbar" style="width: 100%;" aria-valuenow="50" aria-valuemin="0" aria-valuemax="100"></div>
							    	    																</div>
							    	    																<div class="kt-widget24__action">
							    	    																	<span style="color: #4a4a4a !important;" class="kt-widget24__change">
							    	    																		Fecha: {{ $date_departure->format('d-m-Y') }}<br>
							    	    																		Hora: {{ $date_departure->format('H:i:s') }}<br>
							    	    																	</span>
							    	    																	<span style="color: #4a4a4a !important;" class="kt-widget24__number">
							    	    																		Duración: {{ $value->journey_duration }}<br>
							    	    																		Paradas: {{ $value->stop_quantity }}<br>
							    	    																	</span>
							    	    																	<span style="color: #4a4a4a !important;" class="kt-widget24__number">
							    	    																		Fecha: {{ $date_arrival->format('d-m-Y') }}<br>
							    	    																		Hora: {{ $date_arrival->format('H:i:s') }}<br>
							    	    																	</span>
							    	    																</div>
							    	    															</div>
							    	    															<center>
										    															<label class="kt-option" style="width:40%">
										    																<span class="kt-option__control">
										    																	<span class="kt-radio kt-radio--bold kt-radio--brand">
										    																		<input type="radio" name="return_flight_class" class="flight_class" attr-flight-class="{{ $value2->id }}">
										    																		<span></span>
										    																	</span>
										    																</span>
										    																<span class="kt-option__label">
										    																	<span class="kt-option__head">
										    																		<span class="kt-option__title">
										    																			Seleccionar Tarifa
										    																		</span>
										    																		<span class="kt-option__focus">
										    																			$&nbsp;{{ number_format($value2->amount, 2) }}
										    																		</span>
										    																	</span>
										    																</span>
										    															</label>
										    														</center>
							    	    														</div>
							    	    													</div>
							    	    												</div>
							    	    											@endif
							        											@endforeach
							    											</div>
							    										</div>
							    									</div>
							    								</div>
							    							</div>
							    						</div>
							    					</div>
							    				</td>
							    			</tr>
							    		@endforeach
							    	</tbody>
							    </table>
							@endif
							<div class="kt-portlet__foot" id="continue" style="display: none">
								<div class="kt-form__actions">
									<div class="float-right">
										<a href="{{ route('panel.flights.customer') }}" class="btn btn-primary">Continuar</a>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
@endsection
@section('js')
	<script src="{{ asset('panel/assets/js/demo1/scripts.bundle.js') }}" type="text/javascript"></script>
	<script src="{{ asset('panel/assets/vendors/general/sweetalert2/dist/sweetalert2.min.js') }}" type="text/javascript"></script>
	<script src="{{ asset('panel/assets/vendors/custom/js/vendors/sweetalert2.init.js') }}" type="text/javascript"></script>
	<script src="{{ asset('panel/assets/js/demo1/pages/components/extended/sweetalert2.js') }}" type="text/javascript"></script>
	<script>
		var token = "{{ csrf_token() }}";

		$('.flight_class').click(function(){
			var url = "{{ route('panel.ajax.select.fee.departure') }}";
			var flight_class = $(this).attr('attr-departure-class');
			var flight_class = $(this).attr('attr-flight-class');

			if (flight_class != ''){
				$.ajax({
		            url: url,
		            type: 'POST',
		            data: { _token: token, flight_class: flight_class },
		            success: function (result) {
		            	$flag = result.flag;
		            	if ($flag == true) {
		            		swal.fire({
		            		    position: 'top-right',
		            		    type: 'success',
		            		    title: 'Vuelo seleccionado',
		            		    showConfirmButton: false,
		            		    timer: 2000
		            		});

		            		$('#continue').show();
		            	}
		            }
				});
			}
		});
	</script>
@endsection