@extends('layouts.panel.base')
@section('flights-search-active', 'kt-menu__item--active')
@section('title', 'Buscar Vuelos')
@section('content')
	<div class="kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor">
		<div class="kt-subheader   kt-grid__item" id="kt_subheader">
			<div class="kt-subheader__main">
				<h3 class="kt-subheader__title">Vuelos</h3>
				<span class="kt-subheader__separator kt-hidden"></span>
				<div class="kt-subheader__breadcrumbs">
					<a href="{{ route('panel.dashboard') }}" class="kt-subheader__breadcrumbs-home"><i class="flaticon2-shelter"></i></a>
					<span class="kt-subheader__breadcrumbs-separator"></span>
					<a href="{{ route('panel.flights') }}" class="kt-subheader__breadcrumbs-link">
						Consultar
					</a>
				</div>
			</div>
		</div>
		<div class="kt-content  kt-grid__item kt-grid__item--fluid" id="kt_content">
			<div class="row">
				<div class="col-lg-12">
					<div class="kt-portlet">
						<div class="kt-portlet__head">
							<div class="kt-portlet__head-label">
								<h3 class="kt-portlet__head-title">
									Buscar Vuelos
								</h3>
							</div>
						</div>
						{!! Form::open(['route' => ['panel.flights.query'], 'method' => 'POST', 'class'=>"kt-form", 'id' => 'search_form']) !!}
							{{ csrf_field() }}
							<div class="kt-portlet__body">
								<ul class="nav nav-tabs" role="tablist">
									<li class="nav-item">
										<a class="nav-link active" id="round-trip" data-toggle="tab" href="#kt_tabs_1_3">
											Ida y Vuelta
										</a>
									</li>
									<li class="nav-item">
										<a class="nav-link" id="one-way" data-toggle="tab" href="#">
											Solo Ida
										</a>
									</li>
								</ul>
							    <div class="row">
									<div class="col-lg-4">
										<div class="form-group">
											<label>Aerolinea</label>
											{{ Form::select('airline', $airlines, '', array('class'=>'form-control kt-select2', 'placeholder'=>'Seleccione Aerolinea', 'id'=>'airline')) }}
											<label style="display: none" id="airline-error" class="error" for="airline"></label>
										</div>
									</div>
									<div class="col-lg-4">
										<div class="form-group">
											<label>Fecha de Salida <span class="input-required">*</span></label>
											{{ Form::date('departure_date', null, array('class'=>'form-control', 'id'=>'departure_date')) }}
											<div style="display: none" id="departure_date-error" class="error" for="departure_date"></div>
										</div>
									</div>
									<div class="col-lg-4">
										<div class="form-group">
											<label>Fecha de Retorno <span class="input-required">*</span></label>
											{{ Form::date('return_date', null, array('class'=>'form-control', 'id'=>'return_date')) }}
											<div style="display: none" id="return_date-error" class="error" for="return_date"></div>
										</div>
									</div>
								</div>
								<div class="row">
									<div class="col-lg-4">
										<div class="form-group">
											<label>Aeropuesto de Origen <span class="input-required">*</span></label>
											{{ Form::select('origin_airport', $airports, '', array('class'=>'form-control kt-select2', 'placeholder'=>'Seleccione Origen', 'id'=>'origin_airport')) }}
											<label style="display: none" id="origin_airport-error" class="error" for="origin_airport"></label>
										</div>
									</div>
									<div class="col-lg-4">
										<div class="form-group">
											<label>Aeropuerto de Destino <span class="input-required">*</span></label>
											{{ Form::select('destination_airport', array(), '', array('class'=>'form-control kt-select2', 'placeholder'=>'Seleccione Destino', 'id'=>'destination_airport')) }}
											<label style="display: none" id="destination_airport-error" class="error" for="destination_airport"></label>
										</div>
									</div>
									<div class="col-lg-4">
										<label>Pasajeros <span class="input-required">*</span></label>
										<div class="dropdown">
											<button class="btn btn-secondary dropdown-toggle" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" style="width: 100%; text-align: left;">
												<span id="quantity_passengers">1</span> Pasajero
											</button>
											<div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
												<div class="kt-portlet__body">
													<div class="row">
														<div class="col-lg-12">
															<div class="form-group">
																{{ Form::text('adt', 1, array('class'=>'form-control', 'id'=>'adt', 'placeholder'=>'Adultos')) }}
															</div>
														</div>
														<div class="col-lg-12">
															<div class="form-group">
																{{ Form::text('cnn', null, array('class'=>'form-control', 'id'=>'cnn', 'placeholder'=>'Niños')) }}
															</div>
														</div>
														<div class="col-lg-12">
															<div class="form-group">
																{{ Form::text('inf', null, array('class'=>'form-control', 'id'=>'inf', 'placeholder'=>'Infantes')) }}
															</div>
														</div>
													</div>
												</div>
											</div>
										</div>
										<div style="" id="passenger-error" class="error" for="passenger">
											<div class="text-passenger"></div>
										</div>
									</div>
								</div>
							</div>
							<div class="kt-portlet__foot">
								<div class="kt-form__actions">
									<button type="submit" id="search_button" class="btn btn-primary justify-content-md-end">Consultar</button>
								</div>
							</div>
						{!! Form::close(); !!}
					</div>
				</div>
			</div>
		</div>
	</div>
@endsection
@section('js')
	<script src="{{ asset('panel/assets/vendors/general/jquery-validation/dist/jquery.validate.js') }}" type="text/javascript"></script>
	<script>
		$('.kt-select2').select2();
		$('#search_form').attr('autocomplete', 'off');
		var adt = 1;
		var cnn = 0;
		var inf = 0;
		var result = 1;
		var token = "{{ csrf_token() }}";

		$('#round-trip').click(function(){
			$('#return_date').prop('disabled', false);
		});

		$('#one-way').click(function(){
			$('#return_date').prop('disabled', true);
			$('#return_date').val('');
			var round_trip = false;
		});

		$('#return_date').change(function(){
			var departure_date = $('#departure_date').val();
			var return_date = $('#return_date').val();

			if (departure_date > return_date) {
				$('#return_date-error').show();
				$('#return_date-error').html('La fecha de retorno no puede ser menor a la fecha de salida');
				$('#search_button').prop('disabled', true);
			} else {
				$('#search_button').prop('disabled', false);
				$('#return_date-error').hide();
			}
		});

		$('#departure_date').change(function(){
			var departure_date = $('#departure_date').val();
			var today_date = new Date().toISOString().slice(0, 10);

			if (today_date > departure_date) {
				$('#departure_date-error').show();
				$('#departure_date-error').html('La fecha de salida no puede ser menor a la fecha actual');
				$('#search_button').prop('disabled', true);
			} else {
				$('#search_button').prop('disabled', false);
				$('#departure_date-error').hide();
			}
		});

		$('#origin_airport').change(function(){
			var url_airport = "{{ route('panel.ajax.destination.airport') }}";
			$('#destination_airport').empty().append('<option selected="selected" value="">Seleccione Destino</option>');
			var	origin_airport = $('#origin_airport').val();
			$.ajax({
                url: url_airport,
                type: 'POST',
                data: { _token: token, origin_airport: origin_airport },
                success: function (result) {
                    $.each(result.destinations, function () {
                        $('#destination_airport').append($('<option>', { 
                            value: this.iso_iata,
                            text : this.name 
                        }));
                    });
                }
            });
		});

		$('#adt').on('input', function(){
			adt = $(this).val();
			result = parseFloat(adt) + parseFloat(cnn) + parseFloat(inf);
    		$('#quantity_passengers').html(result)
  		});

		$('#cnn').on('input', function(){
			cnn = $(this).val();
		    result = parseFloat(adt) + parseFloat(cnn) + parseFloat(inf);
    		$('#quantity_passengers').html(result)
  		});

  		$('#inf').on('input', function(){
			inf = $(this).val();
		    result = parseFloat(adt) + parseFloat(cnn) + parseFloat(inf);
    		$('#quantity_passengers').html(result)
  		});

  		$("form").submit(function(e){
            if (result < 1) {
            	$('.text-passenger').html('Debe al menos tener un pasajero');
                e.preventDefault();
            } else if(isNaN(result)) {
            	$('.text-passenger').html('Debe al menos tener un pasajero');
                e.preventDefault();
            } else {
                $("[name='enviar']").click(function(){
                    $(this).attr("disabled","disabled");
                });
            };  
        });

		$().ready(function() {
		    $("#search_form").validate({
		   	    rules: {
		          	departure_date: { required: true },
		          	return_date: { required: true },
		            origin_airport: { required: true },
		            destination_airport: { required: true },
		        },
		        messages: {
		           	departure_date: "La fecha de salida es requerida.",
		           	return_date: "La fecha de retorno es requerida.",
		            origin_airport: "El aeropuerto de origen es requerido.",
		            destination_airport: "El aeropuerto de destino es requerido.",
		        }
			});
		});
	</script>
@endsection