@extends('layouts.panel.base')
@section('bookings-active', 'kt-menu__item--active')
@section('title', 'Seleccionar Asiento')
@section('css')
	<link href="{{ asset('panel/assets/vendors/general/sweetalert2/dist/sweetalert2.css') }}" rel="stylesheet" type="text/css" />
	<style type="text/css">
		.nav-tabs .nav-item .nav-link .active {
			color: #ffffff !important;
			background-color: #5d78ff !important;
		}
		.swal2-title {
			font-size: 14px !important;
		}
	</style>
@endsection
@section('content')
	<div class="kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor">
		<div class="kt-subheader   kt-grid__item" id="kt_subheader">
			<div class="kt-subheader__main">
				<h3 class="kt-subheader__title">Vuelos</h3>
				<span class="kt-subheader__separator kt-hidden"></span>
				<div class="kt-subheader__breadcrumbs">
					<a href="{{ route('panel.dashboard') }}" class="kt-subheader__breadcrumbs-home"><i class="flaticon2-shelter"></i></a>
					<span class="kt-subheader__breadcrumbs-separator"></span>
					<a href="{{ route('panel.flights') }}" class="kt-subheader__breadcrumbs-link">
						Seleccionar Asientos
					</a>
				</div>
			</div>
		</div>
		<div class="kt-content  kt-grid__item kt-grid__item--fluid" id="kt_content">
			<div class="row">
				<div class="col-lg-12">
					<div class="kt-portlet">
						<div class="kt-portlet__head">
							<div class="kt-portlet__head-label">
								<h3 class="kt-portlet__head-title">
									Seleccionar Asiento
								</h3>
							</div>
						</div>
						<div class="kt-portlet__body">
							<ul class="nav nav-tabs" role="tablist">
								<li class="nav-item">
									<a class="nav-link active" data-toggle="tab" href="#" data-target="#kt_tabs_1_1">
										Ida | {{ $flight_departure->departure_airport }} - {{ $flight_departure->arrival_airport }}
									</a>
								</li>
								@if($flight_return != null)
									<li class="nav-item">
										<a class="nav-link" data-toggle="tab" href="#kt_tabs_1_3">
											Retorno | {{ $flight_return->departure_airport }} - {{ $flight_return->arrival_airport }}
										</a>
									</li>
								@endif
							</ul>
							<div class="tab-content">
								<div class="tab-pane active" id="kt_tabs_1_1" role="tabpanel">
									<div class="kt-section text-center">
										<div class="form-group row">
											<div class="col-lg-12">
												<div class="accordion  accordion-toggle-arrow" id="accordionExample4">
													@foreach($passengers as $key => $value)
														@if($key == 0)
															<div class="card">
																<div class="card-header" id="headingOne4">
																	<div class="card-title" data-toggle="collapse" data-target="#collapseOne{{ $key }}" aria-expanded="true" aria-controls="collapseOne{{ $key }}">
																		<i class="fa fa-user"></i> {{ ucfirst($value->name) }} {{ ucfirst($value->last_name) }}
																	</div>
																</div>
																<div id="collapseOne{{ $key }}" class="collapse show" aria-labelledby="headingOne" data-parent="#accordionExample4">
																	<div class="card-body">
																		<div class="form-group row">
																			<div class="col-lg-3">
																				<b>Tipo:</b> {{ $value->type }}
																			</div>
																			<div class="col-lg-3">
																				<b>Nombre:</b> {{ $value->name }}
																			</div>
																			<div class="col-lg-3">
																				<b>Apeellido:</b> {{ $value->last_name }}
																			</div>
																			<div class="col-lg-3">
																				<b>Teléfono:</b> {{ $value->phone }}
																			</div>
																		</div>
																		<div class="form-group row">
																			<div class="col-lg-3">
																				<b>Tipo de Documento:</b> {{ $value->document_type }}
																			</div>
																			<div class="col-lg-3">
																				<b>Documento:</b> {{ $value->document }}
																			</div>
																			<div class="col-lg-3">
																				<b>Codigo Postal:</b> {{ $value->zip_code }}
																			</div>
																			<div class="col-lg-3">
																				<b>País:</b> {{ $value->country->name }}
																			</div>
																		</div>
																		<div class="form-group row">
																			<div class="col-lg-4"></div>
																			<div class="col-lg-4">
																				<div class="form-group">
																					{{ Form::select('seating_departure', $seatings_departure, '', array('class'=>'form-control kt-select2 seating_departure', 'placeholder'=>'Seleccione Aerolinea', 'attr-departure-id'=>$key, 'attr-passenger-departure'=>$value->id, 'id'=>'seating_departure'.$key)) }}
																					<label style="display: none" id="seating_departure-error" class="error" for="seating_departure"></label>
																				</div>
																			</div>
																			<div class="col-lg-4"></div>
																		</div>
																	</div>
																</div>
															</div>
														@else
															<div class="card">
																<div class="card-header" id="headingOne4">
																	<div class="card-title collapsed" data-toggle="collapse" data-target="#collapseOne{{ $key }}" aria-expanded="true" aria-controls="collapseOne{{ $key }}">
																		<i class="fa fa-user"></i> {{ ucfirst($value->name) }} {{ ucfirst($value->last_name) }}
																	</div>
																</div>
																<div id="collapseOne{{ $key }}" class="collapse" aria-labelledby="headingOne" data-parent="#accordionExample4">
																	<div class="card-body">
																		<div class="form-group row">
																			<div class="col-lg-3">
																				<b>Tipo:</b> {{ $value->type }}
																			</div>
																			<div class="col-lg-3">
																				<b>Nombre:</b> {{ $value->name }}
																			</div>
																			<div class="col-lg-3">
																				<b>Apeellido:</b> {{ $value->last_name }}
																			</div>
																			<div class="col-lg-3">
																				<b>Teléfono:</b> {{ $value->phone }}
																			</div>
																		</div>
																		<div class="form-group row">
																			<div class="col-lg-3">
																				<b>Tipo de Documento:</b> {{ $value->document_type }}
																			</div>
																			<div class="col-lg-3">
																				<b>Documento:</b> {{ $value->document }}
																			</div>
																			<div class="col-lg-3">
																				<b>Codigo Postal:</b> {{ $value->zip_code }}
																			</div>
																			<div class="col-lg-3">
																				<b>País:</b> {{ $value->country->name }}
																			</div>
																		</div>
																		<div class="form-group row">
																			<div class="col-lg-4"></div>
																			<div class="col-lg-4">
																				<div class="form-group">
																					{{ Form::select('seating_departure', $seatings_departure, '', array('class'=>'form-control kt-select2 seating_departure', 'placeholder'=>'Seleccione Aerolinea', 'attr-departure-id'=>$key, 'attr-passenger-departure'=>$value->id, 'id'=>'seating_departure'.$key)) }}
																					<label style="display: none" id="seating_departure-error" class="error" for="seating_departure"></label>
																				</div>
																			</div>
																			<div class="col-lg-4"></div>
																		</div>
																	</div>
																</div>
															</div>
														@endif
													@endforeach
												</div>
											</div>
										</div>
									</div>
								</div>
								@if($flight_return != null)
									<div class="tab-pane" id="kt_tabs_1_3" role="tabpanel">
										<div class="kt-section text-center">
											<div class="form-group row">
												<div class="col-lg-12">
													<div class="accordion  accordion-toggle-arrow" id="accordionExample2">
														@foreach($passengers as $key => $value)
															@if($key == 0)
																<div class="card">
																	<div class="card-header" id="headingOne4">
																		<div class="card-title" data-toggle="collapse" data-target="#collapseTwo{{ $key }}" aria-expanded="true" aria-controls="collapseTwo{{ $key }}">
																			<i class="fa fa-user"></i> {{ ucfirst($value->name) }} {{ ucfirst($value->last_name) }}
																		</div>
																	</div>
																	<div id="collapseTwo{{ $key }}" class="collapse show" aria-labelledby="headingOne" data-parent="#accordionExample2">
																		<div class="card-body">
																			<div class="form-group row">
																				<div class="col-lg-3">
																					<b>Tipo:</b> {{ $value->type }}
																				</div>
																				<div class="col-lg-3">
																					<b>Nombre:</b> {{ $value->name }}
																				</div>
																				<div class="col-lg-3">
																					<b>Apeellido:</b> {{ $value->last_name }}
																				</div>
																				<div class="col-lg-3">
																					<b>Teléfono:</b> {{ $value->phone }}
																				</div>
																			</div>
																			<div class="form-group row">
																				<div class="col-lg-3">
																					<b>Tipo de Documento:</b> {{ $value->document_type }}
																				</div>
																				<div class="col-lg-3">
																					<b>Documento:</b> {{ $value->document }}
																				</div>
																				<div class="col-lg-3">
																					<b>Codigo Postal:</b> {{ $value->zip_code }}
																				</div>
																				<div class="col-lg-3">
																					<b>País:</b> {{ $value->country->name }}
																				</div>
																			</div>
																			<div class="form-group row">
																				<div class="col-lg-4"></div>
																				<div class="col-lg-4">
																					<div class="form-group">
																						{{ Form::select('seating_return', $seatings_return, '', array('class'=>'form-control kt-select2 seating_return', 'placeholder'=>'Seleccione Asiento', 'attr-return-id'=>$key, 'attr-passenger-return'=>$value->id, 'id'=>'seating_return'.$key)) }}
																						<label style="display: none" id="seating_return-error" class="error" for="seating_return"></label>
																					</div>
																				</div>
																				<div class="col-lg-4"></div>
																			</div>
																		</div>
																	</div>
																</div>
															@else
																<div class="card">
																	<div class="card-header" id="headingOne4">
																		<div class="card-title collapsed" data-toggle="collapse" data-target="#collapseTwo{{ $key }}" aria-expanded="true" aria-controls="collapseTwo{{ $key }}">
																			<i class="fa fa-user"></i> {{ ucfirst($value->name) }} {{ ucfirst($value->last_name) }}
																		</div>
																	</div>
																	<div id="collapseTwo{{ $key }}" class="collapse" aria-labelledby="headingOne" data-parent="#accordionExample2">
																		<div class="card-body">
																			<div class="form-group row">
																				<div class="col-lg-3">
																					<b>Tipo:</b> {{ $value->type }}
																				</div>
																				<div class="col-lg-3">
																					<b>Nombre:</b> {{ $value->name }}
																				</div>
																				<div class="col-lg-3">
																					<b>Apeellido:</b> {{ $value->last_name }}
																				</div>
																				<div class="col-lg-3">
																					<b>Teléfono:</b> {{ $value->phone }}
																				</div>
																			</div>
																			<div class="form-group row">
																				<div class="col-lg-3">
																					<b>Tipo de Documento:</b> {{ $value->document_type }}
																				</div>
																				<div class="col-lg-3">
																					<b>Documento:</b> {{ $value->document }}
																				</div>
																				<div class="col-lg-3">
																					<b>Codigo Postal:</b> {{ $value->zip_code }}
																				</div>
																				<div class="col-lg-3">
																					<b>País:</b> {{ $value->country->name }}
																				</div>
																			</div>
																			<div class="form-group row">
																				<div class="col-lg-4"></div>
																				<div class="col-lg-4">
																					<div class="form-group">
																						{{ Form::select('seating_return', $seatings_return, '', array('class'=>'form-control kt-select2 seating_return', 'placeholder'=>'Seleccione Asiento', 'attr-return-id'=>$key, 'attr-passenger-return'=>$value->id, 'id'=>'seating_return'.$key)) }}
																						<label style="display: none" id="seating_return-error" class="error" for="seating_return"></label>
																					</div>
																				</div>
																				<div class="col-lg-4"></div>
																			</div>
																		</div>
																	</div>
																</div>
															@endif
														@endforeach
													</div>
												</div>
											</div>
										</div>
									</div>
								@endif
							</div>
						</div>
						<div class="kt-portlet__foot">
							<div class="kt-form__actions">
								<a href="{{ route('panel.flights.seating.save', encrypt($booking->id)) }}" class="btn btn-primary justify-content-md-end">Aceptar</a>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
@endsection
@section('js')
	<script src="{{ asset('panel/assets/vendors/general/sweetalert2/dist/sweetalert2.min.js') }}" type="text/javascript"></script>
	<script src="{{ asset('panel/assets/vendors/custom/js/vendors/sweetalert2.init.js') }}" type="text/javascript"></script>
	<script src="{{ asset('panel/assets/js/demo1/pages/components/extended/sweetalert2.js') }}" type="text/javascript"></script>
	<script type="text/javascript">
		$('.kt-select2').select2();
		var token = "{{ csrf_token() }}";

		$('.seating_departure').change(function(){
			var url = "{{ route('panel.ajax.select.seating') }}";
			var attr_departure_id = $(this).attr('attr-departure-id');
			var seating_departure = $('#seating_departure'+attr_departure_id).val();
			var passenger_departure = $(this).attr('attr-passenger-departure');
			var type = 'going';

			if (seating_departure != '' && passenger_departure != ''){
				$.ajax({
		            url: url,
		            type: 'POST',
		            data: { _token: token, seating: seating_departure, passenger: passenger_departure, type: type },
		            success: function (result) {
		            	$flag = result.flag;
		            	if ($flag == true) {
		            		swal.fire({
		            		    position: 'top-right',
		            		    type: 'success',
		            		    title: 'Asiento Seleccionado',
		            		    showConfirmButton: false,
		            		    timer: 2000
		            		});
		            	}
		            }
				});
			}
		});

		$('.seating_return').change(function(){
			var url = "{{ route('panel.ajax.select.seating') }}";
			var attr_return_id = $(this).attr('attr-return-id');
			var seating_return = $('#seating_return'+attr_return_id).val();
			var passenger_return = $(this).attr('attr-passenger-return');
			var type = 'return';

			if (seating_return != '' && passenger_return != ''){
				$.ajax({
		            url: url,
		            type: 'POST',
		            data: { _token: token, seating: seating_return, passenger: passenger_return, type: type },
		            success: function (result) {
		            	$flag = result.flag;
		            	if ($flag == true) {
		            		swal.fire({
		            		    position: 'top-right',
		            		    type: 'success',
		            		    title: 'Asiento Seleccionado',
		            		    showConfirmButton: false,
		            		    timer: 2000
		            		});
		            	}
		            }
				});
			}
		});
	</script>
@endsection