@extends('layouts.panel.base')
@section('hotel-active', 'kt-menu__item--active')
@section('title', 'Agregar Detaalles del Hotel')
@section('content')
	<link rel="stylesheet" href="https://code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
	<link href="{{ asset('panel/assets/vendors/general/bootstrap-markdown/css/bootstrap-markdown.min.css') }}" rel="stylesheet" type="text/css" />
	<style type="text/css">
		.ui-menu-item-wrapper{
			height: 30px !important;
			padding: 10px;
		}
	</style>
	<div class="kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor">
		<div class="kt-subheader   kt-grid__item" id="kt_subheader">
			<div class="kt-subheader__main">
				<h3 class="kt-subheader__title">Hotel</h3>
				<span class="kt-subheader__separator kt-hidden"></span>
				<div class="kt-subheader__breadcrumbs">
					<a href="{{ route('panel.dashboard') }}" class="kt-subheader__breadcrumbs-home"><i class="flaticon2-shelter"></i></a>
					<span class="kt-subheader__breadcrumbs-separator"></span>
					<a href="{{ route('panel.hotels.detail', encrypt($hotel->id)) }}" class="kt-subheader__breadcrumbs-link">
						Detalles
					</a>
				</div>
			</div>
		</div>
		<div class="kt-content  kt-grid__item kt-grid__item--fluid" id="kt_content">
			<div class="row">
				<div class="col-lg-12">
					<div class="kt-portlet">
						<div class="kt-portlet__head">
							<div class="kt-portlet__head-label">
								<h3 class="kt-portlet__head-title">
									Agregar Detalle
								</h3>
							</div>
						</div>
						{!! Form::open(['route' => ['panel.hotels.detail.save', encrypt($hotel->id)], 'method' => 'POST', 'class'=>"kt-form", 'id' => 'hotel_form']) !!}
							{{ csrf_field() }}
							@if(count($errors) > 0)
	                            <div class="alert alert-danger" role="alert" style="margin: 10px;">
	                                <ul style="margin-top: 0; margin-bottom: 0rem;">
	                                   @foreach($errors->all() as $error)
	                                       <li>{!! $error !!}</li>
	                                   @endforeach
	                                </ul>                        
	                            </div>
		                    @endif
		                    @if (Session::has('error'))
	                            <div class="alert alert-danger" role="alert" style="margin: 10px;">
	                                <div class="alert-text">{{ Session::get('error') }}</div>
	                            </div>
		                    @endif
							<div class="kt-portlet__body">
								<div class="row">
									<div class="col-lg-6">
										<div class="row">
											<div class="col-lg-12">
												<div class="form-group">
													<label>Situado en la playa <span class="input-required">*</span></label>
													<div class="kt-radio-inline">
														<label class="kt-radio kt-radio--brand">
															<input type="radio" name="located_beach" class="located_beach" value="Si"> Si
															<span></span>
														</label>
														<label class="kt-radio kt-radio--brand">
															<input type="radio" name="located_beach" class="located_beach" value="No"> No
															<span></span>
														</label>
													</div>
												</div>
											</div>
											<div class="col-lg-12 div_name_beach" style="display: none">
												<div class="form-group">
													<label>Nombre de la Playa</label>
													{{ Form::text('name_beach', null, array('class'=>'form-control', 'id'=>'name_beach', 'rows'=>'4')) }}
												</div>
											</div>
										</div>
										<div class="row">
											<div class="col-lg-12">
												<div class="form-group">
													<label>Todo Incluido <span class="input-required">*</span></label>
													<div class="kt-radio-inline">
														<label class="kt-radio kt-radio--brand">
															<input type="radio" name="all_inclusive" class="all_inclusive" value="Si"> Si
															<span></span>
														</label>
														<label class="kt-radio kt-radio--brand">
															<input type="radio" name="all_inclusive" class="all_inclusive" value="No"> No
															<span></span>
														</label>
													</div>
												</div>
											</div>
											<div class="col-lg-12 div_all_inclusive" style="display: none">
												<div class="form-group">
													<label>Detalle</label>
													{{ Form::textarea('all_inclusive_detail', null, array('class'=>'form-control', 'id'=>'all_inclusive_detail', 'rows'=>'4')) }}
												</div>
											</div>
										</div>
									</div>
									<div class="col-lg-6">
										<div class="row">
											<div class="col-lg-12">
												<div class="form-group">
													<label>Sustainability Travelife <span class="input-required">*</span></label>
													<div class="kt-radio-inline">
														<label class="kt-radio kt-radio--brand">
															<input type="radio" name="sustainability_travelife" class="sustainability_travelife" value="Si"> Si
															<span></span>
														</label>
														<label class="kt-radio kt-radio--brand">
															<input type="radio" name="sustainability_travelife" class="sustainability_travelife" value="No"> No
															<span></span>
														</label>
													</div>
												</div>
											</div>
											<div class="col-lg-12 div_certification_type" style="display: none">
												<div class="form-group">
													<label>Tipo de Certificación</label>
													{{ Form::select('certification_type', ['Gold'=>'Gold', 'Partner'=>'Partner'], '', array('class'=>'form-control kt-select2 certification_type', 'placeholder'=>'Seleccione', 'id'=>'certification_type')) }}
		                    						<label style="display: none" id="certification_type-error" class="error" for="certification_type"></label>
												</div>
											</div>
										</div>
										<div class="row">
											<div class="col-lg-12">
												<div class="form-group">
													<label>Infantes Exonerados <span class="input-required">*</span></label>
													<div class="kt-radio-inline">
														<label class="kt-radio kt-radio--brand">
															<input type="radio" name="exonerated_infant" class="exonerated_infant" value="Si"> Si
															<span></span>
														</label>
														<label class="kt-radio kt-radio--brand">
															<input type="radio" name="exonerated_infant" class="exonerated_infant" value="No"> No
															<span></span>
														</label>
													</div>
												</div>
											</div>
											<div class="col-lg-12 div_infants_age" style="display: none">
												<div class="form-group">
													<label>Edad</label>
													{{ Form::number('infants_age', null, array('class'=>'form-control', 'id'=>'infants_age')) }}
												</div>
											</div>
										</div>
										<div class="row">
											<div class="col-lg-12">
												<div class="form-group">
													<label>Wifi Gratuito <span class="input-required">*</span></label>
													<div class="kt-radio-inline">
														<label class="kt-radio kt-radio--brand">
															<input type="radio" name="free_wifi" value="Si"> Si
															<span></span>
														</label>
														<label class="kt-radio kt-radio--brand">
															<input type="radio" name="free_wifi" value="No"> No
															<span></span>
														</label>
													</div>
												</div>
											</div>
										</div>
									</div>
								</div>
								<div class="kt-separator kt-separator--space-sm  kt-separator--border-dashed"></div>
								<div class="row">
									<div class="col-lg-12">
										<div class="form-group">
											<label>Amenidades <span class="input-required">*</span></label>
											<div class="kt-radio-inline">
												<label class="kt-radio kt-radio--brand">
													<input type="radio" name="amenities" class="amenities" value="Si"> Si
													<span></span>
												</label>
												<label class="kt-radio kt-radio--brand">
													<input type="radio" name="amenities" class="amenities" value="No"> No
													<span></span>
												</label>
											</div>
										</div>
									</div>
								</div>
								<div class="row div_amenities" style="display: none">
									<div class="col-lg-12">
									    <div class="form-group d-flex justify-content-between align-items-center">
									        <label>Agregar detalles de las amenidades</label>
									        <button type="button" class="btn btn-info btn-sm" id="addInput"><i class="fa fa-plus"></i></button>
									    </div>
									</div>
									<div class="col-lg-12">
										<div class="form-group">
									        <input type="text" class="form-control" name="input_1" id="input_1">
									    </div>
									    <div class="container_amenities">
									    	@if($item_amenities != null)
											    <div class="kt-section__content table-responsive">
										            <table class="table">
										                <thead class="thead-light">
										                    <tr>
										                        <th>Estatus</th>
										                        <th>Acción</th>
										                    </tr>
										                </thead>
										                <tbody>
										                    @foreach($item_amenities as $key => $value)
										                        <tr>
										                            <td>{{ $value['data'] }}</td>
										                            <td><button type="button" class="btn btn-danger btn-sm delete_input_1" attr_delete_input_1="{{ $key }}"><i class="fa fa-trash"></i></button></td>
										                        </tr>
										                    @endforeach
										                </tbody>
										            </table>
											    </div>
											@endif 
										</div>
									</div>
								</div>
							</div>
							<div class="kt-portlet__foot">
								<div class="kt-form__actions">
									<button type="submit" class="btn btn-primary">Enviar</button>
									<button type="reset" class="btn btn-secondary">Cancelar</button>
								</div>
							</div>
						{!! Form::close(); !!}
					</div>
				</div>
			</div>
		</div>
	</div>
	<div class="modal fade" id="modalInput1Delete" tabindex="-1" role="dialog" aria-labelledby="smallModalLabel" aria-hidden="true">
       	<div class="modal-dialog modal-sm">
           	<div class="modal-content">
               	<div class="modal-header">
                   	<h5 class="modal-title" id="smallModalLabel">Eliminar Registro</h5>
                   	<input name="_method" type="hidden" value="DELETE">
                   	<input name="id_input_1" id="id_input_1" type="hidden" value="">
               	</div>
               	<div class="modal-body">
        			<p class="text-center">¿Deseas eliminar este registro?</p>
        		</div>
               	<div class="modal-footer">
               		<button type="button" class="btn btn-secondary" data-dismiss="modal">
            			Cerrar
        			</button>
                   	<button type="button" class="btn btn-danger" data-dismiss="modal" id="dlt_input_1">Confirmar</button>
               	</div>
           	</div>
       	</div>
   	</div>
@endsection
@section('js')
	<script src="{{ asset('panel/assets/vendors/general/jquery-validation/dist/jquery.validate.js') }}" type="text/javascript"></script>
	<script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
	<script src="{{ asset('panel/assets/vendors/general/markdown/lib/markdown.js') }}" type="text/javascript"></script>
	<script src="{{ asset('panel/assets/vendors/general/bootstrap-markdown/js/bootstrap-markdown.js') }}" type="text/javascript"></script>
	<script src="{{ asset('panel/assets/vendors/custom/js/vendors/bootstrap-markdown.init.js') }}" type="text/javascript"></script>
	<script src="{{ asset('panel/assets/js/demo1/pages/crud/forms/widgets/bootstrap-markdown.js') }}" type="text/javascript"></script>
	<script type="text/javascript">
		$('.kt-select2').select2();
		var token = "{{ csrf_token() }}";
		var detail_js = {!! $detail_js !!};
		var detail = "{{ $detail }}";
		if (detail != '') {
			$('input[name="all_inclusive"]').filter('[value="' + detail_js.all_inclusive + '"]').prop('checked', true);
			if (detail_js.all_inclusive == 'Si') {
				$('.div_all_inclusive').show();
				$('#all_inclusive_detail').val(detail_js.all_inclusive_detail);
			} else {
				$('.div_all_inclusive').hide();
				$('#all_inclusive_detail').val('');
			}

			$('input[name="located_beach"]').filter('[value="' + detail_js.located_beach + '"]').prop('checked', true);
			if (detail_js.located_beach == 'Si') {
				$('.div_name_beach').show();
				$('#name_beach').val(detail_js.name_beach);
			} else {
				$('.div_name_beach').hide();
				$('#name_beach').val('');
			}

			$('input[name="sustainability_travelife"]').filter('[value="' + detail_js.sustainability_travelife + '"]').prop('checked', true);
			if (detail_js.sustainability_travelife == 'Si') {
				$('.div_certification_type').show();
				$('#certification_type').val(detail_js.certification_type).trigger('change');
			} else {
				$('.div_certification_type').hide();
				$('#certification_type').val('').trigger('change');
			}

			$('input[name="exonerated_infant"]').filter('[value="' + detail_js.exonerated_infant + '"]').prop('checked', true);
			if (detail_js.exonerated_infant == 'Si') {
				$('.div_infants_age').show();
				$('#infants_age').val(detail_js.infants_age);
			} else {
				$('.div_infants_age').hide();
				$('#infants_age').val('');
			}

			$('input[name="free_wifi"]').filter('[value="' + detail_js.free_wifi + '"]').prop('checked', true);
			$('input[name="amenities"]').filter('[value="' + detail_js.amenities + '"]').prop('checked', true);
			if (detail_js.amenities == 'Si') {
				$('.div_amenities').show();
			} else {
				$('.div_amenities').hide();
			}

			if (detail_js.price == 'Si') {
				$('#price').val(detail_js.price).trigger('change');
				if (detail_js.type_price == 'General') {
					$('.div_type_price').show();
					$('#type_price').val(detail_js.type_price).trigger('change');
					$('.div_general_price').show();
					$('#general_price').val(detail_js.general_price);
				} else {
					$('.div_type_price').show();
					$('#type_price').val(detail_js.type_price).trigger('change');
					$('.div_date_price').show();
				}
			} else {
				//
			}
		}

		$('.all_inclusive').click(function() {
			if ($(this).val() == 'Si') {
				$('#all_inclusive_detail').val('');
				$('.div_all_inclusive').show();
			} else {
				$('.div_all_inclusive').hide();
				$('#all_inclusive_detail').val('');
			}
		});

		$('.located_beach').click(function() {
			if ($(this).val() == 'Si') {
				$('#name_beach').val('');
				$('.div_name_beach').show();
			} else {
				$('.div_name_beach').hide();
				$('#name_beach').val('');
			}
		});

		$('.sustainability_travelife').click(function() {
			if ($(this).val() == 'Si') {
				$('#certification_type').val('');
				$('.div_certification_type').show();
			} else {
				$('.div_certification_type').hide();
				$('#certification_type').val('');
			}
		});

		$('.amenities').click(function() {
			if ($(this).val() == 'Si') {
				$('.div_amenities').show();
			} else {
				$('.div_amenities').hide();
			}
		});

		$('.exonerated_infant').click(function() {
			if ($(this).val() == 'Si') {
				$('#infants_age').val('');
				$('.div_infants_age').show();
			} else {
				$('.div_infants_age').hide();
				$('#infants_age').val('');
			}
		});

		$('#addInput').click(function(){
			var input_1 = $('#input_1').val();
			if (input_1 != '') {
				$('#input_1').val('');
				var url = "{{ route('panel.hotels.detail.add.amenities') }}";
				$.ajax({
					url: url,
					type: 'POST',
					data: { _token: token, input_1: input_1 },
					success: function(result){
						$('.container_amenities').html(result.html);
						$('.delete_input_1').click(function() {
				            var input_1 = $(this).attr('attr_delete_input_1');
				            $('#modalInput1Delete').modal('show');
				            $('#id_input_1').val(input_1);
				        });
					}
				});
			}
		});

		$('.delete_input_1').click(function() {
            var input_1 = $(this).attr('attr_delete_input_1');
            $('#modalInput1Delete').modal('show');
            $('#id_input_1').val(input_1);
        });

        $('#dlt_input_1').click(function() {
        	var input_1 = $('#id_input_1').val();
        	if (input_1 != '') {
        		var url = "{{ route('panel.hotels.detail.delete.amenities') }}";
        		$.ajax({
        			url: url,
        			type: 'POST',
        			data: { _token: token, input_1: input_1 },
        			success: function(result){
        				$('.container_amenities').html(result.html);
						$('.delete_input_1').click(function() {
				            var input_1 = $(this).attr('attr_delete_input_1');
				            $('#modalInput1Delete').modal('show');
				            $('#id_input_1').val(input_1);
				        });
        			}
        		});
        	}
        });
	</script>
	<script type="text/javascript">
		$(document).ready(function() {
		    $("#input_1").autocomplete({
		        source: function(request, response) {
		            $.ajax({
		                url: "{{ route('amenities.search') }}",
		                dataType: "json",
		                data: {
		                    term: request.term
		                },
		                success: function(data) {
		                    response($.map(data, function(item) {
		                        return {
		                            label: item.name, // Asigna el campo que deseas mostrar en la lista de autocompletado
		                            value: item.name // Asigna el valor que deseas cuando se selecciona un elemento
		                        };
		                    }));
		                }
		            });
		        },
		        minLength: 2 // Mínimo de caracteres antes de activar el autocompletado
		    });
		});
	</script>
@endsection