@extends('layouts.panel.base')
@section('hotel-active', 'kt-menu__item--active')
@section('title', 'Agregar Detaalles del Hotel')
@section('css')
	<link href="{{ asset('panel/assets/vendors/general/summernote/dist/summernote.css') }}" rel="stylesheet" type="text/css" />
	<style type="text/css">
		.md-editor>textarea {
			background: #fff !important;
			padding: 5px !important;
		}
	</style>
@endsection
@section('content')
	<link rel="stylesheet" href="https://code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
	<link href="{{ asset('panel/assets/vendors/general/bootstrap-markdown/css/bootstrap-markdown.min.css') }}" rel="stylesheet" type="text/css" />
	<style type="text/css">
		.ui-menu-item-wrapper{
			height: 30px !important;
			padding: 10px;
		}
	</style>
	<div class="kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor">
		<div class="kt-subheader   kt-grid__item" id="kt_subheader">
			<div class="kt-subheader__main">
				<h3 class="kt-subheader__title">Hotel</h3>
				<span class="kt-subheader__separator kt-hidden"></span>
				<div class="kt-subheader__breadcrumbs">
					<a href="{{ route('panel.dashboard') }}" class="kt-subheader__breadcrumbs-home"><i class="flaticon2-shelter"></i></a>
					<span class="kt-subheader__breadcrumbs-separator"></span>
					<a href="{{ route('panel.hotels.detail', encrypt($hotel->id)) }}" class="kt-subheader__breadcrumbs-link">
						Detalles
					</a>
				</div>
			</div>
		</div>
		<div class="kt-content  kt-grid__item kt-grid__item--fluid" id="kt_content">
			<div class="row">
				<div class="col-lg-12">
					<div class="kt-portlet">
						<div class="kt-portlet__head">
							<div class="kt-portlet__head-label">
								<h3 class="kt-portlet__head-title">
									Agregar Precio
								</h3>
							</div>
						</div>
						{!! Form::open(['route' => ['panel.hotels.room.price.save', encrypt($query->id)], 'method' => 'POST', 'class'=>"kt-form", 'id' => 'hotel_form']) !!}
							{{ csrf_field() }}
							@if(count($errors) > 0)
	                            <div class="alert alert-danger" role="alert" style="margin: 10px;">
	                                <ul style="margin-top: 0; margin-bottom: 0rem;">
	                                   @foreach($errors->all() as $error)
	                                       <li>{!! $error !!}</li>
	                                   @endforeach
	                                </ul>                        
	                            </div>
		                    @endif
		                    @if (Session::has('error'))
	                            <div class="alert alert-danger" role="alert" style="margin: 10px;">
	                                <div class="alert-text">{{ Session::get('error') }}</div>
	                            </div>
		                    @endif
							<div class="kt-portlet__body">
								<div class="kt-separator kt-separator--space-sm  kt-separator--border-dashed"></div>
								<div class="row">
									<div class="col-lg-12 div_type_price">
										<div class="form-group">
											<label>Agregar por Fechas o General <span class="input-required">*</span></label>
											{{ Form::select('type_price', ['Por Fecha'=>'Por Fecha', 'General'=>'General'], '', array('class'=>'form-control kt-select2 type_price', 'placeholder'=>'Seleccione', 'id'=>'type_price')) }}
                    						<label style="display: none" id="type_price-error" class="error" for="type_price"></label>
										</div>
									</div>
									<div class="col-lg-12" style="margin-bottom: 15px;">
										<textarea name="observation" class="summernote" id="kt_summernote_1"></textarea>
									</div>
									<div class="col-lg-6 div_general_price" style="display: none">
										<div class="form-group">
											<label>Precio General <span class="input-required">*</span></label>
                    						{{ Form::number('general_price', null, array('class'=>'form-control', 'id'=>'general_price')) }}
										</div>
									</div>
								</div>
								<div class="div_date_price" style="display: none">
									<div class="row">
										<div class="col-lg">
											<div class="form-group">
												<label>Fecha Inicial <span class="input-required">*</span></label>
	                    						{{ Form::date('initial_date', null, array('class'=>'form-control', 'id'=>'initial_date')) }}
											</div>
										</div>
										<div class="col-lg">
											<div class="form-group">
												<label>Fecha Final <span class="input-required">*</span></label>
	                    						{{ Form::date('final_date', null, array('class'=>'form-control', 'id'=>'final_date')) }}
											</div>
										</div>
										<div class="col-lg">
											<div class="form-group">
												<label>Precio <span class="input-required">*</span></label>
	                    						{{ Form::number('price_date', null, array('class'=>'form-control', 'id'=>'price_date')) }}
											</div>
										</div>
										<div class="col-lg-2">
											<div class="form-group">
												<label>Agregar</label><br>
												<button type="button" class="btn btn-info btn-sm" id="addDate"><i class="fa fa-plus"></i></button>
											</div>
										</div>
									</div>
								    <div class="container_price_date">
								    	@if(count($item_date) > 0)
								    		<div class="kt-section__content table-responsive">
								    		    <table class="table">
								    		        <thead class="thead-light">
								    		            <tr>
								    		                <th>In</th>
								    		                <th>Out</th>
								    		                <th>Precio</th>
								    		                <th>Acción</th>
								    		            </tr>
								    		        </thead>
								    		        <tbody>
								    		            @foreach($item_date as $key => $value)
								    		                <tr>
								    		                    <td>{{ date("d-m-Y", strtotime($value['initial_date'])) }}</td>
								    		                    <td>{{ date("d-m-Y", strtotime($value['final_date'])) }}</td>
								    		                    <td>{{ number_format($value['price_date'], 2) }}</td>
								    		                    <td><button type="button" class="btn btn-danger btn-sm deleteDate" attr_delete_date="{{ $key }}"><i class="fa fa-trash"></i></button></td>
								    		                </tr>
								    		            @endforeach
								    		       	</tbody>
								    		   	</table>
								    		</div>
								    	@endif
								    </div>
									<div class="row rest_of_the_time" style="display: none">
										<div class="col-lg-6">
											<div class="form-group">
												<label>Resto del año</label>
												{{ Form::number('rest_year', $query->price_rest_of_year, array('class'=>'form-control', 'id'=>'rest_year')) }}
										    </div>
										</div>
									</div>
								</div>
							</div>
							<div class="kt-portlet__foot">
								<div class="kt-form__actions">
									<button type="submit" class="btn btn-primary">Enviar</button>
									<button type="reset" class="btn btn-secondary">Cancelar</button>
								</div>
							</div>
						{!! Form::close(); !!}
					</div>
				</div>
			</div>
		</div>
	</div>
   	<div class="modal fade" id="modalDateDelete" tabindex="-1" role="dialog" aria-labelledby="smallModalLabel" aria-hidden="true">
       	<div class="modal-dialog modal-sm">
           	<div class="modal-content">
               	<div class="modal-header">
                   	<h5 class="modal-title" id="smallModalLabel">Eliminar Registro</h5>
                   	<input name="_method" type="hidden" value="DELETE">
                   	<input name="id_date" id="id_date" type="hidden" value="">
               	</div>
               	<div class="modal-body">
        			<p class="text-center">¿Deseas eliminar este registro?</p>
        		</div>
               	<div class="modal-footer">
               		<button type="button" class="btn btn-secondary" data-dismiss="modal">
            			Cerrar
        			</button>
                   	<button type="button" class="btn btn-danger" data-dismiss="modal" id="dlt_date">Confirmar</button>
               	</div>
           	</div>
       	</div>
   	</div>
@endsection
@section('js')
	<script src="{{ asset('panel/assets/vendors/general/jquery-validation/dist/jquery.validate.js') }}" type="text/javascript"></script>
	<script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
	<script src="{{ asset('panel/assets/vendors/general/markdown/lib/markdown.js') }}" type="text/javascript"></script>
	<script src="{{ asset('panel/assets/vendors/general/bootstrap-markdown/js/bootstrap-markdown.js') }}" type="text/javascript"></script>
	<script src="{{ asset('panel/assets/vendors/custom/js/vendors/bootstrap-markdown.init.js') }}" type="text/javascript"></script>
	<script src="{{ asset('panel/assets/js/demo1/pages/crud/forms/widgets/bootstrap-markdown.js') }}" type="text/javascript"></script>
	<script src="{{ asset('panel/assets/vendors/general/summernote/dist/summernote.js') }}" type="text/javascript"></script>
	<script src="{{ asset('panel/assets/js/demo1/pages/crud/forms/widgets/summernote.js') }}" type="text/javascript"></script>
	<script type="text/javascript">
		$('.kt-select2').select2();
		var token = "{{ csrf_token() }}";
		var count_dates = "{{ count($item_date) }}";

		if (count_dates > 0) {
			$('.div_general_price').hide();
			$('#general_price').val('');
			$('.div_date_price').show();
			$('#type_price').val('Por Fecha').trigger('change');
			$('.rest_of_the_time').show();
		}

        $('#type_price').change(function(){
        	var type_price = $('#type_price').val();
        	if (type_price == 'General') {
        		$('.div_general_price').show();
        		$('.div_date_price').hide();
        	} else if(type_price == 'Por Fecha'){
        		$('.div_general_price').hide();
        		$('#general_price').val('');
        		$('.div_date_price').show();
        	}
        });

        $('#addDate').click(function(){
			var initial_date = $('#initial_date').val();
			var final_date = $('#final_date').val();
			var room_type = $('#room_type').val();
			var price_date = $('#price_date').val();
			if (initial_date != '' || final_date != '' || room_type != '' || price_date != '') {
				$('#initial_date').val('');
				$('#final_date').val('');
				$('#room_type').val('').trigger('change');
				$('#price_date').val('');
				var url = "{{ route('panel.hotels.add.date') }}";
				$.ajax({
					url: url,
					type: 'POST',
					data: { _token: token, initial_date: initial_date, final_date: final_date, room_type: room_type, price_date: price_date },
					success: function(result){
						$('.container_price_date').html(result.html);
						$('.deleteDate').click(function() {
				            var date = $(this).attr('attr_delete_date');
				            $('#modalDateDelete').modal('show');
				            $('#id_date').val(date);
				        });
				        var count_rooms = result.count_rooms;
				        if (count_rooms > 0) {
				        	$('.rest_of_the_time').show();
				        }
					}
				});
			}
		});

		$('.deleteDate').click(function() {
            var room = $(this).attr('attr_delete_date');
            $('#modalDateDelete').modal('show');
            $('#id_date').val(room);
        });

        $('#dlt_date').click(function() {
        	var id_date = $('#id_date').val();
        	if (id_date != '') {
        		var url = "{{ route('panel.hotels.delete.date') }}";
        		$.ajax({
        			url: url,
        			type: 'POST',
        			data: { _token: token, id_date: id_date },
        			success: function(result){
						$('.container_price_date').html(result.html);
						$('.deleteDate').click(function() {
				            var room = $(this).attr('attr_delete_date');
				            $('#modalDateDelete').modal('show');
				            $('#id_date').val(room);
				        });
				        var count_rooms = result.count_rooms;
				        if (count_rooms > 0) {
				        	$('.rest_of_the_time').show();
				        }
        			}
        		});
        	}
        });
	</script>
@endsection