@extends('layouts.panel.base')
@section('hotel-active', 'kt-menu__item--active')
@section('title', 'Modificar Detalles de la Habitación')
@section('css')
	<link href="{{ asset('panel/assets/vendors/general/summernote/dist/summernote.css') }}" rel="stylesheet" type="text/css" />
	<style type="text/css">
		.md-editor>textarea {
			background: #fff !important;
			padding: 5px !important;
		}
	</style>
@endsection
@section('content')
	<div class="kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor">
			<div class="kt-subheader   kt-grid__item" id="kt_subheader">
				<div class="kt-subheader__main">
					<h3 class="kt-subheader__title">Hotel</h3>
					<span class="kt-subheader__separator kt-hidden"></span>
					<div class="kt-subheader__breadcrumbs">
						<a href="{{ route('panel.dashboard') }}" class="kt-subheader__breadcrumbs-home"><i class="flaticon2-shelter"></i></a>
						<span class="kt-subheader__breadcrumbs-separator"></span>
						<a href="{{ route('panel.hotels.detail', encrypt($hotel->id)) }}" class="kt-subheader__breadcrumbs-link">
							Detalles
						</a>
					</div>
				</div>
			</div>
			<div class="kt-content  kt-grid__item kt-grid__item--fluid" id="kt_content">
				<div class="row">
					<div class="col-lg-12">
						<div class="kt-portlet">
							<div class="kt-portlet__head">
								<div class="kt-portlet__head-label">
									<h3 class="kt-portlet__head-title">
										Detalles de la Habitación
									</h3>
								</div>
							</div>
							{!! Form::open(['route' => ['panel.hotels.room.update', encrypt($room->id)], 'method' => 'POST', 'class'=>"kt-form", 'id' => 'hotel_form']) !!}
								{{ csrf_field() }}
								<div class="kt-portlet__body">
									<div class="row">
										<div class="col-lg-12">
											<div class="form-group">
												<label>Tipo de Habitación <span class="input-required">*</span></label>
												{{ Form::select('type', $rooms, $room->room_id, array('class'=>'form-control kt-select2','placeholder'=>'Seleccione la Habitación','id'=>'type')) }}
												<label style="display: none" id="type-error" class="error" for="type"></label>
											</div>
										</div>
									</div>
									<div class="row" id="new-room" style="display: none">
										<div class="col-lg-12">
											<div class="form-group">
												<label>Nueva Habitación <span class="input-required">*</span></label>
												{{ Form::text('new_room', null, array('class'=>'form-control', 'id'=>'new_room')) }}
												<label style="display: none" id="type-error" class="error" for="type"></label>
											</div>
										</div>
									</div>
									<div class="row">
										<div class="col-lg">
											<label>Detalles de la Habitación <span class="input-required">*</span></label>
											<textarea name="room_detail" class="summernote" id="kt_summernote_1">{!! $room->detail !!}</textarea>
										</div>
									</div>
								</div>
								<div class="kt-portlet__foot">
									<div class="kt-form__actions">
										<button type="submit" class="btn btn-primary">Enviar</button>
									</div>
								</div>
							{!! Form::close(); !!}
						</div>
					</div>
				</div>
			</div>
		</div>
@endsection
@section('js')
	<script src="{{ asset('panel/assets/vendors/general/jquery-validation/dist/jquery.validate.js') }}" type="text/javascript"></script>
	<script src="{{ asset('panel/assets/vendors/general/summernote/dist/summernote.js') }}" type="text/javascript"></script>
	<script src="{{ asset('panel/assets/js/demo1/pages/crud/forms/widgets/summernote.js') }}" type="text/javascript"></script>
	<script>
		$('.kt-select2').select2();

		$('#type').change(function(){
			var	new_room = $('#type').val();
			if(new_room == 'new'){
				$('#new-room').show();
				$('#new_room').val('');
			}else{
				$('#new-room').hide();
				$('#new_room').val('');
			}
		});
	</script>
@endsection