@extends('layouts.panel.base')
@section('hotel-active', 'kt-menu__item--active')
@section('title', 'Detalles del Hotel')
@section('content')
	<div class="kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor">
		<div class="kt-subheader   kt-grid__item" id="kt_subheader">
			<div class="kt-subheader__main">
				<h3 class="kt-subheader__title">Hoteles</h3>
				<span class="kt-subheader__separator kt-hidden"></span>
				<div class="kt-subheader__breadcrumbs">
					<a href="{{ route('panel.dashboard') }}" class="kt-subheader__breadcrumbs-home"><i class="flaticon2-shelter"></i></a>
					<span class="kt-subheader__breadcrumbs-separator"></span>
					<a href="{{ route('hotels.show', encrypt($hotel->id)) }}" class="kt-subheader__breadcrumbs-link">
						Detalles
					</a>
				</div>
			</div>
		</div>
		<div class="kt-content  kt-grid__item kt-grid__item--fluid" id="kt_content">
			<div class="row">
				<div class="col-lg-12">
					<div class="kt-portlet">
						<div class="kt-portlet__head">
							<div class="kt-portlet__head-label">
								<h3 class="kt-portlet__head-title">
									Detalles del Hotel
								</h3>
							</div>
						</div>
						<div class="kt-portlet__body">
							@if(Session::has('success'))
					            <div class="alert alert-success" role="alert">
					                <div class="alert-text">{{ Session::get('success') }}</div>
					            </div>
					        @endif
					        <div class="kt-section">
	                            <a href="{{ route('hotels.index') }}" class="btn btn-secondary btn-sm btn-margin-bottom" title="Listado">
	                                <span>
	                                    <i class="fas fa-list"></i>
	                                    <span>
	                                        Listado
	                                    </span>
	                                </span>
	                            </a>
	                            <a href="{{ route('hotels.create') }}" class="btn btn-primary btn-sm btn-margin-bottom" title="Nuevo">
	                                <span>
	                                    <i class="fas fa-plus"></i>
	                                    <span>
	                                        Nuevo
	                                    </span>
	                                </span>
	                            </a>
	                            <a href="{{ route('hotels.edit', encrypt($hotel->id)) }}" class="btn btn-warning btn-sm btn-margin-bottom" title="Modificar">
	                                <span>
	                                    <i class="fas fa-edit"></i>
	                                    <span>
	                                        Modificar
	                                    </span>
	                                </span>
	                            </a>
	                            <a href="{{ route('panel.hotels.room', encrypt($hotel->id)) }}" class="btn btn-info btn-sm btn-margin-bottom" title="Habitación">
	                                <span>
	                                    <i class="fa-solid fa-door-open"></i>
	                                    <span>
	                                        Habitaciones
	                                    </span>
	                                </span>
	                            </a>
	                            <a href="{{ route('panel.hotels.detail', encrypt($hotel->id)) }}" class="btn btn-success btn-sm btn-margin-bottom" title="Modificar">
	                                <span>
	                                    <i class="fas fa-file"></i>
	                                    <span>
	                                        Detalles
	                                    </span>
	                                </span>
	                            </a>
	                            <button data-toggle="modal" data-target="#kt_modal" class="btn btn-danger btn-sm btn-margin-bottom" title="Eliminar">
	                                <span>
	                                    <i class="fas fa-trash"></i>
	                                    <span>
	                                        Eliminar
	                                    </span>
	                                </span>
	                            </button>
					        </div>
					        <div class="kt-separator kt-separator--space-sm  kt-separator--border-dashed"></div>
							<div class="kt-section">
								<h3 class="kt-section__title">Información General</h3>
								<div class="form-group row">
									<div class="col-lg-6">
										<p><b>Nombre:</b> {{ $hotel->name }}</p>
										<p><b>Check In:</b> {{ $hotel->check_in }} <b>Check Out:</b> {{ $hotel->check_out }}</p>
										<p><b>País:</b> {{ $hotel->country->name }}</p>
									</div>
									<div class="col-lg-6">
										<p><b>Estado:</b> {{ $hotel->state->name }}</p>
										<p><b>Ciudad:</b> {{ $hotel->city->name }}</p>
										<p><b>Dirección:</b> {{ $hotel->address }}</p>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			@if($detail)
				<div class="row">
				    <div class="col-xl-12">
				        <div class="kt-portlet">
				            <div class="kt-portlet__head">
				                <div class="kt-portlet__head-label">
				                    <h3 class="kt-portlet__head-title">
				                        Características del Hotel
				                    </h3>
				                </div>
				            </div>
				            <div class="kt-portlet__body">
				                <div class="kt-section">
				                	<div class="form-group row">
				                		<div class="col-lg-6">
				                			<p><b>Todo Incluido:</b> {{ $detail->all_inclusive }}</p>
				                			<p><b>Detalle:</b> {{ $detail->all_inclusive_detail }}</p>
				                			<p><b>Situado en la playa:</b> {{ $detail->located_beach }}</p>
				                			<p><b>Playa:</b> {{ $detail->name_beach }}</p>
				                			<p><b>Sustainability Travelife:</b> {{ $detail->sustainability_travelife }}</p>
				                			<p><b>Tipo de Certificación:</b> {{ $detail->certification_type }}</p>
				                		</div>
				                		<div class="col-lg-6">
				                			<p><b>Infantes Exonerados:</b> {{ $detail->exonerated_infant }}</p>
				                			<p><b>Edad:</b> {{ $detail->infants_age }} años</p>
				                			<p><b>Wifi Gratuito:</b> {{ $detail->free_wifi }}</p>
				                			<p><b>Amenidades:</b> {{ $detail->amenities }}</p>
				                			@if($detail->type_price != 'General')
				                				<p><b>Precio el resto del año:</b> ${{ $detail->price_rest_year }}</p>
				                			@endif
				                		</div>
				                	</div>
				                    <div class="kt-section__content table-responsive">
				                    	@if($detail->type_price == 'General')
					                    	@if($detail->price == 'Si')
					                            <table class="table">
					                                <thead class="thead-light">
					                                    <tr>
					                                        <th colspan="2">Precio</th>
					                                    </tr>
					                                </thead>
					                                <tbody>
				                                        <tr>
				                                            <td>Precios Generales</td>
				                                            <td>$ {{ $detail->general_price }}</td>
				                                        </tr>
					                                </tbody>
					                            </table>
					                        @endif
					                    @else
					                        @if(count($days)>0)
					                        	<table class="table">
					                        	    <thead class="thead-light">
					                        	        <tr>
					                        	            <th>In</th>
					                        	            <th>Out</th>
					                        	            <th>Habitación</th>
					                        	            <th>Precio</th>
					                        	        </tr>
					                        	    </thead>
					                        	    <tbody>
					                        	        @foreach($days as $key => $value)
					                        	            <tr>
					                        	                <td>{{ $value->in }}</td>
					                        	                <td>{{ $value->out }}</td>
					                        	                <td>{{ $value->type_room }}</td>
					                        	                <td>{{ $value->price }}</td>
					                        	            </tr>
					                        	        @endforeach
					                        	    </tbody>
					                        	</table>>
					                        @endif
					                    @endif 
				                        <br>
				                        @if(count($amenities)>0)
				                            <table class="table">
				                                <thead class="thead-light">
				                                    <tr>
				                                        <th>Amenidades</th>
				                                    </tr>
				                                </thead>
				                                <tbody>
				                                    @foreach($amenities as $key => $value)
				                                        <tr>
				                                            <td>{{ $value->name }}</td>
				                                        </tr>
				                                    @endforeach
				                                </tbody>
				                            </table>
				                        @else
				                            <div class="alert alert-outline-danger fade show" role="alert">
				                                <div class="alert-icon"><i class="flaticon-warning"></i></div>
				                                <div class="alert-text">Sin Amenidades</div>
				                            </div>
				                        @endif 
				                    </div>
				                </div>
				            </div>
				        </div>
				    </div>
				</div>
			@endif
			@if($rooms)
				<div class="row">
				    <div class="col-xl-12">
				        <div class="kt-portlet">
				        	<div class="kt-portlet__head">
				        		<div class="kt-portlet__head-label">
				        			<h3 class="kt-portlet__head-title">
				        				Detalles de las Habitaciones
				        			</h3>
				        		</div>
				        	</div>
				        	<div class="kt-portlet__body">
				        		<ul class="nav nav-pills nav-fill" role="tablist">
				        			@foreach($rooms as $key => $value)
					        			<li class="nav-item">
					        				@php
					        					if($key == 0){
					        						$active = 'active';
					        					}else{
					        						$active = null;
					        					}
					        				@endphp
					        				<a class="nav-link {{ $active }}" data-toggle="tab" href="#kt_tabs_5_{{ $value->id }}">{{ $value->room->name }}</a>
					        			</li>
					        		@endforeach
				        		</ul>
				        		<div class="tab-content">
				        			@foreach($rooms as $key => $value)
				        				@php
				        					if($key == 0){
				        						$active = 'active';
				        					}else{
				        						$active = null;
				        					}
				        				@endphp
					        			<div class="tab-pane {{ $active }}" id="kt_tabs_5_{{ $value->id }}" role="tabpanel">
					        				<div class="d-flex justify-content-end">
					        					<a href="{{ route('panel.hotels.room.price', encrypt($value->id)) }}" type="button" class="btn btn-success btn-sm" style="margin-right: 5px;">Precios</a>
					        					<a href="{{ route('panel.hotels.room.edit', encrypt($value->id)) }}" type="button" class="btn btn-warning btn-sm" style="color: #000; margin-right: 5px;">Modificar</a> <button type="button" class="btn btn-danger btn-sm" data-toggle="modal" data-target="#kt_modal_{{ $value->id }}">Eliminar</button>
					        				</div>
					        				<hr>
					        				<div class="row">
					        					<div class="col-lg">
					        						{!! $value->detail !!}
					        					</div>
					        					<div class="col-lg">
					        						@foreach($value->roomDayPrice as $key2 => $value2)
					        							<b>In</b>: {{ date("d-m-Y", strtotime($value2->in)) }} 
					        							<b>Out</b>: {{ date("d-m-Y", strtotime($value2->out)) }} 
					        							<b>Precio</b>: ${{ number_format($value2->price, 2) }} <br>
					        						@endforeach
					        						@if($value->price_rest_of_year != null || $value->price_rest_of_year != '')
					        							<b>Resto del año:</b> ${{ number_format($value->price_rest_of_year, 2) }}
					        						@endif
					        						@if($value->general_price != null || $value->general_price != '')
					        							<b>Precio General:</b> ${{ number_format($value->general_price, 2) }}
					        						@endif
					        						@if($value->room->hotelRoom->roomPriceObservation)
					        							<br>
					        							<b>Observación:</b>
					        							{!! $value->room->hotelRoom->roomPriceObservation->observation !!}
					        						@endif
					        					</div>
					        				</div>
					        			</div>
				        				<div class="modal fade" id="kt_modal_{{ $value->id }}" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
				        					<div class="modal-dialog" role="document">
				        						<div class="modal-content">
				        							<div class="modal-header">
				        								<h5 class="modal-title" id="exampleModalLabel">Eliminar Registro</h5>
				        								<button type="button" class="close" data-dismiss="modal" aria-label="Close">
				        								</button>
				        							</div>
				        							<div class="modal-body">
									        			<p class="text-center">¿Deseas eliminar este registro?</p>
									        		</div>
				        							<div class="modal-footer">
				        								<button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
				        								<a href="{{ route('panel.hotels.room.price.delete', encrypt($value->id)) }}" class="btn btn-primary">Conformar</a>
				        							</div>
				        						</div>
				        					</div>
				        				</div>
					        		@endforeach
				        		</div>
				        	</div>
				        </div>
				    </div>
				</div>
			@endif
			<div class="row">
			    <div class="col-xl-12">
			        <div class="kt-portlet">
			            <div class="kt-portlet__head">
			                <div class="kt-portlet__head-label">
			                    <h3 class="kt-portlet__head-title">
			                        Historial
			                    </h3>
			                </div>
			            </div>
			            <div class="kt-portlet__body">
			                <div class="kt-section">
			                    <div class="kt-section__content table-responsive">
			                        @if(count($history)>0)
			                            <table class="table">
			                                <thead class="thead-light">
			                                    <tr>
			                                        <th>Estatus</th>
			                                        <th>Usuario</th>
			                                        <th>Fecha</th>
			                                    </tr>
			                                </thead>
			                                <tbody>
			                                    @foreach($history as $key => $value)
			                                        <tr>
			                                            <?php 
			                                            $datos=json_decode($value->data);
			                                            if (isset($datos->motivo)){
			                                                $mensaje=$datos->motivo;
			                                            }elseif (isset($datos->comentario)) {
			                                                $mensaje=$datos->comentario;
			                                            }else{
			                                                $mensaje="";
			                                            } ?>
			                                            <td>{{ $value->status }} @if(isset($datos->motivo) || isset($datos->comentario)) {!! '<br><strong>'.$mensaje.'</strong>' !!} @endif</td>
			                                            <td>
			                                                {{ ucwords($value->user->name) }} {{ ucwords($value->user->last_name) }}
			                                            </td>
			                                            <td>{{ date_format(date_create($value->created_at),"d/m/Y H:i:s") }}</td>
			                                        </tr>
			                                    @endforeach
			                                </tbody>
			                            </table>
			                        @else
			                            <div class="alert alert-outline-danger fade show" role="alert">
			                                <div class="alert-icon"><i class="flaticon-warning"></i></div>
			                                <div class="alert-text">Sin historial registrados</div>
			                            </div>
			                        @endif 
			                    </div>
			                </div>
			            </div>
			        </div>
			    </div>
			</div>
		</div>
	</div>
	<div class="modal fade" id="kt_modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true" style="display: none;">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">
                            &times;
                        </span>
                    </button>
                </div>
                {!! Form::open(['route' => ['hotels.destroy', encrypt($hotel->id)], 'method' => 'POST', 'id' => 'form_eliminar']) !!}           
                    <div class="modal-body">
                        <input name="_method" type="hidden" value="DELETE">
                        <h4 class="text-center">¿Desea eliminar el hotel?</h4>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">
                            Cerrar
                        </button>
                        <button type="submit" class="btn btn-primary">
                            Confirmar
                        </button>
                    </div>
                    {{ csrf_field() }}
                {!! Form::close() !!}
            </div>
        </div>
    </div>
@endsection
@section('js')
@endsection