@extends('layouts.panel.base')
@section('permission-assignment-active', 'kt-menu__item--active')
@section('open-roles-permissions', 'kt-menu__item--open')
@section('title', 'Asignar Permiso')
@section('content')
	<div class="kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor">
		<div class="kt-subheader   kt-grid__item" id="kt_subheader">
			<div class="kt-subheader__main">
				<h3 class="kt-subheader__title">Permiso</h3>
				<span class="kt-subheader__separator kt-hidden"></span>
				<div class="kt-subheader__breadcrumbs">
					<a href="{{ route('panel.dashboard') }}" class="kt-subheader__breadcrumbs-home"><i class="flaticon2-shelter"></i></a>
					<span class="kt-subheader__breadcrumbs-separator"></span>
					<a href="{{ route('panel.permissions.assignment') }}" class="kt-subheader__breadcrumbs-link">
						Asignar
					</a>
				</div>
			</div>
		</div>
		<div class="kt-content  kt-grid__item kt-grid__item--fluid" id="kt_content">
			<div class="row">
				<div class="col-lg-12">
					<div class="kt-portlet">
						<div class="kt-portlet__head">
							<div class="kt-portlet__head-label">
								<h3 class="kt-portlet__head-title">
									Asignar Permiso
								</h3>
							</div>
						</div>
						{!! Form::open(['route' => ['panel.permissions.assignment.save'], 'method' => 'POST', 'id' => 'permission_form']) !!}
							{{ csrf_field() }}
		                    @if(Session::has('success'))
	                            <div class="alert alert-success" role="alert" style="margin: 10px;">
	                                <div class="alert-text">{{ Session::get('success') }}</div>
	                            </div>
		                    @endif
							<div class="kt-portlet__body">
								<div class="row">
								    <div class="col-md-4">
								        <div class="form-group m-form__group">
								            <label for="exampleSelect2">
								                Roles
								            </label>
								            <select multiple="" name="rolAct" class="form-control m-input" id="rolAct" style="height: 250px">
								                @foreach($roles as $rol)
								                    <option value="{{ $rol->id }}">
								                        {{ $rol->name }}
								                    </option>
								                @endforeach
								            </select>
								        </div>
								    </div>
								    <div class="col-md-3">
								        <div class="form-group m-form__group">
								            <label for="exampleSelect2">
								                Permisos Asignados
								            </label>
								            <select multiple="" name="perAsig[]" class="form-control m-input" id="perAsig" style="height: 250px">
								                
								            </select>
								        </div>
								    </div>
								    <div class="col-md-2">
								        <br><br>
								        <button type="button" id="multi_d_rightSelected2" class="btn btn-default btn-block"><i class="fa fa-chevron-right"></i></button>
								        <button type="button" id="multi_d_leftSelected2" class="btn btn-default btn-block"><i class="fa fa-chevron-left"></i></button>
								    </div>
								    <div class="col-md-3">
								        <div class="form-group m-form__group">
								            <label for="exampleSelect2">
								                Permisos No Asignados
								            </label>
								            <select multiple="" class="form-control m-input" id="perNoAsig" style="height: 250px">
								                
								            </select>
								        </div>
								    </div>
								</div>
							</div>
							<div class="kt-portlet__foot">
								<div class="kt-form__actions">
									<button type="submit" class="btn btn-primary">Enviar</button>
								</div>
							</div>
						{!! Form::close(); !!}
					</div>
				</div>
			</div>
		</div>
	</div>
@endsection
@section('js')
	<script src="{{ asset('panel/assets/js/demo1/select_permission/moveOne.js') }}"></script>
    <script src="{{ asset('panel/assets/js/demo1/select_permission/multiselect.js') }}"></script>
    <script>
        var token = "{{ csrf_token() }}";

        $('#rolAct').click(function(){
        	var url_rol = "{{ route('panel.ajax.role.assignment') }}";
        	var	rol = $('#rolAct').val();
        	if(rol > 0){
				$.ajax({
	                url: url_rol,
	                type: 'POST',
	                data: { _token: token, rol: rol },
	                success: function(result){
	                	$("#perNoAsig").empty();
	                	$("#perAsig").empty();
	                	$.each(result.assignment, function(){
	                		$('#perAsig').append($('<option>', { 
	                		    value: this.id,
	                		    text : this.name 
	                		}));
	                	});

	                	$.each(result.no_assignment, function(){
	                		$('#perNoAsig').append($('<option>', { 
	                		    value: this.id,
	                		    text : this.name 
	                		}));
	                	});
	                }
	            });
        	}
        });
    </script>
@endsection