@extends('layouts.panel.base')
@section('permission-active', 'kt-menu__item--active')
@section('open-roles-permissions', 'kt-menu__item--open')
@section('title', 'Modificar Permiso')
@section('content')
	<div class="kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor">
		<div class="kt-subheader   kt-grid__item" id="kt_subheader">
			<div class="kt-subheader__main">
				<h3 class="kt-subheader__title">Permiso</h3>
				<span class="kt-subheader__separator kt-hidden"></span>
				<div class="kt-subheader__breadcrumbs">
					<a href="{{ route('panel.dashboard') }}" class="kt-subheader__breadcrumbs-home"><i class="flaticon2-shelter"></i></a>
					<span class="kt-subheader__breadcrumbs-separator"></span>
					<a href="{{ route('permissions.edit', encrypt($permission->id)) }}" class="kt-subheader__breadcrumbs-link">
						Modificar
					</a>
				</div>
			</div>
		</div>
		<div class="kt-content  kt-grid__item kt-grid__item--fluid" id="kt_content">
			<div class="row">
				<div class="col-lg-12">
					<div class="kt-portlet">
						<div class="kt-portlet__head">
							<div class="kt-portlet__head-label">
								<h3 class="kt-portlet__head-title">
									Modificar Permiso
								</h3>
							</div>
						</div>
						{!! Form::open(['route' => ['permissions.update', Crypt::encrypt($permission->id)], 'method' => 'PUT', 'class'=>"kt-form", 'id' => 'permission_form']) !!}
							{{ csrf_field() }}
							@if(count($errors) > 0)
	                            <div class="alert alert-danger" role="alert" style="margin: 10px;">
	                                <ul style="margin-top: 0; margin-bottom: 0rem;">
	                                   @foreach($errors->all() as $error)
	                                       <li>{!! $error !!}</li>
	                                   @endforeach
	                                </ul>                        
	                            </div>
		                    @endif
		                    @if (Session::has('error'))
	                            <div class="alert alert-danger" role="alert" style="margin: 10px;">
	                                <div class="alert-text">{{ Session::get('error') }}</div>
	                            </div>
		                    @endif
							<div class="kt-portlet__body">
								<div class="row">
									<div class="col-lg-12">
										<div class="form-group">
											<label>Nombre <span class="input-required">*</span></label>
											{{ Form::text('name', $permission->name, array('class'=>'form-control', 'id'=>'name')) }}
										</div>
									</div>
								</div>
							</div>
							<div class="kt-portlet__foot">
								<div class="kt-form__actions">
									<button type="submit" class="btn btn-primary">Enviar</button>
									<button type="reset" class="btn btn-secondary">Cancelar</button>
								</div>
							</div>
						{!! Form::close(); !!}
					</div>
				</div>
			</div>
		</div>
	</div>
@endsection
@section('js')
	<script src="{{ asset('panel/assets/vendors/general/jquery-validation/dist/jquery.validate.js') }}" type="text/javascript"></script>
	<script>
		$('#permission_form').attr('autocomplete', 'off');
		$("input:text:visible:first").focus();
		$().ready(function() {
            $("#permission_form").validate({
                rules: {
                    name: { required: true },
                },
                messages: {
                    name: "El rol es requerido.",
                }
            });
        });
	</script>
@endsection