@extends('layouts.panel.base')
@section('title', 'Actualoizar Perfil')
@section('content')
	<div class="kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor">
		<div class="kt-subheader   kt-grid__item" id="kt_subheader">
			<div class="kt-subheader__main">
				<h3 class="kt-subheader__title">Perfil</h3>
				<span class="kt-subheader__separator kt-hidden"></span>
				<div class="kt-subheader__breadcrumbs">
					<a href="{{ route('panel.dashboard') }}" class="kt-subheader__breadcrumbs-home"><i class="flaticon2-shelter"></i></a>
					<span class="kt-subheader__breadcrumbs-separator"></span>
					<a href="{{ route('panel.profile.edit') }}" class="kt-subheader__breadcrumbs-link">
						Actualizar
					</a>
				</div>
			</div>
		</div>
		<div class="kt-content  kt-grid__item kt-grid__item--fluid" id="kt_content">
			<div class="row">
				<div class="col-lg-12">
					<div class="kt-portlet">
						<div class="kt-portlet__head">
							<div class="kt-portlet__head-label">
								<h3 class="kt-portlet__head-title">
									Actualizar datos del usuario
								</h3>
							</div>
						</div>
						{!! Form::open(['route' => ['panel.profile.update', Crypt::encrypt($user->id)], 'method' => 'PUT', 'class'=>"kt-form", 'id' => 'profile_form']) !!}
							{{ csrf_field() }}
							@if(count($errors) > 0)
	                            <div class="alert alert-danger" role="alert" style="margin: 10px;">
	                                <ul style="margin-top: 0; margin-bottom: 0rem;">
	                                   @foreach($errors->all() as $error)
	                                       <li>{!! $error !!}</li>
	                                   @endforeach
	                                </ul>                        
	                            </div>
		                    @endif
		                    @if (Session::has('error'))
	                            <div class="alert alert-danger" role="alert" style="margin: 10px;">
	                                <div class="alert-text">{{ Session::get('error') }}</div>
	                            </div>
		                    @endif
		                    @if (Session::has('success'))
	                            <div class="alert alert-success" role="alert" style="margin: 10px;">
	                                <div class="alert-text">{{ Session::get('success') }}</div>
	                            </div>
		                    @endif
							<div class="kt-portlet__body">
								<div class="form-group form-group-last">
									<div class="alert alert-warning" role="alert">
										<div class="alert-icon"><i style="color: #111111 !important;" class="flaticon-warning kt-font-brand"></i></div>
										<div class="alert-text">
											Si no desea realizar cambios en su contraseña, puede dejar dichos campos vacíos.
										</div>
									</div>
								</div>
								<div class="row">
									<div class="col-lg-4">
										<div class="form-group">
											<label>Email</label>
											{{ Form::email('email', $user->email, array('class'=>'form-control', 'id'=>'email', 'disabled')) }}
										</div>
									</div>
									<div class="col-lg-4">
										<div class="form-group">
											<label>Nombre</label>
											{{ Form::text('name', $user->name, array('class'=>'form-control', 'id'=>'name')) }}
										</div>
									</div>
									<div class="col-lg-4">
										<div class="form-group">
											<label>Apellido</label>
											{{ Form::text('last_name', $user->last_name, array('class'=>'form-control', 'id'=>'last_name')) }}
										</div>
									</div>
								</div>
								<div class="row">
									<div class="col-lg-6">
										<div class="form-group">
											<label>Contraseña anterior</label>
											{{ Form::password('current_password', array('class'=>'form-control', 'id'=>'current_password')) }}
										</div>
									</div>
									<div class="col-lg-6">
										<div class="form-group">
											<label>Contraseña nueva</label>
											{{ Form::password('new_password', array('class'=>'form-control', 'id'=>'new_password')) }}
										</div>
									</div>
								</div>
							</div>
							<div class="kt-portlet__foot">
								<div class="kt-form__actions">
									<button type="submit" class="btn btn-primary">Enviar</button>
									<button type="reset" class="btn btn-secondary">Cancelar</button>
								</div>
							</div>
						{!! Form::close(); !!}
					</div>
				</div>
			</div>
		</div>
	</div>
@endsection
@section('js')
	<script src="{{ asset('panel/assets/vendors/general/jquery-validation/dist/jquery.validate.js') }}" type="text/javascript"></script>
	<script>
		$('#profile_form').attr('autocomplete', 'off');
		$().ready(function() {
            $("#profile_form").validate({
                rules: {
                    name: { required: true },
                    last_name: { required: true },
                },
                messages: {
                    name: "El nombre es requerido.",
                    last_name: "El apellido es requerido.",
                }
            });
        });
	</script>
@endsection